import { _ as __nuxt_component_0 } from './nuxt-link-BoGiFznF.mjs';
import { u as useRoute, a as __nuxt_component_1 } from './server.mjs';
import { defineComponent, ref, watch, mergeProps, unref, withCtx, createBlock, createTextVNode, openBlock, createVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate, ssrRenderAttr, ssrRenderStyle, ssrRenderList, ssrRenderComponent } from 'vue/server-renderer';
import '../nitro/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';
import 'vue-router';

const _imports_0 = "data:image/svg+xml,%3c?xml%20version='1.0'%20encoding='UTF-8'?%3e%3c!--%20Generator:%20Adobe%20Illustrator%2025.0.0,%20SVG%20Export%20Plug-In%20.%20SVG%20Version:%206.00%20Build%200)%20--%3e%3csvg%20xmlns='http://www.w3.org/2000/svg'%20xmlns:xlink='http://www.w3.org/1999/xlink'%20version='1.1'%20id='Capa_1'%20x='0px'%20y='0px'%20viewBox='0%200%20512%20512'%20style='enable-background:new%200%200%20512%20512;'%20xml:space='preserve'%20width='512'%20height='512'%3e%3cg%3e%3cpath%20d='M117.333,234.667C52.532,234.667,0,182.135,0,117.333S52.532,0,117.333,0s117.333,52.532,117.333,117.333%20C234.596,182.106,182.106,234.596,117.333,234.667z%20M117.333,64C87.878,64,64,87.878,64,117.333s23.878,53.333,53.333,53.333%20s53.333-23.878,53.333-53.333S146.789,64,117.333,64z'/%3e%3cpath%20d='M394.667,234.667c-64.801,0-117.333-52.532-117.333-117.333S329.865,0,394.667,0S512,52.532,512,117.333%20C511.929,182.106,459.439,234.596,394.667,234.667z%20M394.667,64c-29.455,0-53.333,23.878-53.333,53.333%20s23.878,53.333,53.333,53.333S448,146.789,448,117.333S424.122,64,394.667,64z'/%3e%3cpath%20d='M117.333,512C52.532,512,0,459.468,0,394.667s52.532-117.333,117.333-117.333s117.333,52.532,117.333,117.333%20C234.596,459.439,182.106,511.929,117.333,512z%20M117.333,341.333C87.878,341.333,64,365.211,64,394.667S87.878,448,117.333,448%20s53.333-23.878,53.333-53.333S146.789,341.333,117.333,341.333z'/%3e%3cpath%20d='M394.667,512c-64.801,0-117.333-52.532-117.333-117.333s52.532-117.333,117.333-117.333S512,329.865,512,394.667%20C511.929,459.439,459.439,511.929,394.667,512z%20M394.667,341.333c-29.455,0-53.333,23.878-53.333,53.333S365.211,448,394.667,448%20S448,424.122,448,394.667S424.122,341.333,394.667,341.333z'/%3e%3c/g%3e%3c/svg%3e";
const _imports_1 = "data:image/svg+xml,%3c?xml%20version='1.0'%20encoding='UTF-8'?%3e%3csvg%20xmlns='http://www.w3.org/2000/svg'%20id='Layer_1'%20data-name='Layer%201'%20viewBox='0%200%2024%2024'%20width='512'%20height='512'%3e%3cpath%20d='M12,0C5.383,0,0,5.383,0,12s5.383,12,12,12,12-5.383,12-12S18.617,0,12,0Zm0,22c-5.514,0-10-4.486-10-10S6.486,2,12,2s10,4.486,10,10-4.486,10-10,10Zm4-8c0,1.654-1.346,3-3,3v1c0,.553-.447,1-1,1s-1-.447-1-1v-1h-.268c-1.067,0-2.063-.574-2.598-1.499-.277-.479-.113-1.09,.364-1.366,.479-.279,1.091-.113,1.366,.364,.179,.31,.511,.501,.867,.501h2.268c.552,0,1-.448,1-1,0-.378-.271-.698-.644-.76l-3.041-.507c-1.342-.223-2.315-1.373-2.315-2.733,0-1.654,1.346-3,3-3v-1c0-.552,.447-1,1-1s1,.448,1,1v1h.268c1.067,0,2.063,.575,2.598,1.5,.277,.478,.113,1.089-.364,1.366-.48,.277-1.091,.113-1.366-.365-.179-.309-.511-.5-.867-.5h-2.268c-.552,0-1,.449-1,1,0,.378,.271,.698,.644,.76l3.041,.507c1.342,.223,2.315,1.373,2.315,2.733Z'/%3e%3c/svg%3e";
const _imports_2 = "data:image/svg+xml,%3csvg%20id='Layer_1'%20height='512'%20viewBox='0%200%2024%2024'%20width='512'%20xmlns='http://www.w3.org/2000/svg'%20data-name='Layer%201'%3e%3cpath%20d='m1.717%2014.7%204.133%209.3h2.456a2.752%202.752%200%200%200%202.514-3.868l-2.281-5.132h2.461a5.006%205.006%200%200%201%205%205h2v-20h-2a5.006%205.006%200%200%201%20-5%205h-8a3%203%200%200%200%20-3%203v4a3%203%200%200%200%201.717%202.7zm7.275%206.243a.751.751%200%200%201%20-.686%201.057h-1.156l-3.111-7h2.311zm-6.992-12.943a1%201%200%200%201%201-1h8a6.973%206.973%200%200%200%205-2.111v10.222a6.973%206.973%200%200%200%20-5-2.111h-8a1%201%200%200%201%20-1-1zm20.293%207.707-2.288-2.288%201.414-1.414%202.288%202.288zm-.836-7.75-1.414-1.414%202.25-2.25%201.414%201.414zm-.457%201.043h3v2h-3z'/%3e%3c/svg%3e";
const _imports_3 = "data:image/svg+xml,%3c?xml%20version='1.0'%20encoding='UTF-8'?%3e%3csvg%20xmlns='http://www.w3.org/2000/svg'%20id='Layer_1'%20data-name='Layer%201'%20viewBox='0%200%2024%2024'%3e%3cpath%20d='m17,0H7C4.243,0,2,2.243,2,5v15c0,1.137.486,2.224,1.333,2.981.412.368,1.044.335,1.412-.078.368-.411.333-1.044-.078-1.412-.424-.379-.667-.923-.667-1.491,0-1.103.897-2,2-2h.006l.032,5.347c0,.623.791.89,1.169.395l1.331-1.743,1.331,1.743c.378.495,1.169.228,1.169-.395l-.032-5.347h8.994v1c0,1.654-1.346,3-3,3h-3c-.553,0-1,.447-1,1s.447,1,1,1h3c2.757,0,5-2.243,5-5V5c0-2.757-2.243-5-5-5ZM4,16.537V5c0-1.304.836-2.415,2-2.828v13.828c-.728,0-1.411.196-2,.537Zm4-.537V2h9c1.654,0,3,1.346,3,3v11h-12Z'/%3e%3c/svg%3e";
const _imports_4 = "data:image/svg+xml,%3csvg%20id='Layer_1'%20viewBox='0%200%2024%2024'%20xmlns='http://www.w3.org/2000/svg'%20data-name='Layer%201'%3e%3cpath%20d='m23%200h-22c-.552%200-1%20.448-1%201s.448%201%201%201v11c0%202.757%202.243%205%205%205h5v2.277c-.595.346-1%20.984-1%201.723%200%201.105.895%202%202%202s2-.895%202-2c0-.738-.405-1.376-1-1.723v-2.277h5c2.757%200%205-2.243%205-5v-11c.552%200%201-.448%201-1s-.448-1-1-1zm-2%2013c0%201.654-1.346%203-3%203h-12c-1.654%200-3-1.346-3-3v-11h18zm-12%201h6c1.654%200%203-1.346%203-3v-3c0-1.654-1.346-3-3-3h-1.862c-.208%200-.409-.064-.579-.185t0%200l-.369-.261c-.51-.362-1.111-.554-1.737-.554h-1.453c-1.654%200-3%201.346-3%203v4c0%201.654%201.346%203%203%203zm7-3c0%20.551-.449%201-1%201h-6c-.551%200-1-.449-1-1v-3h8z'/%3e%3c/svg%3e";
const _imports_5 = "data:image/svg+xml,%3c?xml%20version='1.0'%20encoding='UTF-8'?%3e%3csvg%20xmlns='http://www.w3.org/2000/svg'%20id='Layer_1'%20data-name='Layer%201'%20viewBox='0%200%2024%2024'%3e%3cpath%20d='m23.018,8.785c-.596-.543-1.375-.812-2.169-.782-.804.038-1.544.387-2.085.981l-3.217,3.534c-.551-.909-1.551-1.519-2.689-1.519H3c-1.654,0-3,1.346-3,3v7c0,1.654,1.346,3,3,3h10.448l9.787-10.984c1.094-1.227.996-3.124-.218-4.23Zm-1.275,2.899l-9.19,10.315H3c-.552,0-1-.448-1-1v-7c0-.552.448-1,1-1h9.857c.63,0,1.143.513,1.143,1.143,0,.564-.421,1.051-.98,1.13l-5.161.737.283,1.98,5.161-.737c1.175-.168,2.129-.988,2.514-2.059l4.426-4.864c.182-.199.431-.316.7-.329.269-.02.528.081.728.263.408.371.44,1.009.072,1.421ZM6,2.5c0-1.381,1.119-2.5,2.5-2.5s2.5,1.119,2.5,2.5-1.119,2.5-2.5,2.5-2.5-1.119-2.5-2.5Zm0,6.5h-2v-.5c0-1.379,1.121-2.5,2.5-2.5h4c1.379,0,2.5,1.121,2.5,2.5v.5h-2v-.5c0-.275-.225-.5-.5-.5h-4c-.275,0-.5.225-.5.5v.5Z'/%3e%3c/svg%3e";
const _imports_6 = "data:image/svg+xml,%3c?xml%20version='1.0'%20encoding='UTF-8'?%3e%3csvg%20xmlns='http://www.w3.org/2000/svg'%20id='Layer_1'%20data-name='Layer%201'%20viewBox='0%200%2024%2024'%20width='512'%20height='512'%3e%3cpath%20d='M15,6c0-3.309-2.691-6-6-6S3,2.691,3,6s2.691,6,6,6,6-2.691,6-6Zm-6,4c-2.206,0-4-1.794-4-4s1.794-4,4-4,4,1.794,4,4-1.794,4-4,4Zm-.008,4.938c.068,.548-.32,1.047-.869,1.116-3.491,.436-6.124,3.421-6.124,6.946,0,.552-.448,1-1,1s-1-.448-1-1c0-4.531,3.386-8.37,7.876-8.93,.542-.069,1.047,.32,1.116,.869Zm13.704,4.195l-.974-.562c.166-.497,.278-1.019,.278-1.572s-.111-1.075-.278-1.572l.974-.562c.478-.276,.642-.888,.366-1.366-.277-.479-.887-.644-1.366-.366l-.973,.562c-.705-.794-1.644-1.375-2.723-1.594v-1.101c0-.552-.448-1-1-1s-1,.448-1,1v1.101c-1.079,.22-2.018,.801-2.723,1.594l-.973-.562c-.48-.277-1.09-.113-1.366,.366-.276,.479-.112,1.09,.366,1.366l.974,.562c-.166,.497-.278,1.019-.278,1.572s.111,1.075,.278,1.572l-.974,.562c-.478,.276-.642,.888-.366,1.366,.186,.321,.521,.5,.867,.5,.169,0,.341-.043,.499-.134l.973-.562c.705,.794,1.644,1.375,2.723,1.594v1.101c0,.552,.448,1,1,1s1-.448,1-1v-1.101c1.079-.22,2.018-.801,2.723-1.594l.973,.562c.158,.091,.33,.134,.499,.134,.346,0,.682-.179,.867-.5,.276-.479,.112-1.09-.366-1.366Zm-5.696,.866c-1.654,0-3-1.346-3-3s1.346-3,3-3,3,1.346,3,3-1.346,3-3,3Z'/%3e%3c/svg%3e";
const _imports_7 = "data:image/svg+xml,%3csvg%20id='Layer_1'%20viewBox='0%200%2024%2024'%20xmlns='http://www.w3.org/2000/svg'%20data-name='Layer%201'%3e%3cpath%20d='m12%201c-7.71%200-11%203.29-11%2011s3.29%2011%2011%2011%2011-3.29%2011-11-3.29-11-11-11zm-4.293%2019.475c.377-1.544%201.37-2.475%204.293-2.475s3.917.931%204.293%202.475c-1.176.357-2.594.525-4.293.525s-3.117-.168-4.293-.525zm10.413-.845c-1.012-3.217-3.916-3.631-6.119-3.631s-5.107.413-6.119%203.631c-2.028-1.35-2.881-3.774-2.881-7.631-.001-6.56%202.438-8.999%208.999-8.999s9%202.439%209%209c0%203.857-.853%206.281-2.881%207.631zm-6.12-13.63c-2.691%200-4%201.309-4%204s1.309%204%204%204%204-1.309%204-4-1.309-4-4-4zm0%206c-1.589%200-2-.411-2-2s.411-2%202-2%202%20.411%202%202-.411%202-2%202z'/%3e%3c/svg%3e";
const _imports_8 = "data:image/svg+xml,%3c?xml%20version='1.0'%20encoding='UTF-8'?%3e%3csvg%20xmlns='http://www.w3.org/2000/svg'%20id='Layer_1'%20data-name='Layer%201'%20viewBox='0%200%2024%2024'%3e%3cpath%20d='m23.63,16.862l-2.03-7.973c-.356.073-.723.111-1.1.111-.733,0-1.431-.147-2.072-.408l2.14,8.408H3.419l2.291-8.955c.66-2.971,3.247-5.045,6.29-5.045,1.076,0,2.105.27,3.013.748-.004-.083-.013-.164-.013-.248,0-.993.269-1.923.731-2.729-1.154-.498-2.419-.771-3.731-.771C7.54,0,3.75,3.041,2.793,7.348L.321,17.011c-.153.702.035,1.47.503,2.053.478.596,1.188.937,1.951.937h4.142c.563,2.293,2.617,4,5.084,4s4.521-1.707,5.084-4h4.128c.789,0,1.515-.36,1.99-.986.407-.535.562-1.193.472-1.846-.004-.101-.019-.204-.045-.306Zm-6.63-13.362c0-1.93,1.57-3.5,3.5-3.5s3.5,1.57,3.5,3.5-1.57,3.5-3.5,3.5-3.5-1.57-3.5-3.5Z'/%3e%3c/svg%3e";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "[slug]",
  __ssrInlineRender: true,
  setup(__props) {
    const route = useRoute();
    const slug = route.params.slug;
    const sidebarCollapsed = ref(false);
    const showUserMenu = ref(false);
    const showNotifications = ref(false);
    const showMobileMenu = ref(false);
    watch(
      sidebarCollapsed,
      (newValue) => {
        localStorage.setItem("sidebarCollapsed", JSON.stringify(newValue));
      },
      { immediate: false }
    );
    const getCustomerData = (slug2) => {
      const customers = {
        demo: {
          id: "1",
          email: "demo@example.com",
          password: "",
          subscriptionTier: "Pro",
          seatLimit: 10,
          seatUsage: 5,
          isActive: true,
          isLocked: false,
          slug: "demo",
          companyName: "",
          logo: "/images/salonimpuls-logo-white.svg",
          kundentyp: "",
          createdAt: /* @__PURE__ */ new Date(),
          updatedAt: /* @__PURE__ */ new Date(),
          modules: ["financial", "marketing", "elearning", "projects"]
        },
        customer1: {
          id: "1",
          email: "customer1@example.com",
          password: "",
          subscriptionTier: "Pro",
          seatLimit: 10,
          seatUsage: 5,
          isActive: true,
          isLocked: false,
          slug: "customer1",
          companyName: "",
          logo: "/images/salonimpuls-logo-white.svg",
          kundentyp: "",
          createdAt: /* @__PURE__ */ new Date("2024-01-15"),
          updatedAt: /* @__PURE__ */ new Date(),
          modules: ["financial", "marketing", "elearning", "projects"]
        },
        customer2: {
          id: "2",
          email: "customer2@example.com",
          password: "",
          subscriptionTier: "Basic",
          seatLimit: 5,
          seatUsage: 2,
          isActive: true,
          isLocked: false,
          slug: "customer2",
          companyName: "",
          logo: "/images/salonimpuls-logo-white.svg",
          kundentyp: "",
          createdAt: /* @__PURE__ */ new Date("2024-01-20"),
          updatedAt: /* @__PURE__ */ new Date(),
          modules: ["financial", "marketing"]
        },
        customer3: {
          id: "3",
          email: "customer3@example.com",
          password: "",
          subscriptionTier: "Advanced",
          seatLimit: 15,
          seatUsage: 8,
          isActive: false,
          isLocked: true,
          slug: "customer3",
          companyName: "",
          logo: "/images/salonimpuls-logo-white.svg",
          kundentyp: "",
          createdAt: /* @__PURE__ */ new Date("2024-01-25"),
          updatedAt: /* @__PURE__ */ new Date(),
          modules: ["financial", "marketing", "elearning", "projects"]
        }
      };
      return customers[slug2] || customers["demo"];
    };
    const customer = ref(getCustomerData(slug));
    const kpis = ref({
      totalRevenue: 125e3,
      activeProjects: 8,
      teamMembers: 12,
      tasksCompleted: 45
    });
    const notifications = ref([
      {
        id: "1",
        title: "New Invoice Created",
        message: "Invoice #INV-001 has been created and sent to client",
        createdAt: new Date(Date.now() - 1e3 * 60 * 30)
        // 30 minutes ago
      },
      {
        id: "2",
        title: "Project Deadline Approaching",
        message: 'Project "Website Redesign" is due in 2 days',
        createdAt: new Date(Date.now() - 1e3 * 60 * 60 * 2)
        // 2 hours ago
      },
      {
        id: "3",
        title: "Team Member Added",
        message: "John Doe has been added to your team",
        createdAt: new Date(Date.now() - 1e3 * 60 * 60 * 24)
        // 1 day ago
      }
    ]);
    const formatTime = (date) => {
      const now = /* @__PURE__ */ new Date();
      const diff = now.getTime() - date.getTime();
      const minutes = Math.floor(diff / (1e3 * 60));
      const hours = Math.floor(diff / (1e3 * 60 * 60));
      const days = Math.floor(diff / (1e3 * 60 * 60 * 24));
      if (minutes < 60) return `${minutes}m ago`;
      if (hours < 24) return `${hours}h ago`;
      return `${days}d ago`;
    };
    const getPageTitle = () => {
      const path = route.path;
      if (path.includes("/financial")) return "Financial Dashboard";
      if (path.includes("/marketing")) return "Marketing Dashboard";
      if (path.includes("/elearning")) return "E-Learning Dashboard";
      if (path.includes("/projects")) return "Projects Dashboard";
      if (path.includes("/onboarding")) return "Onboarding Dashboard";
      if (path.includes("/settings")) return "Settings";
      if (path.includes("/profile")) return "Profile";
      return "Dashboard";
    };
    const getPageSubtitle = () => {
      var _a;
      const path = route.path;
      if (path.includes("/financial"))
        return "Manage your financial data and Zoho Books integration";
      if (path.includes("/marketing"))
        return "Campaign management and lead tracking";
      if (path.includes("/elearning"))
        return "Training courses and skill development";
      if (path.includes("/projects")) return "Project management and task tracking";
      if (path.includes("/onboarding"))
        return "Create tutorials and manage employee onboarding";
      if (path.includes("/settings"))
        return "Manage your account settings and preferences";
      if (path.includes("/profile")) return "Manage your profile information";
      return `Welcome back, ${((_a = customer.value) == null ? void 0 : _a.companyName) || "Customer"}`;
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d;
      const _component_NuxtLink = __nuxt_component_0;
      const _component_NuxtPage = __nuxt_component_1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "customer-dashboard" }, _attrs))}>`);
      if (unref(showMobileMenu)) {
        _push(`<div class="mobile-overlay"></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([{ collapsed: unref(sidebarCollapsed), open: unref(showMobileMenu) }, "modern-sidebar"])}"><div class="sidebar-header"><div class="sidebar-brand"><div class="brand-logo"><div class="logo-icon"><svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg></div>`);
      if (!unref(sidebarCollapsed)) {
        _push(`<div class="brand-text"><h1 class="brand-title">SI Dashboard</h1>`);
        if ((_a = unref(customer)) == null ? void 0 : _a.companyName) {
          _push(`<p class="brand-subtitle">${ssrInterpolate(unref(customer).companyName)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (!unref(showMobileMenu)) {
        _push(`<button class="collapse-toggle"><svg class="collapse-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7"></path></svg></button>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(showMobileMenu)) {
        _push(`<button class="mobile-close"><svg class="close-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><nav class="sidebar-navigation"><div class="nav-section">`);
      if (!unref(sidebarCollapsed)) {
        _push(`<div class="nav-section-title">Main</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([{ active: _ctx.$route.path === `/c/${unref(slug)}` }, "nav-item"])}"><div class="nav-icon-wrapper"><img${ssrRenderAttr("src", _imports_0)} alt="Dashboard" class="nav-icon"></div>`);
      if (!unref(sidebarCollapsed)) {
        _push(`<span class="nav-label">Dashboard</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="${ssrRenderClass([{ active: _ctx.$route.path.startsWith(`/c/${unref(slug)}/financial`) }, "nav-item"])}"><div class="nav-icon-wrapper"><img${ssrRenderAttr("src", _imports_1)} alt="Financial" class="nav-icon"></div>`);
      if (!unref(sidebarCollapsed)) {
        _push(`<span class="nav-label">Financial</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="${ssrRenderClass([{ active: _ctx.$route.path.startsWith(`/c/${unref(slug)}/marketing`) }, "nav-item"])}"><div class="nav-icon-wrapper"><img${ssrRenderAttr("src", _imports_2)} alt="Marketing" class="nav-icon"></div>`);
      if (!unref(sidebarCollapsed)) {
        _push(`<span class="nav-label">Marketing</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="${ssrRenderClass([{ active: _ctx.$route.path.startsWith(`/c/${unref(slug)}/elearning`) }, "nav-item"])}"><div class="nav-icon-wrapper"><img${ssrRenderAttr("src", _imports_3)} alt="E-Learning" class="nav-icon"></div>`);
      if (!unref(sidebarCollapsed)) {
        _push(`<span class="nav-label">E-Learning</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="${ssrRenderClass([{ active: _ctx.$route.path.startsWith(`/c/${unref(slug)}/projects`) }, "nav-item"])}"><div class="nav-icon-wrapper"><img${ssrRenderAttr("src", _imports_4)} alt="Projects" class="nav-icon"></div>`);
      if (!unref(sidebarCollapsed)) {
        _push(`<span class="nav-label">Projects</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="${ssrRenderClass([{ active: _ctx.$route.path.startsWith(`/c/${unref(slug)}/onboarding`) }, "nav-item"])}"><div class="nav-icon-wrapper"><img${ssrRenderAttr("src", _imports_5)} alt="Onboarding" class="nav-icon"></div>`);
      if (!unref(sidebarCollapsed)) {
        _push(`<span class="nav-label">Onboarding</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="nav-section">`);
      if (!unref(sidebarCollapsed)) {
        _push(`<div class="nav-section-title">Account</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([{ active: _ctx.$route.path.startsWith(`/c/${unref(slug)}/settings`) }, "nav-item"])}"><div class="nav-icon-wrapper"><img${ssrRenderAttr("src", _imports_6)} alt="Settings" class="nav-icon"></div>`);
      if (!unref(sidebarCollapsed)) {
        _push(`<span class="nav-label">Settings</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="${ssrRenderClass([{ active: _ctx.$route.path.startsWith(`/c/${unref(slug)}/profile`) }, "nav-item"])}"><div class="nav-icon-wrapper"><img${ssrRenderAttr("src", _imports_7)} alt="Profile" class="nav-icon"></div>`);
      if (!unref(sidebarCollapsed)) {
        _push(`<span class="nav-label">Profile</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></nav></div><div class="${ssrRenderClass([{ "sidebar-collapsed": unref(sidebarCollapsed) }, "main-content"])}"><div class="content-header wide-header"><div class="header-main wide-header-main"><div class="header-left"><div class="header-title-section"><h1 class="page-title">${ssrInterpolate(getPageTitle())}</h1><p class="page-subtitle">${ssrInterpolate(getPageSubtitle())}</p></div><button class="mobile-menu-btn"><svg class="expand-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg></button></div><div class="header-right"><div class="header-actions"><div class="notification-btn-wrapper"><button class="notification-btn"><img${ssrRenderAttr("src", _imports_8)} alt="Notifications" class="notification-icon">`);
      if (unref(notifications).length > 0) {
        _push(`<span class="notification-badge">${ssrInterpolate(unref(notifications).length)}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button><div style="${ssrRenderStyle(unref(showNotifications) ? null : { display: "none" })}" class="notifications-dropdown"><div class="notifications-header"><h3 class="notifications-title">Notifications</h3><button class="close-notifications-btn"><svg class="close-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="notifications-content">`);
      if (unref(notifications).length === 0) {
        _push(`<div class="no-notifications"><svg class="no-notifications-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5 5v-5zM4.828 7l2.586 2.586a2 2 0 002.828 0L12.828 7H4.828z"></path></svg><p>No notifications</p></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--[-->`);
      ssrRenderList(unref(notifications), (notification) => {
        _push(`<div class="notification-item"><div class="notification-content"><div class="notification-dot"></div><div class="notification-details"><p class="notification-title">${ssrInterpolate(notification.title)}</p><p class="notification-message">${ssrInterpolate(notification.message)}</p><p class="notification-time">${ssrInterpolate(formatTime(notification.createdAt))}</p></div></div></div>`);
      });
      _push(`<!--]--></div></div></div><div class="user-menu-wrapper"><button class="user-menu-btn"><div class="user-avatar">${ssrInterpolate(((_c = (_b = unref(customer)) == null ? void 0 : _b.companyName) == null ? void 0 : _c.charAt(0)) || "C")}</div><span class="user-name">${ssrInterpolate(((_d = unref(customer)) == null ? void 0 : _d.companyName) || "Customer")}</span><svg class="dropdown-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg></button><div style="${ssrRenderStyle(unref(showUserMenu) ? null : { display: "none" })}" class="user-dropdown">`);
      _push(ssrRenderComponent(_component_NuxtLink, {
        to: `/c/${unref(slug)}/profile`,
        class: "dropdown-item",
        onClick: ($event) => showUserMenu.value = false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<svg class="dropdown-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"${_scopeId}></path></svg> My Profile `);
          } else {
            return [
              (openBlock(), createBlock("svg", {
                class: "dropdown-icon",
                fill: "none",
                stroke: "currentColor",
                viewBox: "0 0 24 24"
              }, [
                createVNode("path", {
                  "stroke-linecap": "round",
                  "stroke-linejoin": "round",
                  "stroke-width": "2",
                  d: "M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"
                })
              ])),
              createTextVNode(" My Profile ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_NuxtLink, {
        to: `/c/${unref(slug)}/settings`,
        class: "dropdown-item",
        onClick: ($event) => showUserMenu.value = false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<svg class="dropdown-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"${_scopeId}></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"${_scopeId}></path></svg> Settings `);
          } else {
            return [
              (openBlock(), createBlock("svg", {
                class: "dropdown-icon",
                fill: "none",
                stroke: "currentColor",
                viewBox: "0 0 24 24"
              }, [
                createVNode("path", {
                  "stroke-linecap": "round",
                  "stroke-linejoin": "round",
                  "stroke-width": "2",
                  d: "M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"
                }),
                createVNode("path", {
                  "stroke-linecap": "round",
                  "stroke-linejoin": "round",
                  "stroke-width": "2",
                  d: "M15 12a3 3 0 11-6 0 3 3 0 016 0z"
                })
              ])),
              createTextVNode(" Settings ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<hr class="dropdown-divider"><button class="dropdown-item logout-btn"><svg class="dropdown-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg> Logout </button></div></div></div></div></div></div><div class="content-body">`);
      if (_ctx.$route.path !== `/c/${unref(slug)}`) {
        _push(ssrRenderComponent(_component_NuxtPage, null, null, _parent));
      } else {
        _push(`<div><div class="kpi-grid mb-8"><div class="kpi-card modern-card"><div class="kpi-icon-wrapper revenue-icon"><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path></svg></div><div class="kpi-content"><div class="kpi-value"> \u20AC${ssrInterpolate(unref(kpis).totalRevenue.toLocaleString())}</div><div class="kpi-label">Total Revenue</div><div class="kpi-change positive"><svg class="change-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 17l9.2-9.2M17 17V7H7"></path></svg> +12% from last month </div></div></div><div class="kpi-card modern-card"><div class="kpi-icon-wrapper projects-icon"><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path></svg></div><div class="kpi-content"><div class="kpi-value">${ssrInterpolate(unref(kpis).activeProjects)}</div><div class="kpi-label">Active Projects</div><div class="kpi-change positive"><svg class="change-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 17l9.2-9.2M17 17V7H7"></path></svg> +3 new projects </div></div></div><div class="kpi-card modern-card"><div class="kpi-icon-wrapper team-icon"><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg></div><div class="kpi-content"><div class="kpi-value">${ssrInterpolate(unref(kpis).teamMembers)}</div><div class="kpi-label">Team Members</div><div class="kpi-change">No change</div></div></div><div class="kpi-card modern-card"><div class="kpi-icon-wrapper tasks-icon"><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg></div><div class="kpi-content"><div class="kpi-value">${ssrInterpolate(unref(kpis).tasksCompleted)}</div><div class="kpi-label">Tasks Completed</div><div class="kpi-change positive"><svg class="change-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 17l9.2-9.2M17 17V7H7"></path></svg> +25% this week </div></div></div><div class="kpi-card modern-card"><div class="kpi-icon-wrapper marketing-icon"><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg></div><div class="kpi-content"><div class="kpi-value">2.4M</div><div class="kpi-label">Social Media Views</div><div class="kpi-change positive"><svg class="change-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 17l9.2-9.2M17 17V7H7"></path></svg> +18% this month </div></div></div><div class="kpi-card modern-card"><div class="kpi-icon-wrapper elearning-icon"><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg></div><div class="kpi-content"><div class="kpi-value">85%</div><div class="kpi-label">Course Completion</div><div class="kpi-change positive"><svg class="change-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 17l9.2-9.2M17 17V7H7"></path></svg> +8% this week </div></div></div></div><div class="charts-section mb-8"><div class="grid grid-cols-1 lg:grid-cols-2 gap-6"><div class="chart-card"><div class="chart-header"><h3 class="chart-title">Revenue Trend</h3><div class="chart-period"><span class="period-active">Last 6 Months</span></div></div><div class="chart-content"><div class="revenue-chart"><div class="chart-bars"><div class="chart-bar" style="${ssrRenderStyle({ "height": "60%" })}"><span class="bar-value">\u20AC45K</span></div><div class="chart-bar" style="${ssrRenderStyle({ "height": "75%" })}"><span class="bar-value">\u20AC58K</span></div><div class="chart-bar" style="${ssrRenderStyle({ "height": "85%" })}"><span class="bar-value">\u20AC68K</span></div><div class="chart-bar" style="${ssrRenderStyle({ "height": "70%" })}"><span class="bar-value">\u20AC55K</span></div><div class="chart-bar" style="${ssrRenderStyle({ "height": "90%" })}"><span class="bar-value">\u20AC72K</span></div><div class="chart-bar" style="${ssrRenderStyle({ "height": "95%" })}"><span class="bar-value">\u20AC78K</span></div></div><div class="chart-labels"><span>Jan</span><span>Feb</span><span>Mar</span><span>Apr</span><span>May</span><span>Jun</span></div></div></div></div><div class="chart-card"><div class="chart-header"><h3 class="chart-title">Project Status</h3><div class="chart-legend"><div class="legend-item"><span class="legend-color completed"></span><span>Completed</span></div><div class="legend-item"><span class="legend-color in-progress"></span><span>In Progress</span></div><div class="legend-item"><span class="legend-color pending"></span><span>Pending</span></div></div></div><div class="chart-content"><div class="project-status-chart"><div class="status-circle"><div class="status-segment completed" style="${ssrRenderStyle({ "--percentage": "60" })}"></div><div class="status-segment in-progress" style="${ssrRenderStyle({ "--percentage": "30" })}"></div><div class="status-segment pending" style="${ssrRenderStyle({ "--percentage": "10" })}"></div><div class="status-center"><span class="status-total">12</span><span class="status-label">Projects</span></div></div><div class="status-details"><div class="status-item"><span class="status-count">7</span><span class="status-text">Completed</span></div><div class="status-item"><span class="status-count">4</span><span class="status-text">In Progress</span></div><div class="status-item"><span class="status-count">1</span><span class="status-text">Pending</span></div></div></div></div></div></div></div><div class="metrics-section mb-8"><h2 class="section-title">Performance Metrics</h2><div class="metrics-grid"><div class="metric-card"><div class="metric-header"><div class="metric-icon social-icon"><svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.174-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.741.099.12.112.225.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.402.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.357-.629-2.746-1.378l-.748 2.853c-.271 1.043-1.002 2.35-1.492 3.146C9.57 23.812 10.763 24.009 12.017 24.009c6.624 0 11.99-5.367 11.99-11.988C24.007 5.367 18.641.001.012.001z"></path></svg></div><h4 class="metric-title">Social Media</h4></div><div class="metric-content"><div class="metric-value">2.4M</div><div class="metric-label">Total Views</div><div class="metric-change positive">+18% this month</div></div></div><div class="metric-card"><div class="metric-header"><div class="metric-icon elearning-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg></div><h4 class="metric-title">E-Learning</h4></div><div class="metric-content"><div class="metric-value">85%</div><div class="metric-label">Course Completion</div><div class="metric-change positive">+8% this week</div></div></div><div class="metric-card"><div class="metric-header"><div class="metric-icon team-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg></div><h4 class="metric-title">Team Productivity</h4></div><div class="metric-content"><div class="metric-value">92%</div><div class="metric-label">Efficiency Rate</div><div class="metric-change positive">+5% this month</div></div></div><div class="metric-card"><div class="metric-header"><div class="metric-icon satisfaction-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path></svg></div><h4 class="metric-title">Customer Satisfaction</h4></div><div class="metric-content"><div class="metric-value">4.8/5</div><div class="metric-label">Average Rating</div><div class="metric-change positive">+0.2 this quarter</div></div></div></div></div><div class="modules-section"><h2 class="modules-title">Available Modules</h2><div class="module-grid">`);
        _push(ssrRenderComponent(_component_NuxtLink, {
          to: `/c/${unref(slug)}/financial`,
          class: "module-card"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="module-icon"${_scopeId}><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"${_scopeId}></path></svg></div><h3 class="module-title"${_scopeId}>Financial</h3><p class="module-description"${_scopeId}> Manage invoices, expenses, and financial reports </p>`);
            } else {
              return [
                createVNode("div", { class: "module-icon" }, [
                  (openBlock(), createBlock("svg", {
                    class: "w-6 h-6",
                    fill: "none",
                    stroke: "currentColor",
                    viewBox: "0 0 24 24"
                  }, [
                    createVNode("path", {
                      "stroke-linecap": "round",
                      "stroke-linejoin": "round",
                      "stroke-width": "2",
                      d: "M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"
                    })
                  ]))
                ]),
                createVNode("h3", { class: "module-title" }, "Financial"),
                createVNode("p", { class: "module-description" }, " Manage invoices, expenses, and financial reports ")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_NuxtLink, {
          to: `/c/${unref(slug)}/marketing`,
          class: "module-card"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="module-icon"${_scopeId}><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"${_scopeId}></path></svg></div><h3 class="module-title"${_scopeId}>Marketing</h3><p class="module-description"${_scopeId}> Campaign management and lead tracking </p>`);
            } else {
              return [
                createVNode("div", { class: "module-icon" }, [
                  (openBlock(), createBlock("svg", {
                    class: "w-6 h-6",
                    fill: "none",
                    stroke: "currentColor",
                    viewBox: "0 0 24 24"
                  }, [
                    createVNode("path", {
                      "stroke-linecap": "round",
                      "stroke-linejoin": "round",
                      "stroke-width": "2",
                      d: "M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"
                    })
                  ]))
                ]),
                createVNode("h3", { class: "module-title" }, "Marketing"),
                createVNode("p", { class: "module-description" }, " Campaign management and lead tracking ")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_NuxtLink, {
          to: `/c/${unref(slug)}/elearning`,
          class: "module-card"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="module-icon"${_scopeId}><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"${_scopeId}></path></svg></div><h3 class="module-title"${_scopeId}>E-Learning</h3><p class="module-description"${_scopeId}> Training courses and skill development </p>`);
            } else {
              return [
                createVNode("div", { class: "module-icon" }, [
                  (openBlock(), createBlock("svg", {
                    class: "w-6 h-6",
                    fill: "none",
                    stroke: "currentColor",
                    viewBox: "0 0 24 24"
                  }, [
                    createVNode("path", {
                      "stroke-linecap": "round",
                      "stroke-linejoin": "round",
                      "stroke-width": "2",
                      d: "M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"
                    })
                  ]))
                ]),
                createVNode("h3", { class: "module-title" }, "E-Learning"),
                createVNode("p", { class: "module-description" }, " Training courses and skill development ")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_NuxtLink, {
          to: `/c/${unref(slug)}/projects`,
          class: "module-card"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="module-icon"${_scopeId}><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"${_scopeId}></path></svg></div><h3 class="module-title"${_scopeId}>Projects</h3><p class="module-description"${_scopeId}> Project management and task tracking </p>`);
            } else {
              return [
                createVNode("div", { class: "module-icon" }, [
                  (openBlock(), createBlock("svg", {
                    class: "w-6 h-6",
                    fill: "none",
                    stroke: "currentColor",
                    viewBox: "0 0 24 24"
                  }, [
                    createVNode("path", {
                      "stroke-linecap": "round",
                      "stroke-linejoin": "round",
                      "stroke-width": "2",
                      d: "M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"
                    })
                  ]))
                ]),
                createVNode("h3", { class: "module-title" }, "Projects"),
                createVNode("p", { class: "module-description" }, " Project management and task tracking ")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_NuxtLink, {
          to: `/c/${unref(slug)}/onboarding`,
          class: "module-card"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="module-icon"${_scopeId}><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"${_scopeId}></path></svg></div><h3 class="module-title"${_scopeId}>Onboarding</h3><p class="module-description"${_scopeId}> Create tutorials and manage employee onboarding </p>`);
            } else {
              return [
                createVNode("div", { class: "module-icon" }, [
                  (openBlock(), createBlock("svg", {
                    class: "w-6 h-6",
                    fill: "none",
                    stroke: "currentColor",
                    viewBox: "0 0 24 24"
                  }, [
                    createVNode("path", {
                      "stroke-linecap": "round",
                      "stroke-linejoin": "round",
                      "stroke-width": "2",
                      d: "M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"
                    })
                  ]))
                ]),
                createVNode("h3", { class: "module-title" }, "Onboarding"),
                createVNode("p", { class: "module-description" }, " Create tutorials and manage employee onboarding ")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div>`);
      }
      _push(`</div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/c/[slug].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=_slug_-O5tTmTeE.mjs.map
