import { defineComponent, ref, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderList, ssrRenderClass, ssrIncludeBooleanAttr, ssrLooseContain, ssrLooseEqual, ssrRenderStyle, ssrRenderAttr } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "elearning",
  __ssrInlineRender: true,
  setup(__props) {
    const activeTab = ref("courses");
    const showCreateCourseModal = ref(false);
    const showCreateCertificateModal = ref(false);
    ref(false);
    const courseFilter = ref("");
    const difficultyFilter = ref("");
    const selectedUser = ref("");
    const certificateSearch = ref("");
    const tabs = [
      { id: "courses", name: "Course Library" },
      { id: "progress", name: "Progress Tracking" },
      { id: "certificates", name: "Certificates" }
    ];
    const elearningData = ref({
      courses: [
        {
          id: "1",
          title: "Digital Marketing Fundamentals",
          description: "Learn the basics of digital marketing including SEO, social media, and content marketing.",
          duration: 8,
          difficulty: "beginner",
          category: "Marketing",
          isPublished: true,
          modules: [
            {
              id: "1",
              title: "Introduction to Digital Marketing",
              type: "video",
              duration: 30,
              content: "",
              order: 1
            },
            {
              id: "2",
              title: "SEO Basics",
              type: "video",
              duration: 45,
              content: "",
              order: 2
            },
            {
              id: "3",
              title: "Social Media Marketing",
              type: "video",
              duration: 60,
              content: "",
              order: 3
            }
          ]
        },
        {
          id: "2",
          title: "Advanced Project Management",
          description: "Master advanced project management techniques and tools for complex projects.",
          duration: 12,
          difficulty: "advanced",
          category: "Business",
          isPublished: true,
          modules: [
            {
              id: "4",
              title: "Project Planning",
              type: "video",
              duration: 45,
              content: "",
              order: 1
            },
            {
              id: "5",
              title: "Risk Management",
              type: "video",
              duration: 60,
              content: "",
              order: 2
            },
            {
              id: "6",
              title: "Team Leadership",
              type: "video",
              duration: 50,
              content: "",
              order: 3
            }
          ]
        },
        {
          id: "3",
          title: "Web Development Basics",
          description: "Introduction to web development using HTML, CSS, and JavaScript.",
          duration: 15,
          difficulty: "beginner",
          category: "Technology",
          isPublished: true,
          modules: [
            {
              id: "7",
              title: "HTML Fundamentals",
              type: "video",
              duration: 90,
              content: "",
              order: 1
            },
            {
              id: "8",
              title: "CSS Styling",
              type: "video",
              duration: 120,
              content: "",
              order: 2
            },
            {
              id: "9",
              title: "JavaScript Basics",
              type: "video",
              duration: 150,
              content: "",
              order: 3
            }
          ]
        }
      ],
      progress: [
        {
          id: "1",
          userId: "1",
          courseId: "1",
          moduleId: "1",
          progress: 100,
          completedAt: /* @__PURE__ */ new Date("2024-01-20")
        },
        {
          id: "2",
          userId: "1",
          courseId: "1",
          moduleId: "2",
          progress: 75,
          completedAt: void 0
        },
        {
          id: "3",
          userId: "2",
          courseId: "2",
          moduleId: "4",
          progress: 100,
          completedAt: /* @__PURE__ */ new Date("2024-01-18")
        }
      ],
      certificates: [
        {
          id: "1",
          userId: "1",
          courseId: "1",
          issuedAt: /* @__PURE__ */ new Date("2024-01-20"),
          pdfUrl: "/certificates/cert-001.pdf"
        },
        {
          id: "2",
          userId: "2",
          courseId: "2",
          issuedAt: /* @__PURE__ */ new Date("2024-01-18"),
          pdfUrl: "/certificates/cert-002.pdf"
        }
      ]
    });
    const users = ref([
      { id: "1", name: "John Smith", email: "john@example.com" },
      { id: "2", name: "Sarah Johnson", email: "sarah@example.com" },
      { id: "3", name: "Mike Wilson", email: "mike@example.com" }
    ]);
    const newCourse = ref({
      title: "",
      description: "",
      category: "",
      difficulty: "",
      duration: 1
    });
    const newCertificate = ref({
      courseId: "",
      userId: ""
    });
    const filteredCourses = computed(() => {
      let courses = elearningData.value.courses;
      if (courseFilter.value) {
        courses = courses.filter((c) => c.category === courseFilter.value);
      }
      if (difficultyFilter.value) {
        courses = courses.filter((c) => c.difficulty === difficultyFilter.value);
      }
      return courses;
    });
    const filteredProgress = computed(() => {
      let progress = elearningData.value.progress;
      if (selectedUser.value) {
        progress = progress.filter((p) => p.userId === selectedUser.value);
      }
      return progress;
    });
    const filteredCertificates = computed(() => {
      let certificates = elearningData.value.certificates;
      if (certificateSearch.value) {
        certificates = certificates.filter(
          (c) => getCourseTitle(c.courseId).toLowerCase().includes(certificateSearch.value.toLowerCase()) || getUserName(c.userId).toLowerCase().includes(certificateSearch.value.toLowerCase())
        );
      }
      return certificates;
    });
    const formatDate = (date) => {
      return new Intl.DateTimeFormat("en-US", {
        year: "numeric",
        month: "short",
        day: "numeric"
      }).format(date);
    };
    const getDifficultyBadgeClass = (difficulty) => {
      switch (difficulty) {
        case "beginner":
          return "badge-success";
        case "intermediate":
          return "badge-warning";
        case "advanced":
          return "badge-error";
        default:
          return "badge-info";
      }
    };
    const getCourseTitle = (courseId) => {
      const course = elearningData.value.courses.find((c) => c.id === courseId);
      return course ? course.title : "Unknown Course";
    };
    const getUserName = (userId) => {
      const user = users.value.find((u) => u.id === userId);
      return user ? user.name : "Unknown User";
    };
    const getTotalProgress = () => {
      const totalProgress = elearningData.value.progress.reduce(
        (sum, p) => sum + p.progress,
        0
      );
      const totalItems = elearningData.value.progress.length;
      return totalItems > 0 ? Math.round(totalProgress / totalItems) : 0;
    };
    const getCompletedCourses = () => {
      const completedModules = elearningData.value.progress.filter(
        (p) => p.progress === 100
      );
      const uniqueCourses = new Set(completedModules.map((p) => p.courseId));
      return uniqueCourses.size;
    };
    const getCourseProgress = (courseId) => {
      const progressData = {
        "1": 75,
        "2": 45,
        "3": 90,
        "4": 30,
        "5": 60,
        "6": 100
      };
      return progressData[courseId] || 0;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "elearning-module" }, _attrs))}><div class="content-body"><div class="kpi-grid mb-8"><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(unref(elearningData).courses.length)}</div><div class="kpi-label">Total Courses</div><div class="kpi-change positive">+2 this month</div></div><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(getTotalProgress())}%</div><div class="kpi-label">Average Progress</div><div class="kpi-change positive">+5% this week</div></div><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(unref(elearningData).certificates.length)}</div><div class="kpi-label">Certificates Issued</div><div class="kpi-change positive">+3 this month</div></div><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(getCompletedCourses())}</div><div class="kpi-label">Completed Courses</div><div class="kpi-change positive">+1 this week</div></div></div><div class="tabs-container card mb-8"><div class="tabs-header"><!--[-->`);
      ssrRenderList(tabs, (tab) => {
        _push(`<button class="${ssrRenderClass([{ active: unref(activeTab) === tab.id }, "tab-button"])}">${ssrInterpolate(tab.name)}</button>`);
      });
      _push(`<!--]--></div><div class="tabs-content">`);
      if (unref(activeTab) === "courses") {
        _push(`<div class="tab-pane"><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Recent Courses</h3><div class="flex gap-2"><select class="form-select"><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(courseFilter)) ? ssrLooseContain(unref(courseFilter), "") : ssrLooseEqual(unref(courseFilter), "")) ? " selected" : ""}>All Categories</option><option value="Business"${ssrIncludeBooleanAttr(Array.isArray(unref(courseFilter)) ? ssrLooseContain(unref(courseFilter), "Business") : ssrLooseEqual(unref(courseFilter), "Business")) ? " selected" : ""}>Business</option><option value="Technology"${ssrIncludeBooleanAttr(Array.isArray(unref(courseFilter)) ? ssrLooseContain(unref(courseFilter), "Technology") : ssrLooseEqual(unref(courseFilter), "Technology")) ? " selected" : ""}>Technology</option><option value="Marketing"${ssrIncludeBooleanAttr(Array.isArray(unref(courseFilter)) ? ssrLooseContain(unref(courseFilter), "Marketing") : ssrLooseEqual(unref(courseFilter), "Marketing")) ? " selected" : ""}>Marketing</option><option value="Design"${ssrIncludeBooleanAttr(Array.isArray(unref(courseFilter)) ? ssrLooseContain(unref(courseFilter), "Design") : ssrLooseEqual(unref(courseFilter), "Design")) ? " selected" : ""}>Design</option></select><select class="form-select"><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(difficultyFilter)) ? ssrLooseContain(unref(difficultyFilter), "") : ssrLooseEqual(unref(difficultyFilter), "")) ? " selected" : ""}>All Levels</option><option value="beginner"${ssrIncludeBooleanAttr(Array.isArray(unref(difficultyFilter)) ? ssrLooseContain(unref(difficultyFilter), "beginner") : ssrLooseEqual(unref(difficultyFilter), "beginner")) ? " selected" : ""}>Beginner</option><option value="intermediate"${ssrIncludeBooleanAttr(Array.isArray(unref(difficultyFilter)) ? ssrLooseContain(unref(difficultyFilter), "intermediate") : ssrLooseEqual(unref(difficultyFilter), "intermediate")) ? " selected" : ""}>Intermediate</option><option value="advanced"${ssrIncludeBooleanAttr(Array.isArray(unref(difficultyFilter)) ? ssrLooseContain(unref(difficultyFilter), "advanced") : ssrLooseEqual(unref(difficultyFilter), "advanced")) ? " selected" : ""}>Advanced</option></select></div></div><div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 lg:gap-6"><!--[-->`);
        ssrRenderList(unref(filteredCourses), (course) => {
          _push(`<div class="card"><div class="card-body"><div class="flex items-start justify-between mb-4"><div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center"><svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg></div><span class="${ssrRenderClass([getDifficultyBadgeClass(course.difficulty), "badge"])}">${ssrInterpolate(course.difficulty)}</span></div><h4 class="font-semibold text-lg mb-2">${ssrInterpolate(course.title)}</h4><p class="text-gray-600 text-sm mb-4">${ssrInterpolate(course.description)}</p><div class="flex items-center justify-between text-sm text-gray-500 mb-3"><span>${ssrInterpolate(course.duration)} hours</span><span>${ssrInterpolate(course.modules.length)} modules</span></div><div class="mb-4"><div class="flex items-center justify-between text-sm mb-1"><span class="text-gray-600">Progress</span><span class="font-medium">${ssrInterpolate(getCourseProgress(course.id))}%</span></div><div class="w-full bg-gray-200 rounded-full h-2"><div class="bg-blue-600 h-2 rounded-full transition-all duration-300" style="${ssrRenderStyle({ width: getCourseProgress(course.id) + "%" })}"></div></div></div><div class="flex items-center justify-center"><button class="btn btn-primary" title="View Course"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg></button></div></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "progress") {
        _push(`<div class="tab-pane"><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Recent Progress</h3><select class="form-select"><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(selectedUser)) ? ssrLooseContain(unref(selectedUser), "") : ssrLooseEqual(unref(selectedUser), "")) ? " selected" : ""}>All Users</option><!--[-->`);
        ssrRenderList(unref(users), (user) => {
          _push(`<option${ssrRenderAttr("value", user.id)}${ssrIncludeBooleanAttr(Array.isArray(unref(selectedUser)) ? ssrLooseContain(unref(selectedUser), user.id) : ssrLooseEqual(unref(selectedUser), user.id)) ? " selected" : ""}>${ssrInterpolate(user.name)}</option>`);
        });
        _push(`<!--]--></select></div><div class="table-responsive"><table class="data-table"><thead><tr><th>Course</th><th>Student</th><th>Progress</th><th>Last Activity</th><th>Status</th><th>Actions</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(unref(filteredProgress), (progress) => {
          _push(`<tr><td class="font-medium">${ssrInterpolate(getCourseTitle(progress.courseId))}</td><td>${ssrInterpolate(getUserName(progress.userId))}</td><td><div class="progress-container"><div class="progress-bar"><div class="progress-fill" style="${ssrRenderStyle({ width: `${progress.progress}%` })}"></div></div><span class="progress-text">${ssrInterpolate(progress.progress)}%</span></div></td><td>${ssrInterpolate(progress.completedAt ? formatDate(progress.completedAt) : "In Progress")}</td><td><span class="${ssrRenderClass([
            progress.progress === 100 ? "badge-success" : "badge-warning",
            "badge"
          ])}">${ssrInterpolate(progress.progress === 100 ? "Completed" : "In Progress")}</span></td><td><div class="table-actions"><button class="btn btn-sm btn-outline"> View </button><button class="btn btn-sm btn-outline"> Update </button></div></td></tr>`);
        });
        _push(`<!--]--></tbody></table></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "certificates") {
        _push(`<div class="tab-pane"><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Recent Certificates</h3><div class="flex gap-2"><input${ssrRenderAttr("value", unref(certificateSearch))} type="text" placeholder="Search certificates..." class="form-input"></div></div><div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 lg:gap-6"><!--[-->`);
        ssrRenderList(unref(filteredCertificates), (certificate) => {
          _push(`<div class="card"><div class="card-body text-center"><div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4"><svg class="w-8 h-8 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path></svg></div><h4 class="font-semibold text-lg mb-2">${ssrInterpolate(getCourseTitle(certificate.courseId))}</h4><p class="text-gray-600 text-sm mb-4">${ssrInterpolate(getUserName(certificate.userId))}</p><p class="text-xs text-gray-500 mb-4"> Issued: ${ssrInterpolate(formatDate(certificate.issuedAt))}</p><div class="flex items-center justify-center gap-2"><button class="btn btn-primary" title="Download Certificate"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg></button><button class="btn btn-outline btn-sm" title="View Certificate"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg></button></div></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
      if (unref(showCreateCourseModal)) {
        _push(`<div class="modal-overlay"><div class="modal"><div class="modal-header"><h3 class="text-lg font-semibold">Create New Course</h3><button class="text-gray-400 hover:text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><form><div class="form-group"><label class="form-label">Course Title</label><input${ssrRenderAttr("value", unref(newCourse).title)} type="text" class="form-input" required></div><div class="form-group"><label class="form-label">Description</label><textarea class="form-textarea" required>${ssrInterpolate(unref(newCourse).description)}</textarea></div><div class="form-group"><label class="form-label">Category</label><select class="form-select" required><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(newCourse).category) ? ssrLooseContain(unref(newCourse).category, "") : ssrLooseEqual(unref(newCourse).category, "")) ? " selected" : ""}>Select Category</option><option value="Business"${ssrIncludeBooleanAttr(Array.isArray(unref(newCourse).category) ? ssrLooseContain(unref(newCourse).category, "Business") : ssrLooseEqual(unref(newCourse).category, "Business")) ? " selected" : ""}>Business</option><option value="Technology"${ssrIncludeBooleanAttr(Array.isArray(unref(newCourse).category) ? ssrLooseContain(unref(newCourse).category, "Technology") : ssrLooseEqual(unref(newCourse).category, "Technology")) ? " selected" : ""}>Technology</option><option value="Marketing"${ssrIncludeBooleanAttr(Array.isArray(unref(newCourse).category) ? ssrLooseContain(unref(newCourse).category, "Marketing") : ssrLooseEqual(unref(newCourse).category, "Marketing")) ? " selected" : ""}>Marketing</option><option value="Design"${ssrIncludeBooleanAttr(Array.isArray(unref(newCourse).category) ? ssrLooseContain(unref(newCourse).category, "Design") : ssrLooseEqual(unref(newCourse).category, "Design")) ? " selected" : ""}>Design</option></select></div><div class="form-group"><label class="form-label">Difficulty Level</label><select class="form-select" required><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(newCourse).difficulty) ? ssrLooseContain(unref(newCourse).difficulty, "") : ssrLooseEqual(unref(newCourse).difficulty, "")) ? " selected" : ""}>Select Level</option><option value="beginner"${ssrIncludeBooleanAttr(Array.isArray(unref(newCourse).difficulty) ? ssrLooseContain(unref(newCourse).difficulty, "beginner") : ssrLooseEqual(unref(newCourse).difficulty, "beginner")) ? " selected" : ""}>Beginner</option><option value="intermediate"${ssrIncludeBooleanAttr(Array.isArray(unref(newCourse).difficulty) ? ssrLooseContain(unref(newCourse).difficulty, "intermediate") : ssrLooseEqual(unref(newCourse).difficulty, "intermediate")) ? " selected" : ""}>Intermediate</option><option value="advanced"${ssrIncludeBooleanAttr(Array.isArray(unref(newCourse).difficulty) ? ssrLooseContain(unref(newCourse).difficulty, "advanced") : ssrLooseEqual(unref(newCourse).difficulty, "advanced")) ? " selected" : ""}>Advanced</option></select></div><div class="form-group"><label class="form-label">Duration (hours)</label><input${ssrRenderAttr("value", unref(newCourse).duration)} type="number" class="form-input" min="1" required></div></form></div><div class="modal-footer"><button class="btn btn-outline" title="Cancel"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button><button class="btn btn-primary" title="Create Course"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg></button></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(showCreateCertificateModal)) {
        _push(`<div class="modal-overlay"><div class="modal"><div class="modal-header"><h3 class="text-lg font-semibold">Issue Certificate</h3><button class="text-gray-400 hover:text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><form><div class="form-group"><label class="form-label">Course</label><select class="form-select" required><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(newCertificate).courseId) ? ssrLooseContain(unref(newCertificate).courseId, "") : ssrLooseEqual(unref(newCertificate).courseId, "")) ? " selected" : ""}>Select Course</option><!--[-->`);
        ssrRenderList(unref(elearningData).courses, (course) => {
          _push(`<option${ssrRenderAttr("value", course.id)}${ssrIncludeBooleanAttr(Array.isArray(unref(newCertificate).courseId) ? ssrLooseContain(unref(newCertificate).courseId, course.id) : ssrLooseEqual(unref(newCertificate).courseId, course.id)) ? " selected" : ""}>${ssrInterpolate(course.title)}</option>`);
        });
        _push(`<!--]--></select></div><div class="form-group"><label class="form-label">Student</label><select class="form-select" required><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(newCertificate).userId) ? ssrLooseContain(unref(newCertificate).userId, "") : ssrLooseEqual(unref(newCertificate).userId, "")) ? " selected" : ""}>Select Student</option><!--[-->`);
        ssrRenderList(unref(users), (user) => {
          _push(`<option${ssrRenderAttr("value", user.id)}${ssrIncludeBooleanAttr(Array.isArray(unref(newCertificate).userId) ? ssrLooseContain(unref(newCertificate).userId, user.id) : ssrLooseEqual(unref(newCertificate).userId, user.id)) ? " selected" : ""}>${ssrInterpolate(user.name)}</option>`);
        });
        _push(`<!--]--></select></div></form></div><div class="modal-footer"><button class="btn btn-outline" title="Cancel"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button><button class="btn btn-primary" title="Issue Certificate"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg></button></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/c/[slug]/elearning.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=elearning-Dzi7ZaDg.mjs.map
