import { a as buildAssetsURL } from '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import '../nitro/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import 'vue/server-renderer';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'vue';
import 'unhead/plugins';

const fonts = "@font-face{font-display:swap;font-family:SF Pro Display;font-style:normal;font-weight:400;src:url(" + buildAssetsURL("SFPRODISPLAYREGULAR.DF_3XEGl.OTF") + ') format("opentype")}@font-face{font-display:swap;font-family:SF Pro Display;font-style:normal;font-weight:500;src:url(' + buildAssetsURL("SFPRODISPLAYMEDIUM.DSttQARu.OTF") + ') format("opentype")}@font-face{font-display:swap;font-family:SF Pro Display;font-style:normal;font-weight:700;src:url(' + buildAssetsURL("SFPRODISPLAYBOLD.CkqE-6tD.OTF") + ') format("opentype")}*{font-family:SF Pro Display,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen,Ubuntu,Cantarell,sans-serif}.font-light,.font-normal{font-weight:400}.font-medium,.font-semibold{font-weight:500}.font-black,.font-bold,.font-extrabold{font-weight:700}.text-xs{font-size:.75rem;line-height:1rem}.text-sm{font-size:.875rem;line-height:1.25rem}.text-base{font-size:1rem;line-height:1.5rem}.text-lg{font-size:1.125rem}.text-lg,.text-xl{line-height:1.75rem}.text-xl{font-size:1.25rem}.text-2xl{font-size:1.5rem;line-height:2rem}.text-3xl{font-size:1.875rem;line-height:2.25rem}.text-4xl{font-size:2.25rem;line-height:2.5rem}.text-5xl{font-size:3rem;line-height:1}h1,h2,h3,h4,h5,h6{font-family:SF Pro Display,sans-serif;font-weight:500;letter-spacing:-.025em;line-height:1.25;margin-bottom:.5rem}h1{font-size:2.25rem;font-weight:700}h2{font-size:1.875rem}h2,h3{font-weight:500}h3{font-size:1.5rem}h4{font-size:1.25rem;font-weight:500}h5{font-size:1.125rem}h5,h6{font-weight:400}h6{font-size:1rem}body{font-family:SF Pro Display,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif;font-weight:400;letter-spacing:-.011em;line-height:1.6}code,kbd,pre,samp{font-family:SF Mono,Monaco,Inconsolata,Roboto Mono,monospace}';

const base = ":root{--primary-color:#3b82f6;--primary-dark:#2563eb;--secondary-color:#64748b;--success-color:#10b981;--warning-color:#f59e0b;--error-color:#ef4444;--background-color:#f8fafc;--surface-color:#fff;--border-color:#e2e8f0;--text-primary:#1e293b;--text-secondary:#64748b;--text-muted:#94a3b8;--shadow-sm:0 1px 2px 0 rgba(0,0,0,.05);--shadow-md:0 4px 6px -1px rgba(0,0,0,.1),0 2px 4px -2px rgba(0,0,0,.1);--shadow-lg:0 10px 15px -3px rgba(0,0,0,.1),0 4px 6px -4px rgba(0,0,0,.1);--radius-sm:.375rem;--radius-md:.5rem;--radius-lg:.75rem}*{box-sizing:border-box;margin:0;padding:0}html{font-size:16px;line-height:1.6}body{background-color:var(--background-color);color:var(--text-primary);font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen,Ubuntu,Cantarell,sans-serif;overflow-x:hidden}h1,h2,h3,h4,h5,h6{font-weight:600;line-height:1.25;margin-bottom:.5rem}h1{font-size:2.25rem}h2{font-size:1.875rem}h3{font-size:1.5rem}h4{font-size:1.25rem}h5{font-size:1.125rem}h6{font-size:1rem}p{margin-bottom:1rem}";

const utilities = ".container{margin:0 auto;max-width:1200px;padding:0 1rem}.grid{display:grid;gap:1.5rem}.grid-cols-1{grid-template-columns:repeat(1,minmax(0,1fr))}.grid-cols-2{grid-template-columns:repeat(2,minmax(0,1fr))}.grid-cols-3{grid-template-columns:repeat(3,minmax(0,1fr))}.grid-cols-4{grid-template-columns:repeat(4,minmax(0,1fr))}.flex{display:flex}.flex-col{flex-direction:column}.items-center{align-items:center}.justify-between{justify-content:space-between}.justify-center{justify-content:center}.gap-2{gap:.5rem}.gap-4{gap:1rem}.gap-6{gap:1.5rem}.gap-1{gap:.25rem}.gap-3{gap:.75rem}.m-0{margin:0}.mb-4{margin-bottom:1rem}.mb-6{margin-bottom:1.5rem}.mb-8{margin-bottom:2rem}.p-4{padding:1rem}.p-6{padding:1.5rem}.px-4{padding-left:1rem;padding-right:1rem}.py-2{padding-bottom:.5rem;padding-top:.5rem}.text-primary{color:var(--text-primary)}.text-secondary{color:var(--text-secondary)}.text-muted{color:var(--text-muted)}.bg-white{background-color:#fff}.bg-primary{background-color:var(--primary-color)}.border{border:1px solid var(--border-color)}.rounded{border-radius:var(--radius-md)}.rounded-lg{border-radius:var(--radius-lg)}.shadow-sm{box-shadow:var(--shadow-sm)}.shadow-md{box-shadow:var(--shadow-md)}.shadow-lg{box-shadow:var(--shadow-lg)}.font-medium{font-weight:500}.font-semibold{font-weight:600}.font-bold{font-weight:700}.text-sm{font-size:.875rem}.text-base{font-size:1rem}.text-lg{font-size:1.125rem}.text-xl{font-size:1.25rem}.text-2xl{font-size:1.5rem}.text-3xl{font-size:1.875rem}@media (min-width:640px){.sm\\:grid-cols-2{grid-template-columns:repeat(2,minmax(0,1fr))}.sm\\:hidden{display:none}}@media (min-width:768px){.md\\:grid-cols-3{grid-template-columns:repeat(3,minmax(0,1fr))}.md\\:block{display:block}}@media (min-width:1024px){.lg\\:grid-cols-3{grid-template-columns:repeat(3,minmax(0,1fr))}.lg\\:grid-cols-4{grid-template-columns:repeat(4,minmax(0,1fr))}}";

const sidebar = ".modern-sidebar{background:#fff;border-right:1px solid #f1f5f9;display:flex;flex-direction:column;height:100vh;left:0;max-width:270px;min-width:270px;position:fixed;top:0;transition:all .3s cubic-bezier(.4,0,.2,1);width:270px;z-index:50}.modern-sidebar.collapsed{max-width:80px;min-width:80px;width:80px}.modern-sidebar.open{transform:translate(0)}.modern-sidebar .sidebar-header{background:linear-gradient(135deg,#fff,#fafbfc);border-bottom:1px solid #f1f5f9;min-height:72px;padding:1.25rem 1rem}.modern-sidebar .sidebar-header,.sidebar-brand{align-items:center;display:flex;justify-content:space-between}.sidebar-brand{width:100%}.brand-logo{flex:1;gap:.75rem}.brand-logo,.logo-icon{align-items:center;display:flex}.logo-icon{background:linear-gradient(135deg,#3b82f6,#1d4ed8);border-radius:8px;box-shadow:0 2px 8px #3b82f633;color:#fff;flex-shrink:0;height:36px;justify-content:center;width:36px}.brand-text{display:flex;flex-direction:column;gap:.125rem;min-width:0}.brand-title{color:#000;font-size:1rem;font-weight:600;margin:0;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.brand-subtitle{color:#000;font-size:.75rem;font-weight:500;margin:0}.collapse-toggle,.mobile-close{align-items:center;background:#0000000d;border:none;border-radius:8px;color:#000;cursor:pointer;display:flex;justify-content:center;padding:.5rem;transition:all .2s ease}.collapse-toggle:hover,.mobile-close:hover{background:#f1f5f9;border-color:#cbd5e1;color:#000}.close-icon,.collapse-icon{height:14px;transition:transform .2s ease;width:14px}.modern-sidebar.collapsed .collapse-icon{transform:rotate(180deg)}.modern-sidebar .sidebar-navigation{display:flex;flex:1;flex-direction:column;gap:.5rem;overflow-y:auto;padding:.75rem 0}.nav-section{display:flex;flex-direction:column;gap:.25rem}.nav-section-title{color:#64748b;font-size:.6875rem;font-weight:600;letter-spacing:.05em;margin-bottom:.25rem;margin-top:.5rem;padding:0 1rem;text-transform:uppercase}.modern-sidebar .nav-item{align-items:center;border-radius:8px;box-sizing:border-box;color:#000;cursor:pointer;display:flex;font-size:15px;gap:.75rem;margin:0 .5rem;padding:.625rem 1rem;position:relative;transition:all .2s ease;width:calc(100% - 1rem)}.modern-sidebar .nav-item:hover{background:#f8fafc;color:#000;transform:translate(2px)}.modern-sidebar .nav-item.active{background:#0000000d;color:#000}.nav-icon-wrapper{align-items:center;display:flex;flex-shrink:0;height:18px;justify-content:center;width:18px}.modern-sidebar .nav-icon{height:18px;transition:transform .2s ease;width:18px;stroke-width:2}.modern-sidebar .nav-item:hover .nav-icon{transform:scale(1.05)}.modern-sidebar .nav-item.active .nav-icon{stroke-width:2.5}.nav-label{font-weight:500;overflow:hidden;text-overflow:ellipsis;transition:opacity .3s ease;white-space:nowrap}.modern-sidebar.collapsed .nav-label,.modern-sidebar.collapsed .nav-section-title{opacity:0;overflow:hidden;width:0}.modern-sidebar.collapsed .nav-item{justify-content:center;margin:0 .25rem;padding:.625rem}.modern-sidebar.collapsed .brand-text{opacity:0;overflow:hidden;width:0}@media (max-width:768px){.modern-sidebar{box-shadow:2px 0 20px #0000001a;transform:translate(-100%);width:270px;z-index:50}.modern-sidebar.open{transform:translate(0)}.modern-sidebar.collapsed{max-width:270px;min-width:270px;width:270px}}@media (max-width:1024px){.modern-sidebar{max-width:260px;min-width:260px;width:260px}.modern-sidebar.collapsed{max-width:70px;min-width:70px;width:70px}}@media (prefers-color-scheme:dark){.modern-sidebar{background:#1e293b;border-right-color:#334155}.modern-sidebar .sidebar-header{background:linear-gradient(135deg,#1e293b,#334155);border-bottom-color:#334155}.brand-title{color:#f1f5f9}.brand-subtitle{color:#94a3b8}.collapse-toggle,.mobile-close{background:#334155;border-color:#475569;color:#cbd5e1}.collapse-toggle:hover,.mobile-close:hover{background:#475569;color:#f1f5f9}.nav-section-title{color:#64748b}.modern-sidebar .nav-item{color:#cbd5e1}.modern-sidebar .nav-item:hover{background:#334155;color:#f1f5f9}}";

const layout = ".customer-dashboard{background:#f8fafc;display:flex;min-height:100vh}.mobile-overlay{-webkit-backdrop-filter:blur(2px);backdrop-filter:blur(2px);background:#00000080;inset:0;position:fixed;z-index:40}.main-content{background:#f8fafc;flex:1;margin-left:270px;min-height:100vh;transition:all .3s cubic-bezier(.4,0,.2,1);width:calc(100% - 270px)}.main-content.sidebar-collapsed{margin-left:80px;width:calc(100% - 80px)}.content-header{background:#fff;border-bottom:1px solid #f1f5f9;padding:1.5rem 2rem;position:sticky;top:0;z-index:30}.owner-dashboard .content-header{min-height:44px!important;padding:.6rem 1rem!important}.owner-dashboard .content-header .text-3xl{font-size:1.6rem!important;line-height:1.1!important;margin-bottom:0!important}.owner-dashboard .content-header p{color:#64748b!important;font-size:.8rem!important;margin-top:.12rem!important}.owner-dashboard .content-header .header-actions .btn{font-size:.875rem!important;line-height:1!important;padding:.32rem .6rem!important}.owner-dashboard .content-header .header-actions .w-5.h-5,.owner-dashboard .content-header .header-actions svg{height:16px!important;width:16px!important}.owner-dashboard .content-header .header-actions>button>svg{display:none!important}.owner-dashboard .content-header .header-actions>button{background-image:none!important;box-shadow:none!important}.content-body{margin:0;max-width:none;padding:2rem}@media (max-width:640px){.content-body{padding:8px!important}.modern-sidebar{z-index:1002!important}.mobile-overlay{z-index:1000!important}}.wide-header{background:linear-gradient(135deg,#fff,#fafbfc);border-bottom:1px solid #e2e8f0;position:relative;width:100%;z-index:100}.wide-header-main{align-items:center;display:grid;gap:1.5rem;grid-template-columns:1fr auto;height:48px;margin:0 auto;min-height:48px;padding:.5rem 1rem;width:100%}.header-left{gap:1rem}.header-center,.header-left{align-items:center;display:flex}.header-center{justify-content:center}.header-right{align-items:center;display:flex;gap:1rem;justify-content:flex-end}.page-title{color:#000;font-size:1.25rem;font-weight:700;letter-spacing:-.025em;margin:0}.page-subtitle{color:#64748b;font-size:.75rem;font-weight:400;margin:0}.mobile-menu-btn{background:#f8fafc;border:1px solid #e2e8f0;border-radius:8px;color:#64748b;cursor:pointer;display:none;padding:.5rem;transition:all .2s ease}.mobile-menu-btn:hover{background:#f1f5f9;color:#475569}.customer-logo-section{align-items:center;background:#fff;border:1px solid #e2e8f0;border-radius:8px;display:flex;gap:.5rem;padding:.25rem .75rem}.customer-logo{border-radius:6px;flex-shrink:0;height:28px;overflow:hidden;width:28px}.customer-logo-image{height:100%;-o-object-fit:cover;object-fit:cover;width:100%}.logo-placeholder{align-items:center;background:linear-gradient(135deg,#3b82f6,#1d4ed8);color:#fff;display:flex;font-size:1.125rem;font-weight:600;height:100%;justify-content:center;width:100%}.customer-info{display:flex;flex-direction:column;gap:.125rem}.customer-name{color:#1e293b;font-size:.875rem;font-weight:600;margin:0}.customer-type{color:#64748b;font-size:.75rem;font-weight:500;margin:0}.header-actions{align-items:center;display:flex;gap:.75rem}.notification-btn-wrapper{position:relative}.notification-btn{background:#f8fafc;border:1px solid #e2e8f0;border-radius:6px;color:#64748b;cursor:pointer;padding:.375rem;position:relative;transition:all .2s ease}.notification-btn:hover{background:#f1f5f9;color:#475569}.notification-icon{height:20px;width:20px}.notification-badge{align-items:center;background:#ef4444;border-radius:50%;color:#fff;display:flex;font-size:.625rem;font-weight:600;height:18px;justify-content:center;position:absolute;right:-4px;top:-4px;width:18px}.notifications-dropdown{background:#fff;border:1px solid #e2e8f0;border-radius:12px;box-shadow:0 10px 25px #0000001a;margin-top:.5rem;position:absolute;right:0;top:100%;width:320px;z-index:50}.notifications-header{align-items:center;border-bottom:1px solid #f1f5f9;display:flex;justify-content:space-between;padding:1rem 1.5rem}.notifications-title{color:#1e293b;font-size:1rem;font-weight:600;margin:0}.close-notifications-btn{background:none;border:none;border-radius:4px;color:#64748b;cursor:pointer;padding:.25rem;transition:all .2s ease}.close-notifications-btn:hover{background:#f8fafc;color:#475569}.notifications-content{max-height:300px;overflow-y:auto}.no-notifications{color:#64748b;padding:2rem 1.5rem;text-align:center}.no-notifications-icon{height:48px;margin:0 auto 1rem;opacity:.5;width:48px}.notification-item{border-bottom:1px solid #f1f5f9;padding:1rem 1.5rem;transition:background .2s ease}.notification-item:last-child{border-bottom:none}.notification-item:hover{background:#f8fafc}.notification-content{display:flex;gap:.75rem}.notification-dot{background:#3b82f6;border-radius:50%;flex-shrink:0;height:8px;margin-top:.375rem;width:8px}.notification-details{flex:1}.notification-title{color:#1e293b;font-size:.875rem;font-weight:600;margin-bottom:.25rem}.notification-message{color:#64748b;font-size:.8125rem;line-height:1.4;margin-bottom:.25rem}.notification-time{color:#94a3b8;font-size:.75rem}.user-menu-wrapper{position:relative}.user-menu-btn{align-items:center;background:#f8fafc;border:1px solid #e2e8f0;border-radius:8px;color:#475569;cursor:pointer;display:flex;gap:.5rem;padding:.375rem .75rem;transition:all .2s ease}.user-menu-btn:hover{background:#f1f5f9;border-color:#cbd5e1}.user-avatar{align-items:center;background:linear-gradient(135deg,#3b82f6,#1d4ed8);border-radius:6px;color:#fff;display:flex;font-size:.875rem;font-weight:600;height:28px;justify-content:center;width:28px}.user-name{color:#1e293b;font-size:.875rem;font-weight:500}.dropdown-icon{color:#64748b;height:16px;width:16px}.user-dropdown{background:#fff;border:1px solid #e2e8f0;border-radius:12px;box-shadow:0 10px 25px #0000001a;margin-top:.5rem;overflow:hidden;position:absolute;right:0;top:100%;width:200px;z-index:50}.dropdown-item{align-items:center;color:#475569;display:flex;font-size:.875rem;font-weight:500;gap:.75rem;padding:.75rem 1rem;text-decoration:none;transition:all .2s ease}.dropdown-item:hover{background:#f8fafc;color:#1e293b}.dropdown-item.logout-btn{color:#ef4444}.dropdown-item.logout-btn:hover{background:#fef2f2;color:#dc2626}.dropdown-divider{background:#f1f5f9;height:1px;margin:.25rem 0}@media (max-width:1024px){.main-content{margin-left:260px;width:calc(100% - 260px)}.main-content.sidebar-collapsed{margin-left:70px;width:calc(100% - 70px)}.wide-header-main{gap:1.5rem;grid-template-columns:1fr auto}}@media (max-width:768px){.customer-dashboard{position:relative}.mobile-overlay{display:block}.mobile-menu-btn{display:flex}.main-content,.main-content.sidebar-collapsed{margin-left:0;width:100%}.wide-header-main{gap:1rem;grid-template-columns:auto 1fr;padding:1rem 1.5rem}.header-left{order:1}.header-right{order:2}.page-title{font-size:1.5rem}.page-subtitle{display:none}.content-body{padding:1rem}}@media (max-width:640px){.wide-header-main{gap:.75rem;grid-template-columns:auto 1fr}.header-right{display:none}}@media (prefers-color-scheme:dark){.customer-dashboard,.main-content{background:#0f172a}.content-header,.wide-header{background:#1e293b;border-bottom-color:#334155}.page-title{color:#f1f5f9}.page-subtitle{color:#94a3b8}.customer-logo-section{background:#1e293b;border-color:#334155}.customer-name{color:#f1f5f9}.customer-type{color:#94a3b8}.mobile-menu-btn,.notification-btn{background:#334155;border-color:#475569;color:#cbd5e1}.mobile-menu-btn:hover,.notification-btn:hover{background:#475569;color:#f1f5f9}.notifications-dropdown,.user-dropdown{background:#1e293b;border-color:#334155}.notification-title,.notifications-title{color:#f1f5f9}.notification-message{color:#cbd5e1}.user-menu-btn{background:#334155;border-color:#475569;color:#cbd5e1}.user-menu-btn:hover{background:#475569}.user-name{color:#f1f5f9}.dropdown-item{color:#cbd5e1}.dropdown-item:hover{background:#334155;color:#f1f5f9}}";

const main = `*{box-sizing:border-box;margin:0;padding:0}html{font-size:16px;line-height:1.6}body{background-color:#f8fafc;color:#1e293b;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen,Ubuntu,Cantarell,sans-serif;overflow-x:hidden}:root{--primary-color:#3b82f6;--primary-dark:#2563eb;--secondary-color:#64748b;--success-color:#10b981;--warning-color:#f59e0b;--error-color:#ef4444;--background-color:#f8fafc;--surface-color:#fff;--border-color:#e2e8f0;--text-primary:#1e293b;--text-secondary:#64748b;--text-muted:#94a3b8;--shadow-sm:0 1px 2px 0 rgba(0,0,0,.05);--shadow-md:0 4px 6px -1px rgba(0,0,0,.1),0 2px 4px -2px rgba(0,0,0,.1);--shadow-lg:0 10px 15px -3px rgba(0,0,0,.1),0 4px 6px -4px rgba(0,0,0,.1);--radius-sm:.375rem;--radius-md:.5rem;--radius-lg:.75rem}h1,h2,h3,h4,h5,h6{font-weight:600;line-height:1.25;margin-bottom:.5rem}h1{font-size:2.25rem}h2{font-size:1.875rem}h3{font-size:1.5rem}h4{font-size:1.25rem}h5{font-size:1.125rem}h6{font-size:1rem}p{margin-bottom:1rem}.container{margin:0 auto;max-width:1200px;padding:0 1rem}.grid{display:grid;gap:1.5rem}.grid-cols-1{grid-template-columns:repeat(1,minmax(0,1fr))}.grid-cols-2{grid-template-columns:repeat(2,minmax(0,1fr))}.grid-cols-3{grid-template-columns:repeat(3,minmax(0,1fr))}.grid-cols-4{grid-template-columns:repeat(4,minmax(0,1fr))}@media (min-width:640px){.sm\\:grid-cols-2{grid-template-columns:repeat(2,minmax(0,1fr))}}@media (min-width:1024px){.lg\\:grid-cols-3{grid-template-columns:repeat(3,minmax(0,1fr))}}.flex-col{flex-direction:column}.justify-center{justify-content:center}.gap-4{gap:1rem}.card{background:var(--surface-color);border:1px solid var(--border-color);border-radius:var(--radius-lg);box-shadow:var(--shadow-sm);overflow:hidden}.card-header{border-bottom:1px solid var(--border-color);padding:1.5rem}.card-header .relative .w-5.h-5,.card-header .relative svg{height:14px!important;width:14px!important}.relative{position:relative}.absolute{position:absolute}.owner-dashboard .card-header .relative{position:relative}.owner-dashboard .card-header .relative .w-5.h-5,.owner-dashboard .card-header .relative svg{color:#94a3b8!important;height:14px!important;left:.75rem!important;pointer-events:none!important;position:absolute!important;top:50%!important;transform:translateY(-50%)!important;width:14px!important}.owner-dashboard .card-header .relative .form-input,.owner-dashboard .card-header .relative input[type=text]{padding-left:2rem!important}.card-footer{background:#f8fafc;border-top:1px solid var(--border-color);padding:1rem 1.5rem}@media (max-width:640px){.card table thead{display:none}.card table,.card table tbody,.card table td,.card table tr{display:block;width:100%}.card table tbody tr{background:var(--surface-color);border:1px solid var(--border-color);border-radius:8px;margin-bottom:.75rem;padding:.5rem}.card table td{align-items:flex-start;border:none;display:flex;justify-content:space-between;padding:.5rem .75rem}.card table td:before{color:var(--text-secondary);content:attr(data-label);display:inline-block;font-weight:600;margin-right:.75rem;width:40%}.card table td .badge{margin-left:.5rem}.card table td[data-label=Actions]{padding-top:.5rem}.card table td[data-label=Actions] .flex{flex-wrap:wrap;gap:.5rem}}.form-group{margin-bottom:1rem}.form-label{color:var(--text-primary);display:block;font-weight:500;margin-bottom:.5rem}.form-input{border-radius:var(--radius-md);padding:.5rem .75rem;transition:border-color .2s ease}.form-select{border:1px solid var(--border-color);border-radius:var(--radius-md);padding:.5rem .75rem;width:100%}.suggestions-section .flex.flex-col.sm\\:flex-row .form-select,.suggestions-section .flex.sm\\:flex-row .form-select,.suggestions-section .form-select{display:inline-block!important;max-width:260px!important;min-width:140px!important;width:auto!important}@media (max-width:640px){.suggestions-section .form-select{min-width:0;width:100%!important}}.marketing-module .suggestions-section .grid,.suggestions-section .grid{gap:1rem!important;grid-template-columns:repeat(auto-fit,minmax(300px,1fr))!important}.suggestions-section .card{min-height:0}.suggestions-section .card .card-body{padding:.6rem!important}.suggestions-section .card .badge{font-size:.68rem!important;padding:.14rem .4rem!important}.suggestions-section .card .card-body h4{font-size:1rem!important;margin-bottom:.5rem!important}.suggestions-section .card .card-body p{font-size:.875rem!important;margin-bottom:.75rem!important}.suggestions-section .card .flex{gap:.5rem!important}.suggestions-section .card .card-body .flex.items-center.justify-between{align-items:flex-start!important}.suggestions-section .card .card-body .btn{margin-top:.5rem!important}.suggestions-section .card .flex{flex-wrap:wrap!important}.reviews-table{table-layout:auto!important;width:100%}.reviews-table td,.reviews-table th{overflow:hidden;text-overflow:ellipsis;vertical-align:top;white-space:nowrap}.reviews-table td:nth-child(3),.reviews-table th:nth-child(3){overflow-wrap:anywhere!important;white-space:normal!important}.reviews-table td:nth-child(6),.reviews-table th:nth-child(6){width:80px!important}.reviews-table td:nth-child(2),.reviews-table th:nth-child(2){width:70px!important}.reviews-table td:first-child,.reviews-table th:first-child{width:200px!important}.reviews-table td:nth-child(4),.reviews-table th:nth-child(4){width:120px!important}.reviews-table td:nth-child(5),.reviews-table th:nth-child(5){width:340px!important}.marketing-module .table-container{overflow-x:auto!important}.marketing-module .reviews-table{table-layout:auto!important;width:100%!important}.marketing-module .reviews-table td,.marketing-module .reviews-table th{box-sizing:border-box!important;overflow:hidden!important;text-overflow:ellipsis!important;vertical-align:top!important}.marketing-module .reviews-table td:first-child,.marketing-module .reviews-table th:first-child{width:200px!important}.marketing-module .reviews-table td:nth-child(2),.marketing-module .reviews-table th:nth-child(2){width:70px!important}.marketing-module .reviews-table td:nth-child(3),.marketing-module .reviews-table th:nth-child(3){overflow-wrap:anywhere!important;white-space:normal!important;width:auto!important}.marketing-module .reviews-table td:nth-child(4),.marketing-module .reviews-table th:nth-child(4){width:120px!important}.marketing-module .reviews-table td:nth-child(5),.marketing-module .reviews-table th:nth-child(5){width:340px!important}.marketing-module .reviews-table td:nth-child(6),.marketing-module .reviews-table th:nth-child(6){width:90px!important}.marketing-module .review-comment{max-width:100%!important;overflow-wrap:anywhere!important;white-space:normal!important}.reviews-list{list-style:none;margin:0;padding:0}.review-item{background:var(--card-bg,#fff);border:1px solid rgba(229,231,235,.9);border-radius:10px;margin-bottom:.8rem;padding:1rem!important}.review-avatar{display:none!important}.review-item .customer-name{font-size:.95rem}.review-item .review-comment{color:#334155;margin-top:.4rem}.review-item .suggestion-card.small{background:#3b82f60a;border-color:#3b82f61f;margin-bottom:.6rem}.review-item .suggestion-edit-card{margin-bottom:.6rem}.review-item .actions{margin-top:.6rem}.review-item .actions button{height:34px;min-width:34px}.review-action-btn,.review-item .actions button{align-items:center;display:inline-flex;justify-content:center}.review-action-btn{background:linear-gradient(180deg,#fff,#f8fafc);border:1px solid rgba(15,23,42,.06);border-radius:8px;box-shadow:0 1px 4px #0206170a;color:#0f172a;padding:.35rem .5rem;transition:all .12s ease-in-out}.review-action-btn svg{height:16px;width:16px}.review-action-btn:hover{box-shadow:0 6px 18px #0206170f;transform:translateY(-1px)}.suggestions-section .card .btn{align-items:center;background-image:none!important;border:none!important;border-radius:8px;box-shadow:none;display:inline-flex;font-size:.875rem;justify-content:center;padding:.42rem .75rem;transition:background-color .12s ease,transform .12s ease,box-shadow .12s ease}.suggestions-section .card .btn-primary{background-color:#2563eb;border:none!important;color:#fff}.suggestions-section .card .btn-primary:hover{background-color:#1e40af;box-shadow:0 8px 20px #2563eb1f;transform:translateY(-2px)}.suggestions-section .card .btn-secondary{background-color:#64748b;border:none!important;color:#fff}.suggestions-section .card .btn-secondary:hover{background-color:#475569;box-shadow:0 6px 18px #47556914;transform:translateY(-2px)}.suggestions-section .card .btn-success,.suggestions-section .card .btn-warning{background-color:#10b981;border:none!important;color:#fff}.settings-module .users-list-ul{list-style:none;margin:0;padding:0}.settings-module .user-item{background:var(--surface-color);border:1px solid var(--border-color);border-radius:10px;margin-bottom:.75rem}.settings-module .user-item .user-item-body{padding:.9rem!important}.settings-module .user-info .user-name{font-size:1rem;font-weight:600}.settings-module .user-info .user-email{color:var(--text-muted);font-size:.875rem}.settings-module .user-meta .badge{margin-right:.5rem;margin-top:.25rem}.settings-module .user-modules .badge{margin-right:.35rem;margin-top:.25rem}.settings-module .user-actions .btn{min-width:42px}@media (max-width:640px){.settings-module .user-main{flex-direction:column;gap:.5rem}.settings-module .user-actions{display:flex;gap:.5rem;justify-content:flex-start;width:100%}.settings-module .user-actions .action-row{display:flex;gap:.5rem}}.settings-module .btn{background-image:none!important;box-shadow:none!important}.settings-module .btn.btn-outline{background:transparent!important;border:1px solid var(--border-color)!important;box-shadow:none!important;color:var(--text-primary)!important}.settings-module .user-actions .btn{align-items:center!important;border-radius:8px!important;display:inline-flex!important;justify-content:center!important;min-width:56px!important;padding:.42rem .8rem!important}.settings-module .user-actions{gap:.5rem}.settings-module .btn:hover{transform:translateY(-1px)}.settings-module .btn-primary{background:var(--primary-color)!important;background-image:none!important;border:1px solid rgba(59,130,246,.12)!important;box-shadow:none!important;color:#fff!important}.settings-module .btn-primary:hover{background:var(--primary-dark)!important}.settings-module .btn-success{background:var(--success-color)!important;background-image:none!important;border:1px solid rgba(16,185,129,.12)!important;box-shadow:none!important;color:#fff!important}.settings-module .btn-success:hover{background:#059669!important}.settings-module .btn-warning{background:var(--warning-color)!important;background-image:none!important;border:1px solid rgba(245,158,11,.12)!important;box-shadow:none!important;color:#fff!important}.settings-module .btn-warning:hover{background:#d97706!important}.settings-module .btn-error{background:var(--error-color)!important;background-image:none!important;border:1px solid rgba(239,68,68,.12)!important;box-shadow:none!important;color:#fff!important}.settings-module .btn-error:hover{background:#dc2626!important}.settings-module .user-actions{align-items:center;display:flex;flex-direction:row;gap:.6rem}.settings-module .user-actions .action-row{display:flex;gap:.5rem}.settings-module .user-actions .btn{margin:0!important}.suggestions-section .card .btn-success:hover,.suggestions-section .card .btn-warning:hover{background-color:#059669;box-shadow:0 6px 18px #10b98114;transform:translateY(-2px)}.suggestions-section .card .btn .btn-icon,.suggestions-section .card .btn svg{height:14px;margin-right:.4rem;width:14px}@media (max-width:640px){.suggestions-section .card .btn{font-size:.8125rem;padding:.35rem .6rem}.review-item{padding:.75rem!important}.review-item .review-avatar{height:36px;width:36px}}.marketing-module .reviews-table .actions-cell .flex{gap:.35rem!important}.marketing-module .reviews-table .actions-cell button{min-width:28px!important;padding:.25rem!important}.ai-badge{align-items:center;background:#3b82f60f;border-radius:8px;display:inline-flex;font-size:.9rem;gap:.5rem;padding:.25rem .5rem}.ai-icon{font-size:1rem}@media (min-width:640px){.suggestions-section .flex.sm\\:flex-row{align-items:center!important;display:flex!important;flex-direction:row!important;gap:.5rem!important}.suggestions-section .flex.sm\\:flex-row .form-select{display:inline-block!important;margin:0!important;max-width:260px!important;width:auto!important}}.projects-module .form-select{display:inline-block!important;max-width:260px!important;min-width:140px!important;width:auto!important}@media (max-width:640px){.projects-module .form-select{min-width:0;width:100%!important}}.projects-module .projects-grid{gap:1rem;grid-template-columns:repeat(1,minmax(0,1fr))}@media (min-width:640px){.projects-module .projects-grid{grid-template-columns:repeat(2,minmax(0,1fr))!important}}.projects-module .card{border-radius:10px}.projects-module .card .card-body{padding:.9rem!important}.projects-module .card h4{font-size:1.05rem;margin-bottom:.4rem}.projects-module .card p{color:var(--text-secondary);margin-bottom:.6rem}.onboarding-module *,.onboarding-module .btn,.onboarding-module .card,.onboarding-module .chart-card,.onboarding-module .file-card,.onboarding-module .kpi-card,.onboarding-module .modal,.onboarding-module .review-action-btn,.onboarding-module .stat-card,.onboarding-module .table,.onboarding-module .tutorial-card{box-shadow:none!important}.suggestions-section .flex.flex-col .flex{align-items:center!important;display:flex!important;flex-direction:row!important;gap:.5rem!important}.suggestions-section .flex.flex-col .flex .form-select{display:inline-block!important;max-width:260px!important;width:auto!important}.form-textarea{border:1px solid var(--border-color);border-radius:var(--radius-md);font-size:.875rem;min-height:100px;padding:.5rem .75rem;width:100%}.table{border-radius:var(--radius-lg);box-shadow:var(--shadow-sm)}@media (max-width:640px){.table thead{display:none}.table tbody tr{background:#fff;border:1px solid #e5e7eb;border-radius:8px;box-shadow:0 1px 3px #0000001a;display:block;margin-bottom:1rem;padding:1rem}.table tbody td{border:none;display:block;padding:.5rem 0 .5rem 40%;position:relative;text-align:left}.table tbody td:before{color:#374151;content:attr(data-label);font-size:.875rem;font-weight:600;left:0;padding-right:10px;position:absolute;white-space:nowrap;width:35%}.table tbody td:last-child{border-top:1px solid #e5e7eb;margin-top:.75rem;padding-left:0;padding-top:.75rem}.table tbody td:last-child:before{display:none}.table tbody td:last-child .table-actions{gap:.5rem;justify-content:flex-start}.table tbody td .badge{font-size:.75rem;padding:.25rem .5rem}.table tbody tr:first-child{margin-top:0}.table tbody tr:last-child{margin-bottom:0}.overflow-x-auto{overflow-x:visible}.table{border:none;box-shadow:none}.btn-sm{font-size:.75rem;min-width:auto;padding:.25rem .5rem}.btn-sm .btn-icon{height:16px;width:16px}.flex.items-center.gap-1{gap:.25rem}.btn-sm{align-items:center;display:flex;justify-content:center;min-height:32px;min-width:32px}.btn{touch-action:manipulation;-webkit-tap-highlight-color:transparent}.btn:active{transform:scale(.95);transition:transform .1s ease}}.table td,.table th{border-bottom:1px solid var(--border-color);padding:.75rem 1rem}.table th{color:var(--text-primary)}.badge{border-radius:var(--radius-sm);padding:.25rem .5rem}.badge-success{background:#dcfce7;color:#166534}.badge-warning{background:#fef3c7;color:#92400e}.badge-error{background:#fee2e2;color:#991b1b}.badge-info{background:#dbeafe;color:#1e40af}.content-header{border-bottom:1px solid var(--border-color);padding:0}.kpi-grid{grid-template-columns:repeat(auto-fit,minmax(250px,1fr))}.kpi-card{background:#fff;border:1px solid var(--border-color);border-radius:var(--radius-lg);box-shadow:var(--shadow-sm);padding:1.5rem}.kpi-value{color:var(--primary-color)}.kpi-label{color:var(--text-secondary)}.kpi-change{font-size:.75rem}.kpi-change.positive{color:var(--success-color)}.kpi-change.negative{color:var(--error-color)}.charts-section{margin-bottom:2rem}.chart-card{background:#fff;border:1px solid #e2e8f0;border-radius:12px;box-shadow:0 4px 6px -1px #0000001a;overflow:hidden}.chart-header{align-items:center;border-bottom:1px solid #f1f5f9;display:flex;justify-content:space-between;padding:1.5rem 1.5rem 1rem}.chart-title{color:#1e293b;font-size:1.125rem;font-weight:600;margin:0}.chart-period{display:flex;gap:.5rem}.period-active{background:#3b82f6;border-radius:6px;color:#fff;font-size:.875rem;font-weight:500;padding:.25rem .75rem}.chart-content{padding:1.5rem}.revenue-chart{flex-direction:column;height:200px}.chart-bars,.revenue-chart{display:flex;justify-content:space-between}.chart-bars{align-items:end;gap:.5rem;height:150px}.chart-bar{background:linear-gradient(135deg,#3b82f6,#1d4ed8);border-radius:4px 4px 0 0;cursor:pointer;min-width:40px;position:relative;transition:all .3s ease}.chart-bar:hover{background:linear-gradient(135deg,#2563eb,#1e40af);transform:scaleY(1.05)}.bar-value{color:#64748b;font-size:.75rem;font-weight:600;left:50%;position:absolute;top:-25px;transform:translate(-50%);white-space:nowrap}.chart-labels{color:#64748b;display:flex;font-size:.875rem;font-weight:500;justify-content:space-between;padding-top:.5rem}.project-status-chart{align-items:center;display:flex;gap:2rem;height:200px}.status-circle{background:conic-gradient(#10b981 0deg 216deg,#f59e0b 216deg 288deg,#ef4444 288deg 1turn);height:120px;position:relative;width:120px}.status-center,.status-circle{align-items:center;border-radius:50%;display:flex;justify-content:center}.status-center{background:#fff;box-shadow:0 2px 4px #0000001a;flex-direction:column;height:80px;width:80px}.status-total{color:#1e293b;font-size:1.5rem;font-weight:700;line-height:1}.status-label{color:#64748b;font-size:.75rem;font-weight:500}.status-details{display:flex;flex:1;flex-direction:column;gap:1rem}.status-item{align-items:center;display:flex;gap:.75rem}.status-count{color:#1e293b;font-size:1.25rem;font-weight:700;min-width:2rem}.status-text{color:#64748b;font-size:.875rem;font-weight:500}.chart-legend{display:flex;gap:1rem}.legend-item{align-items:center;color:#64748b;display:flex;font-size:.875rem;gap:.5rem}.legend-color{border-radius:2px;height:12px;width:12px}.legend-color.completed{background:#10b981}.legend-color.in-progress{background:#f59e0b}.legend-color.pending{background:#ef4444}.metrics-section{margin-bottom:2rem}.metrics-grid{display:grid;gap:1.5rem;grid-template-columns:repeat(auto-fit,minmax(250px,1fr))}.metric-card{background:#fff;border:1px solid #e2e8f0;border-radius:12px;padding:1.5rem;transition:all .3s ease}.metric-card:hover{box-shadow:0 8px 25px -5px #0000001a;transform:translateY(-2px)}.metric-header{gap:.75rem;margin-bottom:1rem}.metric-header,.metric-icon{align-items:center;display:flex}.metric-icon{border-radius:10px;color:#fff;height:40px;justify-content:center;width:40px}.metric-icon.social-icon{background:linear-gradient(135deg,#e91e63,#c2185b)}.metric-icon.elearning-icon{background:linear-gradient(135deg,#9c27b0,#7b1fa2)}.metric-icon.team-icon{background:linear-gradient(135deg,#ff9800,#f57c00)}.metric-icon.satisfaction-icon{background:linear-gradient(135deg,#f44336,#d32f2f)}.metric-title{color:#1e293b;font-size:1rem;font-weight:600;margin:0}.metric-content{text-align:left}.metric-value{color:#1e293b;font-size:2rem;font-weight:700;line-height:1;margin-bottom:.25rem}.metric-label{color:#64748b;font-size:.875rem;font-weight:500;margin-bottom:.5rem}.metric-change{align-items:center;display:flex;font-size:.75rem;font-weight:600;gap:.25rem}.metric-change.positive{color:#10b981}.metric-change.negative{color:#ef4444}.onboarding-module .stats-grid{display:grid;gap:1.5rem;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));margin-bottom:2rem}.stat-card{align-items:center;background:#fff;border:1px solid #e2e8f0;border-radius:12px;box-shadow:0 4px 6px -1px #0000001a;display:flex;gap:1rem;padding:1.5rem}.stat-icon{background:linear-gradient(135deg,#3b82f6,#1d4ed8);border-radius:12px;color:#fff;height:48px;width:48px}.stat-value{color:#1e293b;font-size:2rem;font-weight:700;line-height:1;margin-bottom:.25rem}.stat-label{color:#64748b;font-size:.875rem;font-weight:500}.tabs-section{background:#fff;border:1px solid #e2e8f0;border-radius:12px;box-shadow:0 4px 6px -1px #0000001a;overflow:hidden}.tabs-header{background:#f8fafc;border-bottom:1px solid #e2e8f0}.tabs-nav{display:flex;gap:0}.tab-btn{background:none;border:none;border-bottom:3px solid transparent;color:#64748b;cursor:pointer;font-weight:500;padding:1rem 1.5rem;transition:all .2s ease}.tab-btn:hover{background:#3b82f60d;color:#3b82f6}.tab-btn.active{background:#fff;border-bottom-color:#3b82f6;color:#3b82f6}.tab-content{padding:2rem}.tutorials-grid{display:grid;gap:1.5rem;grid-template-columns:repeat(auto-fit,minmax(350px,1fr))}.tutorial-card{background:#fff;border:1px solid #e2e8f0;border-radius:12px;overflow:hidden;transition:all .3s ease}.tutorial-card:hover{box-shadow:0 8px 25px -5px #0000001a;transform:translateY(-2px)}.tutorial-header{align-items:center;background:#f8fafc;border-bottom:1px solid #e2e8f0;display:flex;justify-content:space-between;padding:1rem 1.5rem}.tutorial-icon{align-items:center;background:linear-gradient(135deg,#10b981,#059669);border-radius:10px;color:#fff;display:flex;height:40px;justify-content:center;width:40px}.tutorial-actions{display:flex;gap:.5rem}.action-btn{border:none;border-radius:6px;height:32px;justify-content:center;width:32px}.action-btn.edit{background:#f3f4f6;color:#6b7280}.action-btn.edit:hover{background:#e5e7eb;color:#374151}.action-btn.delete{background:#fef2f2;color:#dc2626}.action-btn.delete:hover{background:#fee2e2;color:#b91c1c}.tutorial-content{padding:1.5rem}.tutorial-title{color:#1e293b;font-size:1.125rem;font-weight:600;margin-bottom:.5rem}.tutorial-description{color:#64748b;font-size:.875rem;line-height:1.5;margin-bottom:1rem}.tutorial-meta{align-items:center;color:#9ca3af;display:flex;font-size:.75rem;justify-content:space-between;margin-bottom:1rem}.tutorial-stats{display:flex;gap:1rem}.stat-item{color:#6b7280;font-size:.75rem;gap:.25rem}.files-grid{display:grid;gap:1.5rem;grid-template-columns:repeat(auto-fit,minmax(300px,1fr))}.file-card{align-items:center;background:#fff;border:1px solid #e2e8f0;border-radius:12px;display:flex;gap:1rem;padding:1.5rem;transition:all .3s ease}.file-card:hover{box-shadow:0 8px 25px -5px #0000001a;transform:translateY(-2px)}.file-icon{align-items:center;background:linear-gradient(135deg,#8b5cf6,#7c3aed);border-radius:10px;color:#fff;display:flex;flex-shrink:0;height:48px;justify-content:center;width:48px}.file-content{flex:1}.file-name{color:#1e293b;font-size:1rem;font-weight:600;margin-bottom:.25rem}.file-size,.file-type{color:#6b7280;font-size:.75rem;margin-bottom:.25rem}.file-actions{display:flex;gap:.5rem;margin-top:.75rem}.assignments-table{overflow-x:auto}.table{background:#fff;border-collapse:collapse;border-radius:8px;overflow:hidden;width:100%}.table td,.table th{border-bottom:1px solid #e2e8f0;padding:1rem;text-align:left}.table th{color:#374151;font-size:.875rem;font-weight:600}.table tbody tr:hover,.table th{background:#f8fafc}.assignment-tutorial{max-width:300px}.tutorial-name{color:#1e293b;font-size:.875rem;font-weight:600;margin-bottom:.25rem}.tutorial-desc{color:#6b7280;font-size:.75rem;line-height:1.4}.assigned-users{display:flex;flex-wrap:wrap;gap:.5rem}.user-name{color:#374151}.status-badge{border-radius:9999px;font-size:.75rem;font-weight:500;padding:.25rem .75rem;text-transform:capitalize}.status-badge.pending{background:#fef3c7;color:#92400e}.status-badge.completed{background:#d1fae5;color:#065f46}.status-badge.overdue{background:#fee2e2;color:#991b1b}.modal-content{border-radius:12px;box-shadow:0 25px 50px -12px #00000040;max-width:600px}.modal-close{border-radius:6px;color:#6b7280;padding:.5rem;transition:all .2s ease}.modal-close:hover{background:#f3f4f6;color:#374151}.modal-actions{border-top:1px solid #e2e8f0;display:flex;gap:1rem;justify-content:flex-end;margin-top:2rem;padding-top:1.5rem}.editor-container{border:1px solid #d1d5db;border-radius:8px;overflow:hidden}.tutorial-editor{border:none;font-family:Inter,sans-serif;font-size:.875rem;line-height:1.6;min-height:300px;padding:1rem;resize:vertical;width:100%}.tutorial-editor:focus{outline:none}.upload-area{background:#f9fafb;border:2px dashed #d1d5db;border-radius:12px;cursor:pointer;padding:3rem 2rem;text-align:center;transition:all .3s ease}.upload-area:hover{background:#eff6ff;border-color:#3b82f6}.upload-content{align-items:center;display:flex;flex-direction:column;gap:1rem}.upload-text{color:#374151;font-size:1.125rem;font-weight:500;margin:0}.upload-subtext{color:#6b7280;font-size:.875rem;margin:0}.upload-progress{margin-top:1.5rem}.upload-item{margin-bottom:1rem}.upload-info{align-items:center;display:flex;justify-content:space-between;margin-bottom:.5rem}.upload-name{color:#374151;font-size:.875rem;font-weight:500}.upload-size{color:#6b7280;font-size:.75rem}.upload-bar{background:#e5e7eb;border-radius:2px;height:4px;overflow:hidden;width:100%}.upload-fill{background:linear-gradient(90deg,#3b82f6,#1d4ed8);height:100%;transition:width .3s ease}.badge{align-items:center;display:inline-flex;font-weight:500;padding:.25rem .75rem}.badge-primary{background:#dbeafe;color:#1e40af}.module-card{background:#fff;border:1px solid var(--border-color);border-radius:var(--radius-lg);box-shadow:var(--shadow-sm);cursor:pointer;text-align:center;transition:all .2s ease}.module-card:hover{box-shadow:var(--shadow-md);transform:translateY(-2px)}.module-icon{background:var(--primary-color);border-radius:var(--radius-lg);font-size:1.5rem;margin:0 auto 1rem}.module-title{color:var(--text-primary);font-weight:600}.module-description{color:var(--text-secondary)}.module-actions{background:var(--bg-primary);border:1px solid var(--border-color);border-radius:.75rem;box-shadow:none!important;padding:1rem}.file-upload-area{background:#f9fafb;border:2px dashed #d1d5db;border-radius:.75rem;cursor:pointer;padding:2rem;text-align:center;transition:all .3s ease}.file-upload-area:hover{background:#eff6ff;border-color:#3b82f6}.file-upload-area.drag-over{background:#dbeafe;border-color:#3b82f6;transform:scale(1.02)}.file-upload-area .hidden{display:none}.form-input{border-radius:.5rem;transition:border-color .2s ease,box-shadow .2s ease}.card-title{margin:0 0 .25rem}.card-subtitle{color:var(--text-secondary);font-size:.875rem;margin:0}@media (max-width:768px){.kpi-grid,.module-grid{grid-template-columns:1fr}.btn{font-size:16px;min-height:44px;padding:.5rem 1rem}.btn-sm{min-height:36px;min-width:36px;padding:.375rem .75rem}.table-actions .btn{min-height:32px;min-width:32px;padding:.25rem .5rem}.module-actions .btn{min-height:40px;padding:.5rem 1rem}.modal-footer .btn{min-width:80px;padding:.5rem 1rem}.content-body{padding:1.5rem}}.text-center{text-align:center}.text-left{text-align:left}.text-right{text-align:right}.mb-2{margin-bottom:.5rem}.mb-6{margin-bottom:1.5rem}.mt-2{margin-top:.5rem}.mt-4{margin-top:1rem}.mt-6{margin-top:1.5rem}.mt-8{margin-top:2rem}.p-2{padding:.5rem}.p-4{padding:1rem}.p-6{padding:1.5rem}.p-8{padding:2rem}.hidden{display:none}.block{display:block}.inline-block{display:inline-block}.w-full{width:100%}.h-full{height:100%}.rounded{border-radius:var(--radius-md)}.rounded-lg{border-radius:var(--radius-lg)}.shadow{box-shadow:var(--shadow-md)}.shadow-lg{box-shadow:var(--shadow-lg)}.loading{opacity:.6;pointer-events:none}.spinner{animation:spin 1s linear infinite;border-top:2px solid var(--border-color);border:2px solid var(--border-color);border-radius:50%;border-top-color:var(--primary-color);height:20px;width:20px}@keyframes spin{0%{transform:rotate(0)}to{transform:rotate(1turn)}}.toast{background:#fff;border:1px solid var(--border-color);border-radius:var(--radius-md);box-shadow:var(--shadow-lg);max-width:400px;padding:1rem;position:fixed;right:1rem;top:1rem;z-index:1000}.toast.success{border-left:4px solid var(--success-color)}.toast.error{border-left:4px solid var(--error-color)}.toast.warning{border-left:4px solid var(--warning-color)}.modal-overlay{z-index:1000}.modal{background:#fff;border-radius:var(--radius-lg);box-shadow:var(--shadow-lg);max-height:90vh;max-width:500px;overflow-y:auto;width:90%}.modal-header{border-bottom:1px solid var(--border-color)}.modal-body,.modal-header{padding:1.5rem}.modal-footer{border-top:1px solid var(--border-color);gap:.5rem;padding:1rem 1.5rem}.landing-page{background:linear-gradient(135deg,#f0f9ff,#e0e7ff);min-height:100vh}.landing-nav{background:#fff;box-shadow:var(--shadow-sm);position:sticky;top:0;z-index:100}.nav-content{height:4rem;justify-content:space-between}.brand-logo,.nav-brand,.nav-content{align-items:center;display:flex}.logo-icon{color:var(--primary-color);height:2rem;width:2rem}.brand-text{color:var(--text-primary);font-size:1.25rem;font-weight:700;margin-left:.5rem}.nav-actions{align-items:center;display:flex}.hero-section{padding:5rem 0}.hero-content{text-align:center}.hero-title{color:var(--text-primary);font-size:3rem;font-weight:700;line-height:1.1;margin-bottom:1.5rem}.hero-highlight{color:var(--primary-color)}.hero-description{color:var(--text-secondary);font-size:1.25rem;margin-bottom:2rem;margin-left:auto;margin-right:auto;max-width:48rem}.hero-actions{align-items:center;display:flex;flex-direction:column;gap:1rem;justify-content:center}.features-section{padding:5rem 0}.features-header{margin-bottom:4rem;text-align:center}.features-title{color:var(--text-primary);font-size:2rem;font-weight:700;margin-bottom:1rem}.features-subtitle{color:var(--text-secondary);font-size:1.125rem}.features-grid{display:grid;gap:2rem;grid-template-columns:repeat(auto-fit,minmax(300px,1fr))}.feature-card{background:#fff;border:1px solid var(--border-color);border-radius:var(--radius-lg);box-shadow:var(--shadow-sm);padding:2rem;text-align:center;transition:all .2s ease}.feature-card:hover{box-shadow:var(--shadow-md);transform:translateY(-2px)}.feature-icon{align-items:center;border-radius:var(--radius-lg);display:flex;height:4rem;justify-content:center;margin:0 auto 1rem;width:4rem}.feature-icon .icon{height:2rem;width:2rem}.financial-icon{background:#dcfce7}.financial-icon .icon{color:#16a34a}.marketing-icon{background:#f3e8ff}.marketing-icon .icon{color:#9333ea}.elearning-icon{background:#dbeafe}.elearning-icon .icon{color:var(--primary-color)}.projects-icon{background:#fed7aa}.projects-icon .icon{color:#ea580c}.settings-icon{background:#f3f4f6}.settings-icon .icon{color:var(--text-secondary)}.profile-icon{background:#e0e7ff}.profile-icon .icon{color:#6366f1}.feature-title{color:var(--text-primary);font-size:1.25rem;font-weight:600;margin-bottom:.5rem}.feature-description{color:var(--text-secondary)}.cta-section{background:var(--primary-color);padding:4rem 0}.cta-content{text-align:center}.cta-title{color:#fff;font-size:2rem;font-weight:700;margin-bottom:1rem}.cta-description{color:#bfdbfe;font-size:1.25rem;margin-bottom:2rem}.cta-button{background:#fff;color:var(--primary-color)}.cta-button:hover{background:#f8fafc}.landing-footer{background:#1f2937;padding:3rem 0}.footer-content{text-align:center}.footer-brand{margin-bottom:1rem}.footer-logo{align-items:center;display:flex;justify-content:center}.footer-logo .logo-icon{color:var(--primary-color)}.footer-logo .brand-text{color:#fff}.footer-copyright{color:#9ca3af}@media (max-width:768px){.hero-title{font-size:2rem}.hero-description{font-size:1.125rem}.hero-actions{flex-direction:column}.features-grid{grid-template-columns:1fr}.cta-title{font-size:1.5rem}.cta-description{font-size:1.125rem}}.login-page{background:#f9fafb;min-height:100vh}.login-container{align-items:center;display:flex;justify-content:center;min-height:100vh;padding:3rem 1rem}.login-form-wrapper{max-width:28rem;width:100%}.login-header{margin-bottom:2rem;text-align:center}.login-logo{align-items:center;background:var(--primary-color);border-radius:var(--radius-lg);display:flex;height:3rem;justify-content:center;margin:0 auto 1.5rem;width:3rem}.login-logo .logo-icon{color:#fff;height:2rem;width:2rem}.login-title{color:var(--text-primary);font-size:1.875rem;font-weight:800;margin-bottom:.5rem}.login-subtitle{color:var(--text-secondary);font-size:.875rem}.login-form{margin-top:2rem}.input-group{margin-bottom:-1px}.input-group:first-child .form-input{border-bottom-left-radius:0;border-bottom-right-radius:0}.input-group:last-child .form-input{border-top-left-radius:0;border-top-right-radius:0}.form-input{-webkit-appearance:none;-moz-appearance:none;appearance:none;border:1px solid var(--border-color);border-radius:var(--radius);color:var(--text-primary);display:block;padding:.75rem;position:relative}.form-input:focus{border-color:var(--primary-color);z-index:10}.form-input::-moz-placeholder{color:#9ca3af}.form-input::placeholder{color:#9ca3af}.form-input-top{border-bottom-left-radius:0;border-bottom-right-radius:0}.form-input-bottom{border-top-left-radius:0;border-top-right-radius:0}.form-options{justify-content:space-between;margin-bottom:1.5rem}.checkbox-group,.form-options{align-items:center;display:flex}.checkbox{border:1px solid var(--border-color);border-radius:var(--radius-sm);color:var(--primary-color);height:1rem;margin-right:.5rem;width:1rem}.checkbox:focus{box-shadow:0 0 0 3px #3b82f61a;outline:none}.checkbox-label{color:var(--text-primary);font-size:.875rem}.forgot-link{color:var(--primary-color);font-size:.875rem;font-weight:500;text-decoration:none}.forgot-link:hover{color:#1d4ed8}.submit-group{margin-bottom:1.5rem}.btn-full{align-items:center;border:1px solid transparent;border-radius:var(--radius);display:flex;font-size:.875rem;font-weight:500;justify-content:center;padding:.75rem 1rem;transition:all .2s ease;width:100%}.btn-full:disabled{cursor:not-allowed;opacity:.5}.error-message{background:#fef2f2;border:1px solid #fecaca;border-radius:var(--radius);margin-bottom:1.5rem;padding:1rem}.error-content{display:flex}.error-icon{flex-shrink:0;margin-right:.75rem}.error-icon .icon{color:#f87171;height:1.25rem;width:1.25rem}.error-text{flex:1}.error-title{color:#991b1b;font-size:.875rem;font-weight:500;margin-bottom:.5rem}.error-description{color:#b91c1c;font-size:.875rem}.demo-credentials{margin-top:1.5rem}.divider{margin-bottom:1rem;position:relative}.divider-line{background:var(--border-color);height:1px;left:0;position:absolute;right:0;top:50%}.divider-text{background:#f9fafb;color:#6b7280;display:flex;font-size:.875rem;justify-content:center;padding:0 .5rem;position:relative}.customer-dashboard{background-color:var(--background-color);display:flex}@media (max-width:768px){.customer-dashboard,.header-main{flex-direction:column}.header-main{align-items:flex-start;gap:1rem}.header-actions{justify-content:space-between;width:100%}.actions-grid,.kpi-grid,.module-grid{grid-template-columns:1fr}.notifications-panel{left:1rem;right:1rem;width:calc(100vw - 2rem)}}@media (max-width:480px){.page-title{font-size:1.25rem}.company-name{font-size:.875rem}.action-btn,.company-plan{font-size:.75rem}.action-btn{padding:.5rem}.action-icon{height:1rem;width:1rem}}.header-content{justify-content:space-between;width:100%}.company-avatar,.company-info,.header-content{align-items:center;display:flex}.company-avatar{background-color:var(--primary-color);border-radius:var(--radius-lg);color:#fff;font-size:1.125rem;font-weight:700;height:2.5rem;justify-content:center;width:2.5rem}.company-details{margin-left:.75rem}.company-name{color:var(--text-primary);font-size:1rem;font-weight:600;margin:0}.company-plan{color:var(--text-secondary);font-size:.875rem;margin:0}.collapse-btn{background:none;border:none;border-radius:var(--radius-sm);color:var(--text-muted);cursor:pointer;padding:.25rem;transition:color .2s ease}.collapse-btn:hover{color:var(--text-secondary)}.collapse-icon{height:1.25rem;width:1.25rem}.page-title{color:var(--text-primary);font-size:1.5rem;font-weight:700;margin:0}.page-subtitle{color:var(--text-secondary);font-size:.875rem}.notification-btn{background:none;border:none;border-radius:var(--radius-sm);color:var(--text-muted);padding:.5rem;transition:color .2s ease}.notification-btn:hover{color:var(--text-secondary)}.notification-icon{height:1.5rem;width:1.5rem}.notification-badge{background-color:var(--error-color);height:1rem;right:-.25rem;top:-.25rem;width:1rem}.user-avatar{background-color:var(--primary-color);border-radius:50%;font-weight:500;height:2rem;width:2rem}.user-name{display:none}@media (min-width:768px){.user-name{display:block}}.dropdown-icon{height:1rem;width:1rem}.logout-btn{color:var(--error-color)}.modules-title{color:var(--text-primary);font-size:1.25rem;font-weight:600;margin-bottom:1rem}.quick-actions-card{background-color:var(--surface-color);border:1px solid var(--border-color);border-radius:var(--radius-lg);box-shadow:var(--shadow-sm)}.card-header{padding:1.5rem 1.5rem 0}.card-title{color:var(--text-primary);font-size:1.125rem;font-weight:600}.card-body{padding:1.5rem}.actions-grid{grid-template-columns:repeat(2,1fr)}@media (min-width:768px){.actions-grid{grid-template-columns:repeat(4,1fr)}}.action-btn{background-color:var(--surface-color);border:1px solid var(--border-color);border-radius:var(--radius-md);color:var(--text-primary);cursor:pointer;font-size:.875rem;gap:.5rem;padding:.75rem 1rem;transition:all .2s ease}.action-btn:hover{background-color:#f8fafc;border-color:var(--primary-color)}.action-icon{height:1.25rem;width:1.25rem}.elearning-module,.financial-module,.marketing-module,.projects-module{background-color:var(--background-color);min-height:100vh}.elearning-module .content-header,.financial-module .content-header,.marketing-module .content-header,.projects-module .content-header{background-color:var(--surface-color);border-bottom:1px solid var(--border-color);padding:1.5rem}.elearning-module .content-body,.financial-module .content-body,.marketing-module .content-body,.profile-module .content-body,.projects-module .content-body{margin:0;max-width:none;padding:2rem;width:100%}.action-buttons{align-items:center;display:flex;gap:.5rem}.modal-title{color:var(--text-primary);font-size:1.125rem;font-weight:600}.modal-close{background:none;border:none;border-radius:.25rem;color:var(--text-muted);cursor:pointer;padding:.25rem;transition:color .2s ease}.modal-close:hover{color:var(--text-secondary)}.connection-status{align-items:center;display:flex;gap:.5rem}.status-indicator{border-radius:50%;height:.75rem;width:.75rem}.status-connected{background-color:#10b981}.status-disconnected{background-color:#ef4444}.text-muted{color:var(--text-muted)}.customer-dashboard{background:linear-gradient(135deg,#f8fafc,#e2e8f0);max-width:100vw;min-height:100vh;overflow-x:hidden;width:100%}.main-content{min-height:100vh;transition:all .3s cubic-bezier(.4,0,.2,1);width:100%}.mobile-menu-btn{align-items:center;background:linear-gradient(135deg,#667eea,#764ba2);border:none;border-radius:10px;box-shadow:0 4px 12px #667eea4d;color:#fff;cursor:pointer;display:none;flex-shrink:0;height:40px;justify-content:center;margin-left:1rem;position:relative;transition:all .3s ease;width:40px;z-index:2}.mobile-menu-btn:hover{box-shadow:0 6px 20px #667eea66;transform:translateY(-2px)}.expand-icon{height:20px;width:20px;stroke-width:2}.content-header{background:#fff;border-bottom:1px solid #e2e8f0;padding:1.5rem 2rem;position:sticky;top:0;z-index:100}.header-main{align-items:center;display:flex;justify-content:space-between;width:100%}.header-title{flex:1;min-width:0}.page-title{color:#000;font-size:1.6rem;font-weight:800;margin:0 0 .5rem}.page-subtitle{color:#64748b;font-size:1rem;margin:0}.header-actions{align-items:center;display:flex;flex-shrink:0;gap:1rem}.content-body{margin:0;max-width:none;padding:2rem;width:100%}.kpi-grid{display:grid;gap:1.5rem;grid-template-columns:repeat(auto-fit,minmax(280px,1fr));margin-bottom:2rem}.kpi-card{background:linear-gradient(135deg,#fff,#f8fafc);border:1px solid rgba(226,232,240,.8);border-radius:16px;box-shadow:0 4px 20px #0000000d;overflow:hidden;padding:2rem;position:relative;transition:all .3s ease}.kpi-card:before{background:linear-gradient(90deg,#3b82f6,#8b5cf6,#06b6d4);content:"";height:4px;left:0;position:absolute;right:0;top:0}.kpi-card:hover{box-shadow:0 8px 30px #0000001a;transform:translateY(-5px)}.kpi-value{font-size:2.5rem;font-weight:800;line-height:1}.kpi-label{margin-bottom:.5rem}.kpi-change{font-weight:500}.modules-section{margin-bottom:2rem}.modules-title{color:#1e293b;font-size:1.5rem;font-weight:700;margin-bottom:1.5rem}.module-grid{display:grid;gap:1.5rem;grid-template-columns:repeat(auto-fit,minmax(300px,1fr))}.module-card{background:linear-gradient(135deg,#fff,#f8fafc);border:1px solid rgba(226,232,240,.8);border-radius:16px;box-shadow:0 4px 20px #0000000d;color:inherit;display:block;overflow:hidden;padding:2rem;position:relative;text-decoration:none;transition:all .3s ease}.module-card:before{background:linear-gradient(90deg,#10b981,#059669,#047857);content:"";height:4px;left:0;position:absolute;right:0;top:0}.module-card:hover{box-shadow:0 8px 30px #0000001a;color:inherit;text-decoration:none;transform:translateY(-5px)}.module-icon{align-items:center;background:linear-gradient(135deg,#10b981,#059669);border-radius:12px;color:#fff;display:flex;height:48px;justify-content:center;margin-bottom:1rem;width:48px}.module-title{color:#1e293b;font-size:1.25rem;font-weight:700;margin-bottom:.5rem}.module-description{color:#64748b;font-size:.875rem;line-height:1.5;margin:0}.quick-actions-card{background:linear-gradient(135deg,#fff,#f8fafc);border:1px solid rgba(226,232,240,.8);border-radius:16px;box-shadow:0 4px 20px #0000000d;overflow:hidden}.card-header{background:linear-gradient(135deg,#f8fafc,#e2e8f0);border-bottom:1px solid #e2e8f0;padding:1.5rem 2rem}.card-title{color:#1e293b;font-size:1.25rem;font-weight:700;margin:0}.card-body{padding:2rem}.actions-grid{display:grid;gap:1rem;grid-template-columns:repeat(auto-fit,minmax(200px,1fr))}.action-btn{align-items:center;background:#fff;border:1px solid #e2e8f0;border-radius:12px;color:#374151;display:flex;font-weight:500;gap:.75rem;overflow:hidden;padding:1rem 1.5rem;position:relative;text-decoration:none;transition:all .3s ease}.action-btn:before{background:#3b82f61a;border-radius:50%;content:"";height:0;left:50%;position:absolute;top:50%;transform:translate(-50%,-50%);transition:all .3s ease;width:0}.action-btn:hover:before{height:100%;width:100%}.action-btn:hover{border-color:#3b82f6;box-shadow:0 4px 15px #3b82f633;color:#3b82f6;text-decoration:none;transform:translateY(-2px)}.action-icon{flex-shrink:0;height:20px;width:20px}.financial-module{background:transparent;max-width:100%;width:100%}.tabs-container{background:#fff;border-radius:16px;margin-bottom:2rem;overflow:hidden}.tabs-header{background:linear-gradient(135deg,#f1f5f9,#e2e8f0);border-bottom:1px solid rgba(226,232,240,.8);display:flex;overflow-x:auto}.tab-button{background:transparent;border:none;color:#64748b;cursor:pointer;flex-shrink:0;font-weight:600;padding:1rem 2rem;position:relative;transition:all .3s ease;white-space:nowrap}.tab-button:hover{background:#3b82f60d;color:#3b82f6}.tab-button.active{background:linear-gradient(135deg,#3b82f6,#1d4ed8);box-shadow:0 2px 10px #3b82f64d;color:#fff}.tab-button.active:after{background:#fff;bottom:0;content:"";height:3px;left:0;position:absolute;right:0}.tabs-content{padding:2rem}.tab-pane{width:100%}.section-title{font-size:1.5rem;font-weight:700;margin-bottom:1.5rem}.table-responsive{border-radius:12px;box-shadow:0 2px 10px #0000000d;overflow-x:auto}.data-table{background:#fff;border-collapse:collapse;min-width:800px;width:100%}.data-table th{background:linear-gradient(135deg,#f8fafc,#e2e8f0);border-bottom:1px solid #e2e8f0;font-weight:600;letter-spacing:.05em;text-align:left;text-transform:uppercase}.data-table td,.data-table th{color:#374151;font-size:.875rem;padding:1rem}.data-table td{border-bottom:1px solid #f1f5f9}.data-table tr:hover{background:#f8fafc}.data-table tr:last-child td{border-bottom:none}.settings-module .table-responsive{overflow-x:auto!important;-webkit-overflow-scrolling:touch;box-shadow:none!important}.settings-module .data-table{min-width:0!important;overflow:visible!important;table-layout:auto!important;width:100%!important}.settings-module .data-table td,.settings-module .data-table th{max-width:1px;white-space:normal!important;word-break:break-word!important}.settings-module .assigned-users .badge,.settings-module .assigned-users span,.settings-module .badge{display:inline-block!important;max-width:100%!important;white-space:normal!important}@media (max-width:768px){.settings-module .data-table td,.settings-module .data-table th{padding:.5rem!important}}.action-link{background:none;border:none;border-radius:6px;color:#3b82f6;cursor:pointer;font-weight:500;margin-right:.5rem;padding:.25rem .5rem;transition:all .2s ease}.action-link:hover{background:#3b82f61a;color:#1d4ed8}.badge{border-radius:9999px;display:inline-block;font-size:.75rem;font-weight:600;letter-spacing:.05em;padding:.375rem .75rem;text-transform:uppercase}.badge-success{background:linear-gradient(135deg,#10b981,#059669);color:#fff}.badge-warning{background:linear-gradient(135deg,#f59e0b,#d97706);color:#fff}.badge-error{background:linear-gradient(135deg,#ef4444,#dc2626);color:#fff}.badge-info{background:linear-gradient(135deg,#3b82f6,#1d4ed8);color:#fff}.badge-internal{background:linear-gradient(135deg,#8b5cf6,#7c3aed);color:#fff}.badge-external{background:linear-gradient(135deg,#10b981,#059669);color:#fff}.modal-overlay{align-items:center;background:#00000080;display:flex;justify-content:center;inset:0;padding:1rem;position:fixed;z-index:2000}.modal-content{background:#fff;border-radius:16px;box-shadow:0 20px 50px #0003;max-height:90vh;max-width:500px;overflow-y:auto;width:100%}.modal-header{align-items:center;border-bottom:1px solid #e2e8f0;display:flex;justify-content:space-between;padding:1.5rem 2rem}.modal-title{color:#1e293b;font-size:1.25rem;font-weight:700;margin:0}.close-btn{background:none;border:none;border-radius:6px;color:#64748b;cursor:pointer;font-size:1.5rem;padding:.25rem;transition:all .2s ease}.close-btn:hover{background:#f1f5f9;color:#374151}.modal-body{padding:2rem}.modal-footer{border-top:1px solid #e2e8f0;padding:1.5rem 2rem}.form-group{margin-bottom:1.5rem}.form-group label{color:#374151;display:block;font-size:.875rem;font-weight:600;margin-bottom:.5rem}.form-input{background:#fff;border:1px solid #d1d5db;border-radius:8px;font-size:.875rem;padding:.75rem 1rem;transition:all .2s ease;width:100%}.form-input:focus{border-color:#3b82f6;box-shadow:0 0 0 3px #3b82f61a;outline:none}.btn{align-items:center;border:none;border-radius:8px;cursor:pointer;display:inline-flex;font-size:.875rem;font-weight:500;gap:.5rem;justify-content:center;min-height:36px;overflow:hidden;padding:.5rem 1rem;position:relative;text-decoration:none;transition:all .3s ease;-webkit-user-select:none;-moz-user-select:none;user-select:none;white-space:nowrap}.btn:before{background:linear-gradient(90deg,transparent,hsla(0,0%,100%,.2),transparent);content:"";height:100%;left:-100%;position:absolute;top:0;transition:left .5s ease;width:100%}.btn:hover:before{left:100%}.btn-primary{background:linear-gradient(135deg,#3b82f6,#1d4ed8);border:1px solid rgba(59,130,246,.2);box-shadow:none!important;color:#fff}.btn-primary:hover{background:linear-gradient(135deg,#2563eb,#1e40af);box-shadow:none!important;transform:translateY(-2px)}.btn-primary:active{box-shadow:none!important;transform:translateY(0)}.btn-secondary{background:linear-gradient(135deg,#6b7280,#4b5563);border:1px solid hsla(220,9%,46%,.2);box-shadow:0 4px 15px #6b72804d;color:#fff}.btn-secondary:hover{background:linear-gradient(135deg,#4b5563,#374151);box-shadow:0 8px 25px #6b728066;transform:translateY(-2px)}.btn-success{background:linear-gradient(135deg,#10b981,#059669);border:1px solid rgba(16,185,129,.2);box-shadow:0 4px 15px #10b9814d;color:#fff}.btn-success:hover{background:linear-gradient(135deg,#059669,#047857);box-shadow:0 8px 25px #10b98166;transform:translateY(-2px)}.btn-warning{background:linear-gradient(135deg,#f59e0b,#d97706);border:1px solid rgba(245,158,11,.2);box-shadow:0 4px 15px #f59e0b4d;color:#fff}.btn-warning:hover{background:linear-gradient(135deg,#d97706,#b45309);box-shadow:0 8px 25px #f59e0b66;transform:translateY(-2px)}.btn-error{background:linear-gradient(135deg,#ef4444,#dc2626);border:1px solid rgba(239,68,68,.2);box-shadow:0 4px 15px #ef44444d;color:#fff}.btn-error:hover{background:linear-gradient(135deg,#dc2626,#b91c1c);box-shadow:0 8px 25px #ef444466;transform:translateY(-2px)}.btn-outline{background:transparent!important;border:1px solid rgba(37,99,235,.16)!important;box-shadow:none!important;color:#2563eb!important;min-height:32px!important;padding:.35rem .65rem!important}.btn-outline:hover{background:#2563eb0f!important;box-shadow:none!important;color:#1e40af!important;transform:none!important}.btn-outline:active{background:#2563eb1f!important}.financial-module .recent-invoices .table-actions,.financial-module .table-actions,.recent-invoices .table-actions{align-items:center;display:inline-flex;gap:.375rem}.financial-module .table-actions .btn,.recent-invoices .table-actions .btn{align-items:center;border-radius:6px;display:inline-flex;font-size:.8125rem;height:auto;justify-content:center;line-height:1;min-height:30px;padding:.28rem .55rem}.financial-module .table-actions .btn+.btn,.recent-invoices .table-actions .btn+.btn{margin-left:.35rem}.financial-module .table-actions .btn.btn-icon,.recent-invoices .table-actions .btn.btn-icon{border-radius:6px;height:34px;min-width:34px;padding:.35rem;width:34px}.financial-module .recent-invoices td.table-actions,.recent-invoices td.table-actions{white-space:nowrap}.recent-invoices,.recent-invoices .card,.recent-invoices .module-card,.recent-invoices .table,.recent-invoices .tabs-header,.recent-invoices .tabs-nav,.recent-invoices .tabs-section,.recent-invoices .tabs-section .tab-btn,.recent-invoices table{box-shadow:none!important}.recent-invoices .tabs-section{background:transparent!important;border:none!important}.recent-invoices .tabs-header,.recent-invoices .tabs-nav{background:transparent!important;border-bottom:none!important;box-shadow:none!important}.recent-invoices .table,.recent-invoices table{border:none!important;box-shadow:none!important}.recent-invoices table thead th{background:transparent!important;box-shadow:none!important}.recent-invoices .tabs-section,.tabs-section{border:1px solid rgba(226,232,240,.9)!important;border-radius:8px!important;padding:1rem!important}.btn-sm{border-radius:6px;font-size:.75rem;min-height:32px;padding:.375rem .75rem}.flex.items-center.gap-1{gap:.35rem!important}.flex.items-center.gap-1>*+*{margin-left:.35rem!important}.flex.items-center.gap-1>.btn{align-items:center!important;display:inline-flex!important;justify-content:center!important}.btn-lg{border-radius:16px;font-size:1rem;padding:1rem 2rem}.btn:disabled{box-shadow:none!important;cursor:not-allowed;opacity:.5;transform:none!important}.btn:disabled:before{display:none}.btn-icon{flex-shrink:0;height:16px;width:16px;stroke-width:2}.btn-sm .btn-icon{height:14px;width:14px}.btn-lg .btn-icon{height:20px;width:20px}@media (max-width:1024px){.content-body{padding:1.5rem}.kpi-grid{gap:1rem;grid-template-columns:repeat(auto-fit,minmax(250px,1fr))}.module-grid{gap:1rem;grid-template-columns:repeat(auto-fit,minmax(280px,1fr))}}.mobile-overlay{background:#00000080;display:none;inset:0;position:fixed;z-index:999}@media (max-width:768px){.mobile-close-btn,.mobile-menu-btn{display:flex}.collapse-btn{display:none}.mobile-overlay{display:block}.notification-btn{height:44px;width:44px}.notification-badge,.notification-icon{height:18px;width:18px}.notification-badge{font-size:.6875rem}.notifications-dropdown{border-radius:0;inset:0;margin:0;max-height:none;max-width:none;min-width:auto;position:fixed;z-index:1001}.notifications-header{border-bottom:1px solid #e2e8f0;padding:1rem}.notifications-content{height:calc(100vh - 80px);max-height:none}.no-notifications{padding:4rem 2rem}.notification-content{padding:1rem}.main-content{margin-left:0;width:100%}.content-header{padding:1rem 1.5rem}.header-main{align-items:flex-start;flex-direction:column;gap:1rem}.header-actions{justify-content:space-between;width:100%}.content-body{padding:1.5rem}.kpi-grid,.module-grid{gap:1rem}.actions-grid,.kpi-grid,.module-grid{grid-template-columns:1fr}.tabs-header{flex-direction:column}.tab-button{border-bottom:1px solid #e2e8f0}.tab-button:last-child{border-bottom:none}.data-table{min-width:600px}.modal-content{margin:1rem;max-width:calc(100% - 2rem)}}@media (max-width:480px){.content-body,.content-header{padding:1rem}.kpi-card,.module-card{padding:1.5rem}.modal-body,.modal-footer,.modal-header,.tabs-content{padding:1rem}.data-table td,.data-table th{padding:.75rem .5rem}}.mb-8{margin-bottom:2rem}.mb-4{margin-bottom:1rem}.mr-2{margin-right:.5rem}.text-gray-700{color:#374151}.flex{display:flex}.items-center{align-items:center}.justify-between{justify-content:space-between}.gap-6{gap:1.5rem}.gap-2{gap:.5rem}.progress-container{align-items:center;display:flex;gap:.75rem}.progress-bar{background:#e2e8f0;border-radius:4px;height:8px;overflow:hidden;width:100px}.progress-fill{background:linear-gradient(90deg,#3b82f6,#1d4ed8);border-radius:4px;height:100%;transition:width .3s ease}.progress-text{color:#374151;font-size:.875rem;font-weight:500;min-width:35px}.course-icon{align-items:center;background:linear-gradient(135deg,#3b82f6,#1d4ed8);border-radius:8px;display:flex;flex-shrink:0;height:40px;justify-content:center;margin-right:.75rem;width:40px}.course-icon-svg{color:#fff;height:20px;width:20px;stroke-width:2}.course-name{color:#111827;font-weight:500;margin-bottom:.25rem}.course-instructor{color:#6b7280;font-size:.875rem}.notifications-panel{background:#fff;border-radius:12px;box-shadow:0 10px 30px #0003;max-height:400px;overflow-y:auto;position:fixed;right:2rem;top:4rem;width:320px;z-index:1500}.notifications-header{padding:1rem 1.5rem}.notifications-title{font-weight:700}.notifications-content{padding:1rem 0}.no-notifications{font-style:italic;padding:2rem 1.5rem}.notification-item{padding:1rem 1.5rem;transition:background .2s ease}.notification-dot{background:#3b82f6;margin-top:.5rem}.notification-message{font-size:.75rem;margin:0 0 .25rem}.notification-time{color:#9ca3af}.user-menu-wrapper{position:relative}.notification-btn{align-items:center;border:2px solid #e2e8f0;color:#374151;display:flex;height:48px;justify-content:center;transition:all .3s ease;width:48px}.notification-btn:hover{background:linear-gradient(135deg,#f8fafc,#e2e8f0);border-color:#cbd5e0;box-shadow:0 8px 25px #0000001a;transform:translateY(-2px)}.notification-icon{stroke-width:2}.notification-badge{border-radius:50%;font-weight:600;height:20px;width:20px}.notifications-dropdown{background:#fff;border:1px solid #e2e8f0;border-radius:16px;box-shadow:0 20px 50px #00000026;margin-top:.75rem;max-height:480px;max-width:400px;min-width:320px;overflow:hidden;position:absolute;right:0;top:100%;z-index:1000}.notifications-header{align-items:center;background:linear-gradient(135deg,#f8fafc,#e2e8f0);border-bottom:1px solid #e2e8f0;display:flex;justify-content:space-between;padding:1rem 1.25rem}.notifications-title{color:#1e293b;font-size:1rem;font-weight:600;margin:0}.close-notifications-btn{background:none;border:none;border-radius:6px;color:#64748b;cursor:pointer;padding:.25rem;transition:all .2s ease}.close-notifications-btn:hover{background:#e2e8f0;color:#374151}.close-icon{height:18px;width:18px;stroke-width:2}.notifications-content{max-height:400px;overflow-y:auto}.no-notifications{align-items:center;color:#64748b;display:flex;flex-direction:column;justify-content:center;padding:3rem 2rem;text-align:center}.no-notifications-icon{height:48px;width:48px;stroke-width:1.5;margin-bottom:1rem;opacity:.5}.no-notifications p{font-size:.875rem;margin:0}.notification-item{border-bottom:1px solid #f1f5f9;transition:background-color .2s ease}.notification-item:hover{background:#f8fafc}.notification-item:last-child{border-bottom:none}.notification-content{align-items:flex-start;display:flex;gap:.75rem;padding:1rem 1.25rem}.notification-dot{background:linear-gradient(135deg,#3b82f6,#1d4ed8);border-radius:50%;flex-shrink:0;height:8px;margin-top:.25rem;width:8px}.notification-details{flex:1;min-width:0}.notification-title{color:#1e293b;font-size:.875rem;font-weight:600;line-height:1.4;margin:0 0 .25rem}.notification-message{color:#64748b;font-size:.8125rem;line-height:1.4;margin:0 0 .5rem}.notification-time{color:#94a3b8;font-size:.75rem;margin:0}.user-menu-btn{align-items:center;background:#fff;border:1px solid #e2e8f0;border-radius:12px;color:#374151;cursor:pointer;display:flex;font-weight:600;gap:.75rem;overflow:hidden;padding:.75rem 1rem;position:relative;transition:all .3s ease}.user-menu-btn:before{background:linear-gradient(90deg,transparent,rgba(59,130,246,.1),transparent);content:"";height:100%;left:-100%;position:absolute;top:0;transition:left .5s ease;width:100%}.user-menu-btn:hover:before{left:100%}.user-menu-btn:hover{border-color:#3b82f6;box-shadow:0 4px 15px #3b82f633;transform:translateY(-1px)}.user-avatar{align-items:center;background:linear-gradient(135deg,#3b82f6,#1d4ed8);border-radius:10px;color:#fff;display:flex;font-size:.875rem;font-weight:700;height:36px;justify-content:center;width:36px}.user-name{font-size:.875rem;font-weight:600}.dropdown-icon{height:18px;transition:transform .3s ease;width:18px;stroke-width:2}.user-menu-wrapper:hover .dropdown-icon{transform:rotate(180deg)}.user-dropdown{animation:dropdownFadeIn .2s ease-out;-webkit-backdrop-filter:blur(10px);backdrop-filter:blur(10px);background:#fff;border:1px solid #e2e8f0;border-radius:16px;box-shadow:0 20px 50px #00000026;margin-top:.75rem;min-width:220px;overflow:hidden;position:absolute;right:0;top:100%;z-index:1000}@keyframes dropdownFadeIn{0%{opacity:0;transform:translateY(-10px)}to{opacity:1;transform:translateY(0)}}.dropdown-item{align-items:center;background:none;border:none;color:#374151;cursor:pointer;display:flex;font-size:.875rem;font-weight:500;gap:.75rem;padding:.875rem 1.25rem;position:relative;text-align:left;text-decoration:none;transition:all .2s ease;width:100%}.dropdown-item .dropdown-icon{flex-shrink:0;height:16px;width:16px;stroke-width:2}.dropdown-item:before{background:linear-gradient(135deg,#3b82f6,#1d4ed8);bottom:0;content:"";left:0;position:absolute;top:0;transition:width .3s ease;width:0}.dropdown-item:hover:before{width:4px}.dropdown-item:hover{background:linear-gradient(135deg,#f8fafc,#e2e8f0);color:#1e293b;padding-left:1.5rem;text-decoration:none}.dropdown-item-icon{flex-shrink:0;height:18px;width:18px;stroke-width:2}.dropdown-divider{background:linear-gradient(90deg,transparent,#e2e8f0,transparent);border:none;height:1px;margin:.5rem 0}.logout-btn{color:#dc2626}.logout-btn:hover{background:linear-gradient(135deg,#fef2f2,#fee2e2);color:#b91c1c}.form-select{-webkit-appearance:none;-moz-appearance:none;appearance:none;background:#fff;background-image:url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3E%3Cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m6 8 4 4 4-4'/%3E%3C/svg%3E");background-position:right .75rem center;background-repeat:no-repeat;background-size:1.5em 1.5em;border:2px solid #e2e8f0;border-radius:10px;color:#374151;cursor:pointer;font-size:.875rem;font-weight:500;padding:.75rem 2.5rem .75rem 1rem;transition:all .3s ease}.form-select:hover{border-color:#3b82f6;box-shadow:0 2px 8px #3b82f61a}.form-select:focus{border-color:#3b82f6;box-shadow:0 0 0 3px #3b82f61a;outline:none}.form-select:disabled{background-color:#f9fafb;color:#9ca3af;cursor:not-allowed}.table-actions{align-items:center;display:flex;flex-wrap:wrap;gap:.5rem}.table-actions .btn{border-radius:6px;font-size:.75rem}.table-actions .btn,.table-actions .btn-sm{min-height:28px;min-width:28px;padding:.25rem .5rem}.table-actions .btn-sm{font-size:.6875rem}.modal-footer{align-items:center;display:flex;flex-wrap:wrap;gap:1rem;justify-content:flex-end}.modal-footer .btn{min-width:100px;padding:.5rem 1rem}.btn-group{border-radius:12px;box-shadow:0 2px 8px #0000001a;display:inline-flex;overflow:hidden}.btn-group .btn{border-radius:0;border-right:1px solid hsla(0,0%,100%,.2);margin:0}.btn-group .btn:first-child{border-bottom-left-radius:12px;border-top-left-radius:12px}.btn-group .btn:last-child{border-bottom-right-radius:12px;border-right:none;border-top-right-radius:12px}.btn-group .btn:only-child{border-radius:12px}.notification-btn-wrapper{position:relative}.notification-btn{background:#fff;border:1px solid #e2e8f0;border-radius:12px;color:#64748b;cursor:pointer;padding:.75rem;position:relative;transition:all .2s ease}.notification-btn:hover{border-color:#3b82f6;box-shadow:0 2px 8px #3b82f61a;color:#3b82f6}.notification-icon{height:20px;width:20px}.notification-badge{align-items:center;background:linear-gradient(135deg,#ef4444,#dc2626);border:2px solid #fff;border-radius:9999px;color:#fff;display:flex;font-size:.75rem;font-weight:700;height:18px;justify-content:center;min-width:18px;padding:.125rem .375rem;position:absolute;right:-4px;top:-4px}@media (max-width:1024px){.profile-module .grid{gap:1.5rem;grid-template-columns:1fr}.profile-module .lg\\\\:col-span-1,.profile-module .lg\\\\:col-span-2{grid-column:span 1}}@media (max-width:768px){.profile-module .grid{gap:1rem;grid-template-columns:1fr}.profile-module .card-body{padding:1rem}.profile-module .w-32{height:5rem;width:5rem}.profile-module .w-16{height:3rem;width:3rem}.profile-module .grid.grid-cols-1.md\\\\:grid-cols-2{gap:1rem;grid-template-columns:1fr}.profile-module .form-group,.profile-module .module-actions{margin-bottom:1rem}.profile-module .module-actions .flex{align-items:stretch;flex-direction:column;gap:.5rem}.profile-module .btn{justify-content:center;width:100%}.profile-module .profile-card,.profile-module .profile-form-card,.profile-module .profile-photo-section .profile-card{border:1px solid var(--border-color);border-radius:12px;box-shadow:none!important}.profile-module .form-input,.profile-module .form-select,.profile-module .form-textarea{background:#fff!important;border:1px solid rgba(15,23,42,.06)!important;border-radius:10px!important;box-shadow:none!important;padding:.5rem .75rem!important;transition:border-color .12s ease,box-shadow .12s ease}.profile-module .form-textarea{padding:.5rem .7rem!important}.profile-module .form-input:focus,.profile-module .form-select:focus,.profile-module .form-textarea:focus{border-color:var(--primary-color)!important;box-shadow:0 0 0 4px #3b82f60f!important;outline:none!important}.profile-module .readonly-input{background:#f8fafc!important;border:1px solid rgba(15,23,42,.04)!important;color:var(--text-secondary)!important}.profile-module .form-label{align-items:center;display:flex;gap:.6rem}.profile-module .label-icon{align-items:center;color:var(--text-secondary);display:inline-flex;height:1.5rem;justify-content:center;width:1.5rem}.profile-module .avatar-edit-btn{background:transparent!important;border:1px solid rgba(15,23,42,.06)!important;border-radius:8px;box-shadow:none!important;padding:.35rem!important}.profile-module .form-grid{display:grid;gap:.75rem;grid-template-columns:1fr}@media (min-width:1024px){.profile-module .form-grid{grid-template-columns:repeat(2,1fr)}}.profile-module .form-section{margin-bottom:1rem}.profile-module .profile-stats .stat-item{background:#fff;border:1px solid rgba(15,23,42,.04);border-radius:8px;box-shadow:none;padding:.6rem}.profile-module .module-actions .btn,.profile-module .profile-card .btn,.profile-module .profile-form-card .btn{background-image:none!important;box-shadow:none!important}.profile-module .btn-primary{background:var(--primary-color)!important;border:1px solid rgba(59,130,246,.12)!important;color:#fff!important}.profile-module .btn-outline{background:transparent!important;border:1px solid var(--border-color)!important;color:var(--text-primary)!important}.profile-module .text-xl{font-size:1.125rem}.profile-module .text-lg{font-size:1rem}.profile-module .absolute.bottom-0.right-0{height:1.5rem;width:1.5rem}.profile-module .w-4.h-4{height:.75rem;width:.75rem}.profile-module .form-label svg{height:.875rem;width:.875rem}}@media (max-width:480px){.profile-module .card-body,.profile-module .card-header{padding:.75rem}.profile-module .w-32{height:4rem;width:4rem}.profile-module .w-16{height:2.5rem;width:2.5rem}.profile-module .absolute.bottom-0.right-0{height:1.25rem;width:1.25rem}.profile-module .w-4.h-4{height:.625rem;width:.625rem}.profile-module .form-label svg{height:.75rem;width:.75rem}.profile-module .text-xl{font-size:1rem}.profile-module .text-lg{font-size:.875rem}.profile-module .text-sm{font-size:.75rem}.profile-module .space-y-2>*+*{margin-top:.5rem}}.modern-card{background:linear-gradient(135deg,#fff,#f8fafc);border:1px solid #e2e8f0;border-radius:20px;box-shadow:0 4px 20px #00000014;overflow:hidden;padding:1.5rem;position:relative;transition:all .3s ease}.modern-card:before{background:linear-gradient(90deg,#3b82f6,#8b5cf6,#06b6d4);border-radius:20px 20px 0 0;content:"";height:4px;left:0;position:absolute;right:0;top:0}.modern-card:hover{border-color:#cbd5e0;box-shadow:0 8px 30px #0000001f;transform:translateY(-4px)}.kpi-icon-wrapper{align-items:center;border-radius:16px;display:flex;height:60px;justify-content:center;margin-bottom:1rem;overflow:hidden;position:relative;width:60px}.kpi-icon-wrapper:before{background:linear-gradient(135deg,#ffffff4d,#ffffff1a);border-radius:16px;content:"";inset:0;-webkit-mask:linear-gradient(#fff 0 0) content-box,linear-gradient(#fff 0 0);mask:linear-gradient(#fff 0 0) content-box,linear-gradient(#fff 0 0);-webkit-mask-composite:xor;mask-composite:exclude;padding:2px;position:absolute}.views-icon{background:linear-gradient(135deg,#3b82f6,#1d4ed8)}.engagement-icon{background:linear-gradient(135deg,#ef4444,#dc2626)}.followers-icon{background:linear-gradient(135deg,#10b981,#059669)}.rate-icon{background:linear-gradient(135deg,#8b5cf6,#7c3aed)}.revenue-icon{background:linear-gradient(135deg,#10b981,#059669)}.projects-icon{background:linear-gradient(135deg,#3b82f6,#1d4ed8)}.team-icon{background:linear-gradient(135deg,#f59e0b,#d97706)}.tasks-icon{background:linear-gradient(135deg,#8b5cf6,#7c3aed)}.marketing-icon{background:linear-gradient(135deg,#ef4444,#dc2626)}.elearning-icon{background:linear-gradient(135deg,#06b6d4,#0891b2)}.kpi-icon{color:#fff;height:28px;width:28px;stroke-width:2.5;z-index:1}.kpi-content{flex:1}.kpi-value{color:#1e293b;font-size:2rem;font-weight:700;line-height:1.2;margin-bottom:.5rem}.kpi-label{color:#64748b;letter-spacing:.05em;margin-bottom:.75rem;text-transform:uppercase}.kpi-change,.kpi-label{font-size:.875rem;font-weight:600}.kpi-change{align-items:center;display:flex;gap:.5rem}.kpi-change.positive{color:#059669}.kpi-change.negative{color:#dc2626}.change-icon{height:16px;width:16px;stroke-width:2.5}@media (max-width:768px){.modern-card{padding:1.25rem}.kpi-icon-wrapper{height:50px;margin-bottom:.75rem;width:50px}.kpi-icon{height:24px;width:24px}.kpi-value{font-size:1.75rem}}.profile-layout{display:flex;flex-direction:column;gap:1.5rem}.profile-form-section,.profile-photo-section{width:100%}.profile-card{background:linear-gradient(135deg,#667eea,#764ba2);border-radius:20px;box-shadow:0 20px 40px #0000001a;color:#fff;overflow:hidden;padding:2rem;position:relative}.profile-card:before{background:linear-gradient(135deg,#ffffff1a,#ffffff0d);content:"";inset:0;pointer-events:none;position:absolute}.profile-header{margin-bottom:2rem;position:relative;text-align:center;z-index:1}.profile-avatar-section{margin-bottom:1.5rem}.profile-avatar{display:inline-block;position:relative}.avatar-image{-o-object-fit:cover;object-fit:cover}.avatar-image,.avatar-placeholder{border:4px solid hsla(0,0%,100%,.3);border-radius:50%;box-shadow:0 10px 30px #0003;height:120px;width:120px}.avatar-placeholder{align-items:center;background:#fff3;display:flex;justify-content:center}.avatar-icon{color:#fffc;height:48px;width:48px}.avatar-edit-btn{align-items:center;background:#3b82f6;border:none;border-radius:50%;bottom:0;box-shadow:0 4px 12px #3b82f666;cursor:pointer;display:flex;height:36px;justify-content:center;position:absolute;right:0;transition:all .3s ease;width:36px}.avatar-edit-btn:hover{background:#2563eb;transform:scale(1.1)}.profile-module .profile-card{background:#fff!important;border:1px solid var(--border-color)!important;border-radius:12px!important;box-shadow:none!important;color:var(--text-primary)!important;overflow:visible!important;padding:1rem!important}.profile-module .profile-card:before{background:none!important;display:none!important}.profile-module .avatar-image,.profile-module .avatar-placeholder{border:2px solid rgba(15,23,42,.04)!important;border-radius:50%!important;box-shadow:none!important;height:64px!important;-o-object-fit:cover!important;object-fit:cover!important;width:64px!important}.profile-module .avatar-edit-btn{background:transparent!important;border:1px solid rgba(15,23,42,.06)!important;box-shadow:none!important;color:var(--text-primary)!important;height:28px!important;width:28px!important}.profile-module .form-section{background:transparent!important;border:1px solid var(--border-color)!important;border-radius:10px!important;box-shadow:none!important;padding:.75rem!important}.profile-module .form-section:before{display:none!important}.profile-module .section-header{border-bottom:none!important;margin-bottom:.5rem!important;padding-bottom:.4rem!important}.profile-module .form-input,.profile-module .form-select,.profile-module input[type=email],.profile-module input[type=tel],.profile-module input[type=text],.profile-module textarea{background:#fff!important;border:1px solid rgba(15,23,42,.06)!important;border-radius:8px!important;box-shadow:none!important;color:var(--text-primary)!important;padding:.45rem .6rem!important}.profile-module .profile-header,.profile-module .profile-header .text-lg,.profile-module .profile-header .text-xl,.profile-module .profile-title{color:var(--text-primary)!important}.edit-icon{color:#fff;height:18px;width:18px}.profile-info{margin-bottom:2rem}.profile-name{font-size:1.5rem;font-weight:700;margin-bottom:.5rem;text-shadow:0 2px 4px rgba(0,0,0,.1)}.profile-email{font-size:1rem;margin-bottom:1rem;opacity:.9}.profile-badge{align-items:center;-webkit-backdrop-filter:blur(10px);backdrop-filter:blur(10px);background:#fff3;border-radius:20px;display:inline-flex;font-size:.875rem;font-weight:500;gap:.5rem;padding:.5rem 1rem}.badge-icon{color:#10b981;height:16px;width:16px}.profile-stats{position:relative;z-index:1}.stat-item{align-items:center;-webkit-backdrop-filter:blur(10px);backdrop-filter:blur(10px);background:#ffffff1a;border-radius:12px;display:flex;gap:1rem;margin-bottom:.75rem;padding:1rem;transition:all .3s ease}.stat-item:hover{background:#ffffff26;transform:translateY(-2px)}.stat-icon{align-items:center;background:#fff3;border-radius:10px;display:flex;flex-shrink:0;height:40px;justify-content:center;width:40px}.stat-icon svg{color:#fff;height:20px;width:20px}.stat-content{flex:1}.stat-label{display:block;font-size:.75rem;letter-spacing:.5px;margin-bottom:.25rem;opacity:.8;text-transform:uppercase}.stat-value{display:block;font-size:.875rem;font-weight:600}.profile-form-card{background:#fff;border:1px solid #e5e7eb;border-radius:24px;box-shadow:0 25px 50px #00000014;overflow:hidden;position:relative}.profile-form-card:before{background:linear-gradient(135deg,#667eea,#764ba2);content:"";height:4px;left:0;position:absolute;right:0;top:0}.form-header{background:linear-gradient(135deg,#f8fafc,#f1f5f9);border-bottom:1px solid #e2e8f0;padding:1.5rem 2rem;position:relative}.form-header:after{background:linear-gradient(135deg,#667eea,#764ba2);border-radius:2px;bottom:0;content:"";height:3px;left:50%;position:absolute;transform:translate(-50%);width:60px}.form-title-section{position:relative;text-align:center}.form-title{color:#1e293b;font-size:1.5rem;font-weight:700;margin-bottom:.5rem;position:relative}.form-title:after{background:linear-gradient(135deg,#667eea,#764ba2);border-radius:1px;bottom:-8px;content:"";height:2px;left:50%;position:absolute;transform:translate(-50%);width:40px}.form-subtitle{color:#64748b;font-size:.95rem;line-height:1.6;margin:0 auto;max-width:500px}.form-body{background:linear-gradient(135deg,#fafbfc,#f8fafc);padding:1.5rem 2rem}.form-section{background:#fff;border:1px solid #f1f5f9;border-radius:12px;box-shadow:0 2px 10px #0000000a;margin-bottom:1.5rem;overflow:hidden;padding:1.25rem;position:relative}.form-section:before{background:linear-gradient(135deg,#3b82f6,#1d4ed8);content:"";height:3px;left:0;position:absolute;right:0;top:0}.form-section:last-child{margin-bottom:0}.section-header{align-items:center;border-bottom:1px solid #e2e8f0;display:flex;gap:1rem;margin-bottom:1rem;padding-bottom:.75rem;position:relative}.section-header:after{border-radius:1px;bottom:0;content:"";height:2px;left:0;position:absolute;width:50px}.section-header:after,.section-icon{background:linear-gradient(135deg,#3b82f6,#1d4ed8)}.section-icon{align-items:center;border-radius:10px;box-shadow:0 4px 15px #3b82f64d;display:flex;flex-shrink:0;height:40px;justify-content:center;position:relative;width:40px}.section-icon:before{background:linear-gradient(135deg,#fff3,#ffffff1a);border-radius:14px;content:"";inset:0;-webkit-mask:linear-gradient(#fff 0 0) content-box,linear-gradient(#fff 0 0);mask:linear-gradient(#fff 0 0) content-box,linear-gradient(#fff 0 0);-webkit-mask-composite:xor;mask-composite:exclude;padding:1px;position:absolute}.section-icon svg{color:#fff;height:20px;position:relative;width:20px;z-index:1}.readonly-icon{background:linear-gradient(135deg,#6b7280,#4b5563);box-shadow:0 8px 25px #6b72804d}.section-title{color:#1e293b;flex:1;font-size:1.125rem;font-weight:600;position:relative}.readonly-badge{align-items:center;background:#fef3c7;border-radius:20px;color:#92400e;display:flex;font-size:.75rem;font-weight:500;gap:.5rem;padding:.5rem 1rem}.readonly-badge svg{height:16px;width:16px}.form-grid{display:grid;gap:1.25rem;grid-template-columns:repeat(auto-fit,minmax(300px,1fr))}.form-group{margin-bottom:0;position:relative}.form-label{color:#374151;font-size:.875rem;font-weight:600;gap:.75rem;margin-bottom:.75rem}.form-label,.label-icon{align-items:center;display:flex;position:relative}.label-icon{background:linear-gradient(135deg,#f8fafc,#e2e8f0);border:1px solid #e2e8f0;border-radius:8px;flex-shrink:0;height:32px;justify-content:center;transition:all .3s ease;width:32px}.label-icon:before{background:linear-gradient(135deg,#3b82f61a,#3b82f60d);border-radius:10px;content:"";inset:0;opacity:0;position:absolute;transition:opacity .3s ease}.label-icon svg{color:#64748b;height:16px;position:relative;transition:color .3s ease;width:16px;z-index:1}.social-icon{background:#f8fafc}.social-icon.instagram{background:linear-gradient(135deg,#fdf2f8,#fce7f3)}.social-icon.instagram svg{color:#ec4899}.social-icon.tiktok{background:linear-gradient(135deg,#f0fdf4,#dcfce7)}.social-icon.tiktok svg{color:#22c55e}.social-icon.facebook{background:linear-gradient(135deg,#eff6ff,#dbeafe)}.social-icon.facebook svg{color:#3b82f6}.readonly-indicator{color:#ef4444;font-weight:600;margin-left:auto}.form-input,.form-textarea{background:linear-gradient(135deg,#fafbfc,#f8fafc);border:2px solid #e2e8f0;border-radius:10px;color:#374151;font-size:.875rem;font-weight:500;padding:.875rem;position:relative;transition:all .3s ease;width:100%}.form-input:hover,.form-textarea:hover{background:#fff;border-color:#cbd5e1;box-shadow:0 4px 15px #0000000d;transform:translateY(-1px)}.form-input:focus,.form-textarea:focus{background:#fff;border-color:#3b82f6;box-shadow:0 0 0 4px #3b82f61a,0 8px 25px #3b82f626;outline:none;transform:translateY(-2px)}.form-group:hover .label-icon:before{opacity:1}.form-group:hover .label-icon svg{color:#3b82f6}.form-textarea{min-height:80px;resize:vertical}.readonly-input{background:#f8fafc!important;border-color:#cbd5e1!important;color:#64748b!important;cursor:not-allowed}.readonly-group .label-icon{background:#f1f5f9}.readonly-group .label-icon svg{color:#94a3b8}@media (max-width:1200px){.profile-module .grid{gap:2rem;grid-template-columns:1fr}.profile-module .lg\\\\:col-span-1,.profile-module .lg\\\\:col-span-2{grid-column:span 1}.form-grid{gap:1.25rem;grid-template-columns:repeat(auto-fit,minmax(280px,1fr))}}@media (max-width:1024px){.profile-card{padding:1.5rem}.form-body,.form-header{padding:1.25rem 1.5rem}.form-grid{gap:1rem;grid-template-columns:1fr}.form-section{margin-bottom:1.25rem;padding:1rem}.section-header{align-items:flex-start;flex-direction:column;gap:.75rem}.readonly-badge{align-self:flex-start}.form-title{font-size:1.5rem}.section-title{font-size:1.25rem}}@media (max-width:768px){.profile-module{padding:1rem}.profile-card{margin-bottom:1rem;padding:1rem}.form-body,.form-header{padding:1rem}.form-section{margin-bottom:1rem;padding:1rem}.avatar-image,.avatar-placeholder{height:100px;width:100px}.avatar-icon{height:40px;width:40px}.avatar-edit-btn{height:32px;width:32px}.edit-icon{height:16px;width:16px}.form-title,.profile-name{font-size:1.25rem}.form-subtitle{font-size:.8rem}.section-title{font-size:1.125rem}.section-icon{height:40px;width:40px}.section-icon svg{height:20px;width:20px}.label-icon{height:28px;width:28px}.label-icon svg{height:14px;width:14px}.form-input,.form-textarea{font-size:.8rem;padding:.875rem}.form-label{font-size:.8rem;gap:.5rem}.stat-item{gap:.75rem;padding:.875rem}.stat-icon{height:36px;width:36px}.stat-icon svg{height:18px;width:18px}.stat-label{font-size:.7rem}.stat-value{font-size:.8rem}}.nav-tabs,.nav-tabs .nav-item,.tab-header,.tab-header .tab,.tab-list,.tab-list .tab,.tabs,.tabs .tab,.tabs-container,.tabs-header{border-radius:0!important}.nav-tabs .nav-item:first-child,.tab-header .tab:first-child,.tab-list .tab:first-child,.tabs .tab:first-child{border-bottom-left-radius:0!important;border-top-left-radius:0!important}.nav-tabs .nav-item:last-child,.tab-header .tab:last-child,.tab-list .tab:last-child,.tabs .tab:last-child{border-bottom-right-radius:0!important;border-top-right-radius:0!important}.card.with-tabs,.panel.with-tabs,.tab-panel.with-tabs{border-top-left-radius:0!important;border-top-right-radius:0!important}.financial-module .table{border:1px solid rgba(226,232,240,.9)!important;border-radius:0!important;box-shadow:none!important;overflow:visible!important}.financial-module .table th,.financial-module .table thead th{background:#f3f4f6!important;border-bottom:1px solid #e2e8f0!important;border-radius:0!important;color:#0f172a!important;font-weight:600!important}.financial-module .table thead th:first-child,.financial-module .table thead th:last-child{border-top-left-radius:0!important;border-top-right-radius:0!important}.financial-module .table tbody tr{border-radius:0!important}.badge{align-items:center!important;background:#0f172a0a!important;border:1px solid rgba(15,23,42,.05)!important;border-radius:6px!important;color:#0f172a!important;display:inline-flex!important;font-size:.7rem!important;font-weight:600!important;gap:.4rem!important;letter-spacing:.03em!important;padding:.25rem .5rem!important;text-transform:uppercase!important}.badge .dot{border-radius:50%;display:inline-block;height:8px;width:8px}.badge-success{background:#ecfdf5!important;border-color:#065f4614!important;color:#065f46!important}.badge-warning{background:#fff7ed!important;border-color:#92400e14!important;color:#92400e!important}.badge-error{background:#fff1f2!important;border-color:#7f1d1d14!important;color:#7f1d1d!important}.badge-info{background:#eff6ff!important;border-color:#1e3a8a14!important;color:#1e3a8a!important}.badge-internal{background:#f5f3ff!important;border-color:#5b21b60f!important;color:#5b21b6!important}.badge-external{background:#ecfdf5!important;border-color:#064e3b0f!important;color:#064e3b!important}.table tbody td .badge{font-size:.65rem!important;padding:.2rem .45rem!important}.financial-module .action-btn,.financial-module .action-link,.financial-module .table-actions .btn{align-items:center!important;background:#fff!important;border:1px solid rgba(15,23,42,.06)!important;border-radius:6px!important;box-shadow:none!important;color:#0f172a!important;display:inline-flex!important;font-size:.8rem!important;gap:.5rem!important;padding:.35rem .6rem!important;text-decoration:none!important;transition:background .15s ease,transform .12s ease,color .12s ease}.financial-module .action-btn.primary,.financial-module .table-actions .btn.primary{background:#2563eb!important;border-color:transparent!important;color:#fff!important}.financial-module .action-btn.ghost,.financial-module .table-actions .btn.ghost{background:transparent!important;border-color:#0f172a0f!important;color:#0f172a!important}.financial-module .action-btn:hover,.financial-module .action-link:hover,.financial-module .table-actions .btn:hover{background:#0f172a08!important;transform:translateY(-1px)!important}.financial-module .icon-btn,.financial-module .table-actions .btn-icon{background:transparent!important;border:1px solid rgba(15,23,42,.06)!important;border-radius:6px!important;display:inline-grid!important;height:36px!important;padding:.32rem!important;place-items:center!important;width:36px!important}.financial-module .table-actions .btn-sm{font-size:.7rem!important;padding:.2rem .45rem!important}.financial-module .table-actions{align-items:center!important;display:flex!important;gap:.4rem!important}.financial-module .action-btn.primary:hover{background:#1e40af!important}@media (max-width:768px){.financial-module .action-btn,.financial-module .table-actions .btn{font-size:.75rem!important;padding:.3rem .45rem!important}.financial-module .icon-btn,.financial-module .table-actions .btn-icon{height:34px!important;width:34px!important}}.actions-grid,.kpi-grid,.module-grid{gap:.75rem!important;grid-template-columns:repeat(auto-fit,minmax(220px,1fr))!important}.card,.chart-card,.feature-card,.kpi-card,.modal,.module-card,.quick-actions-card,.toast{box-shadow:none!important}.card,.feature-card,.kpi-card,.module-card,.quick-actions-card{background:#fff!important;border:1px solid rgba(226,232,240,.9)!important;border-radius:8px!important;padding:1rem!important}.kpi-card:before,.module-card:before{display:none!important}.feature-card:hover,.kpi-card:hover,.module-card:hover{box-shadow:none!important;transform:none!important}.kpi-value{font-size:1.5rem!important;font-weight:700!important;margin-bottom:.25rem!important}.kpi-label{font-size:.75rem!important;font-weight:600!important}.module-icon{font-size:1.125rem!important;height:40px!important;margin-bottom:.5rem!important;width:40px!important}.module-title{font-size:1rem!important;font-weight:600!important}.chart-card{border:1px solid rgba(226,232,240,.9)!important;border-radius:8px!important;box-shadow:none!important;padding:1rem!important}.card-body,.card-footer,.card-header{padding:.75rem!important}.content-header,.wide-header{box-shadow:none!important}.feature-card,.kpi-card,.module-card{background-image:none!important}@media (max-width:640px){.form-body,.form-header,.profile-card,.profile-module{padding:.75rem}.form-section{margin-bottom:2rem}.section-header{margin-bottom:1rem;padding-bottom:.75rem}.form-grid{gap:.75rem}.form-group{margin-bottom:0}.form-label{flex-wrap:wrap;margin-bottom:.5rem}.readonly-indicator{margin-left:0;margin-top:.25rem}}@media (max-width:480px){.profile-module{padding:.5rem}.profile-card{border-radius:16px}.form-body,.form-header,.profile-card{padding:.75rem}.avatar-image,.avatar-placeholder{height:80px;width:80px}.avatar-icon{height:32px;width:32px}.avatar-edit-btn{height:28px;width:28px}.edit-icon{height:14px;width:14px}.profile-name{font-size:1.125rem}.profile-email{font-size:.875rem}.form-title{font-size:1.125rem}.form-subtitle{font-size:.75rem;line-height:1.4}.section-title{font-size:1rem}.section-icon{height:36px;width:36px}.section-icon svg{height:18px;width:18px}.label-icon{height:24px;width:24px}.label-icon svg{height:12px;width:12px}.form-input,.form-textarea{border-radius:8px;font-size:.75rem;padding:.75rem}.form-label{font-size:.75rem;gap:.5rem}.stat-item{border-radius:8px;gap:.5rem;padding:.75rem}.stat-icon{border-radius:8px;height:32px;width:32px}.stat-icon svg{height:16px;width:16px}.stat-label{font-size:.65rem}.stat-value{font-size:.75rem}.readonly-badge{font-size:.7rem;padding:.375rem .75rem}.readonly-badge svg{height:14px;width:14px}}@media (max-width:360px){.profile-module{padding:.25rem}.profile-card{border-radius:12px;padding:.5rem}.form-body,.form-header{padding:.5rem}.avatar-image,.avatar-placeholder{height:70px;width:70px}.avatar-icon{height:28px;width:28px}.avatar-edit-btn{height:24px;width:24px}.edit-icon{height:12px;width:12px}.profile-name{font-size:1rem}.profile-email{font-size:.8rem}.form-title{font-size:1rem}.form-subtitle{font-size:.7rem}.section-title{font-size:.9rem}.section-icon{height:32px;width:32px}.section-icon svg{height:16px;width:16px}.label-icon{height:20px;width:20px}.label-icon svg{height:10px;width:10px}.form-input,.form-textarea{border-radius:6px;font-size:.7rem;padding:.625rem}.form-label{font-size:.7rem;gap:.375rem}.stat-item{border-radius:6px;gap:.375rem;padding:.625rem}.stat-icon{border-radius:6px;height:28px;width:28px}.stat-icon svg{height:14px;width:14px}.stat-label{font-size:.6rem}.stat-value{font-size:.7rem}}`;

const entryStyles_B6Ln3dgZ = [fonts, base, utilities, sidebar, layout, main];

export { entryStyles_B6Ln3dgZ as default };
//# sourceMappingURL=entry-styles.B6Ln3dgZ.mjs.map
