import { ref, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderAttr, ssrRenderList, ssrRenderClass, ssrIncludeBooleanAttr, ssrLooseContain, ssrLooseEqual } from 'vue/server-renderer';

const _sfc_main = {
  __name: "financial",
  __ssrInlineRender: true,
  setup(__props) {
    const activeTab = ref("invoices");
    const showZohoSettings = ref(false);
    const showUploadModal = ref(false);
    ref(false);
    const isUploading = ref(false);
    const isDragOver = ref(false);
    const invoiceFilter = ref("");
    const estimateFilter = ref("");
    const salesOrderFilter = ref("");
    const selectedFile = ref(null);
    const uploadDateFilter = ref("");
    const uploadSearchFilter = ref("");
    const uploadForm = ref({
      description: "",
      invoiceDate: "",
      amount: ""
    });
    const uploadedInvoices = ref([
      {
        id: "1",
        fileName: "Invoice_2024_001.pdf",
        description: "Monthly service invoice",
        uploadDate: /* @__PURE__ */ new Date("2024-04-15"),
        fileSize: 245760,
        // bytes
        fileType: "pdf",
        status: "processed",
        invoiceDate: /* @__PURE__ */ new Date("2024-04-01"),
        amount: 1500
      },
      {
        id: "2",
        fileName: "Receipt_Office_Supplies.jpg",
        description: "Office supplies purchase",
        uploadDate: /* @__PURE__ */ new Date("2024-04-10"),
        fileSize: 1024e3,
        // bytes
        fileType: "jpg",
        status: "pending",
        invoiceDate: /* @__PURE__ */ new Date("2024-04-08"),
        amount: 89.5
      }
    ]);
    const filteredUploadedInvoices = computed(() => {
      let filtered = uploadedInvoices.value;
      if (uploadDateFilter.value) {
        const filterDate = new Date(uploadDateFilter.value);
        filtered = filtered.filter((invoice) => {
          const invoiceDate = new Date(invoice.uploadDate);
          return invoiceDate.toDateString() === filterDate.toDateString();
        });
      }
      if (uploadSearchFilter.value) {
        const searchTerm = uploadSearchFilter.value.toLowerCase();
        filtered = filtered.filter(
          (invoice) => invoice.fileName.toLowerCase().includes(searchTerm) || invoice.description && invoice.description.toLowerCase().includes(searchTerm)
        );
      }
      return filtered;
    });
    const tabs = ref([
      { id: "invoices", name: "Invoices" },
      { id: "estimates", name: "Estimates" },
      { id: "sales-orders", name: "Sales Orders" }
    ]);
    const financialData = ref({
      revenue: 12e4,
      expenses: 45e3,
      profit: 75e3,
      invoices: [
        {
          id: "1",
          number: "INV-001",
          date: /* @__PURE__ */ new Date("2024-04-01"),
          dueDate: /* @__PURE__ */ new Date("2024-05-01"),
          customerName: "Acme Corp",
          amount: 5e3,
          status: "paid"
        },
        {
          id: "2",
          number: "INV-002",
          date: /* @__PURE__ */ new Date("2024-03-15"),
          dueDate: /* @__PURE__ */ new Date("2024-04-15"),
          customerName: "Globex Inc.",
          amount: 7500,
          status: "pending"
        },
        {
          id: "3",
          number: "INV-003",
          date: /* @__PURE__ */ new Date("2024-02-20"),
          dueDate: /* @__PURE__ */ new Date("2024-03-20"),
          customerName: "Soylent Corp",
          amount: 3e3,
          status: "overdue"
        }
      ],
      estimates: [
        {
          id: "1",
          number: "EST-001",
          date: /* @__PURE__ */ new Date("2024-01-10"),
          expiryDate: /* @__PURE__ */ new Date("2024-02-10"),
          customerName: "Acme Corp",
          amount: 6e3,
          status: "accepted"
        },
        {
          id: "2",
          number: "EST-002",
          date: /* @__PURE__ */ new Date("2024-03-01"),
          expiryDate: /* @__PURE__ */ new Date("2024-04-01"),
          customerName: "Globex Inc.",
          amount: 8e3,
          status: "sent"
        },
        {
          id: "3",
          number: "EST-003",
          date: /* @__PURE__ */ new Date("2024-04-05"),
          expiryDate: /* @__PURE__ */ new Date("2024-05-05"),
          customerName: "Soylent Corp",
          amount: 2500,
          status: "draft"
        }
      ],
      salesOrders: [
        {
          id: "1",
          number: "SO-001",
          date: /* @__PURE__ */ new Date("2024-03-20"),
          customerName: "Acme Corp",
          amount: 1e4,
          status: "confirmed"
        },
        {
          id: "2",
          number: "SO-002",
          date: /* @__PURE__ */ new Date("2024-04-10"),
          customerName: "Globex Inc.",
          amount: 12e3,
          status: "pending"
        }
      ]
    });
    const zohoConnection = ref({
      apiKey: "YOUR_ZOHO_API_KEY",
      organizationId: "YOUR_ZOHO_ORG_ID",
      lastSync: null
    });
    const formatDate = (date) => {
      return new Date(date).toLocaleDateString("en-US", {
        year: "numeric",
        month: "short",
        day: "numeric"
      });
    };
    const getInvoiceStatusBadgeClass = (status) => {
      switch (status) {
        case "paid":
          return "badge-success";
        case "pending":
          return "badge-warning";
        case "overdue":
          return "badge-error";
        default:
          return "badge-info";
      }
    };
    const getEstimateStatusBadgeClass = (status) => {
      switch (status) {
        case "accepted":
          return "badge-success";
        case "sent":
          return "badge-info";
        case "draft":
          return "badge-warning";
        case "rejected":
          return "badge-error";
        default:
          return "badge-info";
      }
    };
    const getSalesOrderStatusBadgeClass = (status) => {
      switch (status) {
        case "confirmed":
          return "badge-success";
        case "pending":
          return "badge-warning";
        case "cancelled":
          return "badge-error";
        default:
          return "badge-info";
      }
    };
    const formatFileSize = (bytes) => {
      if (bytes === 0) return "0 Bytes";
      const k = 1024;
      const sizes = ["Bytes", "KB", "MB", "GB"];
      const i = Math.floor(Math.log(bytes) / Math.log(k));
      return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + " " + sizes[i];
    };
    const getFileTypeBadgeClass = (fileType) => {
      switch (fileType.toLowerCase()) {
        case "pdf":
          return "badge-error";
        case "jpg":
        case "jpeg":
        case "png":
          return "badge-info";
        case "doc":
        case "docx":
          return "badge-warning";
        default:
          return "badge-info";
      }
    };
    const getStatusBadgeClass = (status) => {
      switch (status) {
        case "processed":
          return "badge-success";
        case "pending":
          return "badge-warning";
        case "error":
          return "badge-error";
        default:
          return "badge-info";
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "financial-module" }, _attrs))}><div class="content-body"><div class="kpi-grid mb-8"><div class="kpi-card"><div class="kpi-value"> \u20AC${ssrInterpolate(unref(financialData).revenue.toLocaleString())}</div><div class="kpi-label">Total Revenue</div><div class="kpi-change positive">+8% from last month</div></div><div class="kpi-card"><div class="kpi-value"> \u20AC${ssrInterpolate(unref(financialData).expenses.toLocaleString())}</div><div class="kpi-label">Total Expenses</div><div class="kpi-change negative">+3% from last month</div></div><div class="kpi-card"><div class="kpi-value"> \u20AC${ssrInterpolate(unref(financialData).profit.toLocaleString())}</div><div class="kpi-label">Net Profit</div><div class="kpi-change positive">+12% from last month</div></div><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(unref(financialData).invoices.length)}</div><div class="kpi-label">Total Invoices</div><div class="kpi-change">+2 this week</div></div></div><div class="card mb-8"><div class="card-header"><div class="flex items-center justify-between"><div><h3 class="card-title">My Uploaded Invoices</h3><p class="card-subtitle"> Upload and manage your own invoice files </p></div><button class="btn btn-primary" title="Upload Invoice"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg></button></div></div><div class="card-body"><div class="flex items-center gap-4 mb-6"><div class="flex items-center gap-2"><label class="text-sm font-medium text-gray-700">Filter by Date:</label><input${ssrRenderAttr("value", unref(uploadDateFilter))} type="date" class="form-input"></div><div class="flex items-center gap-2"><label class="text-sm font-medium text-gray-700">Search:</label><input${ssrRenderAttr("value", unref(uploadSearchFilter))} type="text" placeholder="Search by filename..." class="form-input"></div><button class="btn btn-outline btn-sm" title="Clear Filters"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="overflow-x-auto"><table class="table"><thead><tr><th>File Name</th><th>Upload Date</th><th>File Size</th><th>Type</th><th>Status</th><th>Actions</th></tr></thead><tbody>`);
      if (unref(filteredUploadedInvoices).length === 0) {
        _push(`<tr><td colspan="6" class="text-center py-8 text-gray-500"><div class="flex flex-col items-center gap-2"><svg class="w-12 h-12 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg><p>No uploaded invoices found</p><p class="text-sm"> Upload your first invoice to get started </p></div></td></tr>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--[-->`);
      ssrRenderList(unref(filteredUploadedInvoices), (invoice) => {
        _push(`<tr><td data-label="File Name"><div class="flex items-center gap-3"><div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center"><svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg></div><div><div class="font-medium text-gray-900">${ssrInterpolate(invoice.fileName)}</div><div class="text-sm text-gray-500">${ssrInterpolate(invoice.description || "No description")}</div></div></div></td><td data-label="Upload Date">${ssrInterpolate(formatDate(invoice.uploadDate))}</td><td data-label="File Size">${ssrInterpolate(formatFileSize(invoice.fileSize))}</td><td data-label="Type"><span class="${ssrRenderClass([getFileTypeBadgeClass(invoice.fileType), "badge"])}">${ssrInterpolate(invoice.fileType.toUpperCase())}</span></td><td data-label="Status"><span class="${ssrRenderClass([getStatusBadgeClass(invoice.status), "badge"])}">${ssrInterpolate(invoice.status)}</span></td><td data-label="Actions"><div class="flex items-center gap-2"><button class="btn btn-outline btn-sm" title="Download"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg></button><button class="btn btn-outline btn-sm" title="View"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg></button><button class="btn btn-outline btn-sm text-red-600 hover:bg-red-50" title="Delete"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg></button></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div></div></div><div class="tabs-container card mb-8"><div class="tabs-header"><!--[-->`);
      ssrRenderList(unref(tabs), (tab) => {
        _push(`<button class="${ssrRenderClass([{ active: unref(activeTab) === tab.id }, "tab-button"])}">${ssrInterpolate(tab.name)}</button>`);
      });
      _push(`<!--]--></div><div class="tabs-content">`);
      if (unref(activeTab) === "invoices") {
        _push(`<div class="tab-pane"><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Recent Invoices</h3><div class="flex gap-2"><select class="form-select"><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(invoiceFilter)) ? ssrLooseContain(unref(invoiceFilter), "") : ssrLooseEqual(unref(invoiceFilter), "")) ? " selected" : ""}>All Status</option><option value="paid"${ssrIncludeBooleanAttr(Array.isArray(unref(invoiceFilter)) ? ssrLooseContain(unref(invoiceFilter), "paid") : ssrLooseEqual(unref(invoiceFilter), "paid")) ? " selected" : ""}>Paid</option><option value="pending"${ssrIncludeBooleanAttr(Array.isArray(unref(invoiceFilter)) ? ssrLooseContain(unref(invoiceFilter), "pending") : ssrLooseEqual(unref(invoiceFilter), "pending")) ? " selected" : ""}>Pending</option><option value="overdue"${ssrIncludeBooleanAttr(Array.isArray(unref(invoiceFilter)) ? ssrLooseContain(unref(invoiceFilter), "overdue") : ssrLooseEqual(unref(invoiceFilter), "overdue")) ? " selected" : ""}>Overdue</option></select><button class="btn btn-outline btn-sm" title="Refresh"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg></button></div></div><div class="overflow-x-auto"><table class="table"><thead><tr><th>Invoice #</th><th>Customer</th><th>Date</th><th>Due Date</th><th>Amount</th><th>Status</th><th>Actions</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(unref(financialData).invoices, (invoice) => {
          _push(`<tr><td data-label="Invoice #">${ssrInterpolate(invoice.number)}</td><td data-label="Customer">${ssrInterpolate(invoice.customerName)}</td><td data-label="Date">${ssrInterpolate(formatDate(invoice.date))}</td><td data-label="Due Date">${ssrInterpolate(formatDate(invoice.dueDate))}</td><td data-label="Amount"> \u20AC${ssrInterpolate(invoice.amount.toLocaleString())}</td><td data-label="Status"><span class="${ssrRenderClass([getInvoiceStatusBadgeClass(invoice.status), "badge"])}">${ssrInterpolate(invoice.status)}</span></td><td data-label="Actions"><div class="flex items-center gap-1"><button class="btn btn-outline btn-sm" title="View"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg></button><button class="btn btn-outline btn-sm" title="Edit"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg></button></div></td></tr>`);
        });
        _push(`<!--]--></tbody></table></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "estimates") {
        _push(`<div class="tab-pane"><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Recent Estimates</h3><div class="flex gap-2"><select class="form-select"><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(estimateFilter)) ? ssrLooseContain(unref(estimateFilter), "") : ssrLooseEqual(unref(estimateFilter), "")) ? " selected" : ""}>All Status</option><option value="accepted"${ssrIncludeBooleanAttr(Array.isArray(unref(estimateFilter)) ? ssrLooseContain(unref(estimateFilter), "accepted") : ssrLooseEqual(unref(estimateFilter), "accepted")) ? " selected" : ""}>Accepted</option><option value="sent"${ssrIncludeBooleanAttr(Array.isArray(unref(estimateFilter)) ? ssrLooseContain(unref(estimateFilter), "sent") : ssrLooseEqual(unref(estimateFilter), "sent")) ? " selected" : ""}>Sent</option><option value="draft"${ssrIncludeBooleanAttr(Array.isArray(unref(estimateFilter)) ? ssrLooseContain(unref(estimateFilter), "draft") : ssrLooseEqual(unref(estimateFilter), "draft")) ? " selected" : ""}>Draft</option><option value="rejected"${ssrIncludeBooleanAttr(Array.isArray(unref(estimateFilter)) ? ssrLooseContain(unref(estimateFilter), "rejected") : ssrLooseEqual(unref(estimateFilter), "rejected")) ? " selected" : ""}>Rejected</option></select><button class="btn btn-outline btn-sm" title="Refresh"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg></button></div></div><div class="overflow-x-auto"><table class="table"><thead><tr><th>Estimate #</th><th>Customer</th><th>Date</th><th>Expiry Date</th><th>Amount</th><th>Status</th><th>Actions</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(unref(financialData).estimates, (estimate) => {
          _push(`<tr><td data-label="Estimate #">${ssrInterpolate(estimate.number)}</td><td data-label="Customer">${ssrInterpolate(estimate.customerName)}</td><td data-label="Date">${ssrInterpolate(formatDate(estimate.date))}</td><td data-label="Expiry Date">${ssrInterpolate(formatDate(estimate.expiryDate))}</td><td data-label="Amount"> \u20AC${ssrInterpolate(estimate.amount.toLocaleString())}</td><td data-label="Status"><span class="${ssrRenderClass([getEstimateStatusBadgeClass(estimate.status), "badge"])}">${ssrInterpolate(estimate.status)}</span></td><td data-label="Actions"><div class="flex items-center gap-1"><button class="btn btn-outline btn-sm" title="View"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg></button><button class="btn btn-outline btn-sm" title="Edit"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg></button></div></td></tr>`);
        });
        _push(`<!--]--></tbody></table></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "sales-orders") {
        _push(`<div class="tab-pane"><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Recent Sales Orders</h3><div class="flex gap-2"><select class="form-select"><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(salesOrderFilter)) ? ssrLooseContain(unref(salesOrderFilter), "") : ssrLooseEqual(unref(salesOrderFilter), "")) ? " selected" : ""}>All Status</option><option value="confirmed"${ssrIncludeBooleanAttr(Array.isArray(unref(salesOrderFilter)) ? ssrLooseContain(unref(salesOrderFilter), "confirmed") : ssrLooseEqual(unref(salesOrderFilter), "confirmed")) ? " selected" : ""}>Confirmed</option><option value="pending"${ssrIncludeBooleanAttr(Array.isArray(unref(salesOrderFilter)) ? ssrLooseContain(unref(salesOrderFilter), "pending") : ssrLooseEqual(unref(salesOrderFilter), "pending")) ? " selected" : ""}>Pending</option><option value="cancelled"${ssrIncludeBooleanAttr(Array.isArray(unref(salesOrderFilter)) ? ssrLooseContain(unref(salesOrderFilter), "cancelled") : ssrLooseEqual(unref(salesOrderFilter), "cancelled")) ? " selected" : ""}>Cancelled</option></select><button class="btn btn-outline btn-sm" title="Refresh"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg></button></div></div><div class="overflow-x-auto"><table class="table"><thead><tr><th>Order #</th><th>Customer</th><th>Date</th><th>Amount</th><th>Status</th><th>Actions</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(unref(financialData).salesOrders, (order) => {
          _push(`<tr><td data-label="Order #">${ssrInterpolate(order.number)}</td><td data-label="Customer">${ssrInterpolate(order.customerName)}</td><td data-label="Date">${ssrInterpolate(formatDate(order.date))}</td><td data-label="Amount"> \u20AC${ssrInterpolate(order.amount.toLocaleString())}</td><td data-label="Status"><span class="${ssrRenderClass([getSalesOrderStatusBadgeClass(order.status), "badge"])}">${ssrInterpolate(order.status)}</span></td><td data-label="Actions"><div class="flex items-center gap-1"><button class="btn btn-outline btn-sm" title="View"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg></button><button class="btn btn-outline btn-sm" title="Edit"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg></button></div></td></tr>`);
        });
        _push(`<!--]--></tbody></table></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
      if (unref(showZohoSettings)) {
        _push(`<div class="modal-overlay"><div class="modal"><div class="modal-header"><h3 class="modal-title">Zoho Books Integration</h3><button class="modal-close"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><div class="form-group"><label class="form-label">API Key</label><input${ssrRenderAttr("value", unref(zohoConnection).apiKey)} type="text" class="form-input" placeholder="Enter your Zoho API key"></div><div class="form-group"><label class="form-label">Organization ID</label><input${ssrRenderAttr("value", unref(zohoConnection).organizationId)} type="text" class="form-input" placeholder="Enter your Zoho organization ID"></div><div class="form-group"><label class="form-label">Last Sync</label><input${ssrRenderAttr(
          "value",
          unref(zohoConnection).lastSync ? formatDate(unref(zohoConnection).lastSync) : "Never"
        )} type="text" class="form-input" readonly></div></div><div class="modal-footer"><button class="btn btn-outline" title="Test Connection"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg></button><button class="btn btn-primary" title="Sync Data"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg></button></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(showUploadModal)) {
        _push(`<div class="modal-overlay"><div class="modal"><div class="modal-header"><h3 class="modal-title">Upload Invoice</h3><button class="modal-close"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><div class="form-group"><label class="form-label">Invoice File</label><div class="${ssrRenderClass([{ "drag-over": unref(isDragOver) }, "file-upload-area"])}"><input type="file" accept=".pdf,.jpg,.jpeg,.png,.doc,.docx" class="hidden"><div class="text-center"><svg class="w-12 h-12 mx-auto text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg><p class="text-lg font-medium text-gray-900 mb-2"> Drop your invoice file here </p><p class="text-sm text-gray-500 mb-4">or click to browse</p><button class="btn btn-outline btn-sm"> Choose File </button><p class="text-xs text-gray-400 mt-2"> Supported formats: PDF, JPG, PNG, DOC, DOCX (Max 10MB) </p></div></div>`);
        if (unref(selectedFile)) {
          _push(`<div class="mt-4 p-3 bg-gray-50 rounded-lg"><div class="flex items-center justify-between"><div class="flex items-center gap-3"><div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center"><svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg></div><div><div class="font-medium text-gray-900">${ssrInterpolate(unref(selectedFile).name)}</div><div class="text-sm text-gray-500">${ssrInterpolate(formatFileSize(unref(selectedFile).size))}</div></div></div><button class="text-red-600 hover:text-red-800"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="form-group"><label class="form-label">Description (Optional)</label><textarea class="form-input" rows="3" placeholder="Add a description for this invoice...">${ssrInterpolate(unref(uploadForm).description)}</textarea></div><div class="form-group"><label class="form-label">Invoice Date</label><input${ssrRenderAttr("value", unref(uploadForm).invoiceDate)} type="date" class="form-input"></div><div class="form-group"><label class="form-label">Amount (Optional)</label><div class="relative"><span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500">\u20AC</span><input${ssrRenderAttr("value", unref(uploadForm).amount)} type="number" step="0.01" class="form-input pl-8" placeholder="0.00"></div></div></div><div class="modal-footer"><button class="btn btn-outline" title="Cancel"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button><button class="btn btn-primary"${ssrIncludeBooleanAttr(!unref(selectedFile) || unref(isUploading)) ? " disabled" : ""} title="Upload Invoice">`);
        if (unref(isUploading)) {
          _push(`<span class="spinner mr-2"></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg></button></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/c/[slug]/financial.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=financial-DJu3IB0J.mjs.map
