import { defineComponent, ref, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderAttr, ssrRenderList, ssrRenderClass, ssrIncludeBooleanAttr, ssrLooseContain, ssrLooseEqual } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const showCreateCustomerModal = ref(false);
    ref(false);
    const selectedTenant = ref(null);
    const searchQuery = ref("");
    const isCreating = ref(false);
    const newCustomer = ref({
      email: "",
      password: "",
      subscriptionTier: "",
      seatLimit: 1,
      companyName: ""
    });
    const stats = ref({
      totalCustomers: 156,
      activeSubscriptions: 142,
      monthlyRevenue: 45600,
      overduePayments: 8
    });
    const tenants = ref([
      {
        id: "1",
        customerId: "1",
        email: "customer1@example.com",
        subscriptionTier: "Pro",
        seatUsage: 5,
        seatLimit: 10,
        isActive: true,
        isLocked: false,
        createdAt: /* @__PURE__ */ new Date("2024-01-15"),
        billingStatus: "paid",
        lastPaymentDate: /* @__PURE__ */ new Date("2024-01-01"),
        nextPaymentDate: /* @__PURE__ */ new Date("2024-02-01")
      },
      {
        id: "2",
        customerId: "2",
        email: "customer2@example.com",
        subscriptionTier: "Basic",
        seatUsage: 2,
        seatLimit: 5,
        isActive: true,
        isLocked: false,
        createdAt: /* @__PURE__ */ new Date("2024-01-20"),
        billingStatus: "pending",
        lastPaymentDate: /* @__PURE__ */ new Date("2023-12-01"),
        nextPaymentDate: /* @__PURE__ */ new Date("2024-01-01")
      },
      {
        id: "3",
        customerId: "3",
        email: "customer3@example.com",
        subscriptionTier: "Advanced",
        seatUsage: 8,
        seatLimit: 15,
        isActive: false,
        isLocked: true,
        createdAt: /* @__PURE__ */ new Date("2024-01-10"),
        billingStatus: "overdue",
        lastPaymentDate: /* @__PURE__ */ new Date("2023-11-01"),
        nextPaymentDate: /* @__PURE__ */ new Date("2023-12-01")
      }
    ]);
    const filteredTenants = computed(() => {
      if (!searchQuery.value) return tenants.value;
      return tenants.value.filter(
        (tenant) => tenant.email.toLowerCase().includes(searchQuery.value.toLowerCase())
      );
    });
    const getTierBadgeClass = (tier) => {
      switch (tier) {
        case "Basic":
          return "badge-info";
        case "Pro":
          return "badge-success";
        case "Advanced":
          return "badge-warning";
        default:
          return "badge-info";
      }
    };
    const getBillingBadgeClass = (status) => {
      switch (status) {
        case "paid":
          return "badge-success";
        case "pending":
          return "badge-warning";
        case "overdue":
          return "badge-error";
        default:
          return "badge-info";
      }
    };
    const formatDate = (date) => {
      return new Intl.DateTimeFormat("en-US", {
        year: "numeric",
        month: "short",
        day: "numeric"
      }).format(date);
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "owner-dashboard" }, _attrs))}><div class="content-header"><div class="flex items-center justify-between"><div><h1 class="text-3xl font-bold text-gray-900">Owner Dashboard</h1><p class="text-gray-600 mt-1"> Manage all customers and their subscriptions </p></div><div class="flex gap-4"><button class="btn btn-primary"> Create Customer </button><button class="btn btn-outline"> Settings </button></div></div></div><div class="content-body"><div class="kpi-grid"><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(unref(stats).totalCustomers)}</div><div class="kpi-label">Total Customers</div><div class="kpi-change positive">+12% from last month</div></div><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(unref(stats).activeSubscriptions)}</div><div class="kpi-label">Active Subscriptions</div><div class="kpi-change positive">+8% from last month</div></div><div class="kpi-card"><div class="kpi-value"> \u20AC${ssrInterpolate(unref(stats).monthlyRevenue.toLocaleString())}</div><div class="kpi-label">Monthly Revenue</div><div class="kpi-change positive">+15% from last month</div></div><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(unref(stats).overduePayments)}</div><div class="kpi-label">Overdue Payments</div><div class="kpi-change negative">+3 from last week</div></div></div><div class="card"><div class="card-header"><div class="flex items-center justify-between"><h2 class="text-xl font-semibold">Customer Tenants</h2><div class="flex items-center gap-4"><div class="relative"><input${ssrRenderAttr("value", unref(searchQuery))} type="text" placeholder="Search customers..." class="form-input pl-10"><svg class="w-5 h-5 absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg></div></div></div></div><div class="card-body p-0"><div class="overflow-x-auto"><table class="table"><thead><tr><th>Customer Email</th><th>Subscription Tier</th><th>Seat Usage</th><th>Status</th><th>Billing Status</th><th>Created</th><th>Actions</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(unref(filteredTenants), (tenant) => {
        _push(`<tr><td class="font-medium" data-label="Customer Email">${ssrInterpolate(tenant.email)}</td><td data-label="Subscription Tier"><span class="${ssrRenderClass([getTierBadgeClass(tenant.subscriptionTier), "badge"])}">${ssrInterpolate(tenant.subscriptionTier)}</span></td><td data-label="Seat Usage">${ssrInterpolate(tenant.seatUsage)}/${ssrInterpolate(tenant.seatLimit)}</td><td data-label="Status"><span class="${ssrRenderClass([tenant.isActive ? "badge-success" : "badge-error", "badge"])}">${ssrInterpolate(tenant.isActive ? "Active" : "Inactive")}</span></td><td data-label="Billing Status"><span class="${ssrRenderClass([getBillingBadgeClass(tenant.billingStatus), "badge"])}">${ssrInterpolate(tenant.billingStatus)}</span></td><td data-label="Created">${ssrInterpolate(formatDate(tenant.createdAt))}</td><td data-label="Actions"><div class="flex items-center gap-2"><button class="btn btn-sm btn-outline"> View </button><button class="${ssrRenderClass([tenant.isActive ? "btn-warning" : "btn-success", "btn btn-sm"])}">${ssrInterpolate(tenant.isActive ? "Deactivate" : "Activate")}</button><button class="${ssrRenderClass([tenant.isLocked ? "btn-success" : "btn-warning", "btn btn-sm"])}">${ssrInterpolate(tenant.isLocked ? "Unlock" : "Lock")}</button><button class="btn btn-sm btn-error"> Delete </button></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div></div></div></div>`);
      if (unref(showCreateCustomerModal)) {
        _push(`<div class="modal-overlay"><div class="modal"><div class="modal-header"><h3 class="text-lg font-semibold">Create New Customer</h3><button class="text-gray-400 hover:text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><form><div class="form-group"><label class="form-label">Customer Email</label><input${ssrRenderAttr("value", unref(newCustomer).email)} type="email" class="form-input" required></div><div class="form-group"><label class="form-label">Password</label><input${ssrRenderAttr("value", unref(newCustomer).password)} type="password" class="form-input" required></div><div class="form-group"><label class="form-label">Subscription Tier</label><select class="form-select" required><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(newCustomer).subscriptionTier) ? ssrLooseContain(unref(newCustomer).subscriptionTier, "") : ssrLooseEqual(unref(newCustomer).subscriptionTier, "")) ? " selected" : ""}>Select Tier</option><option value="Basic"${ssrIncludeBooleanAttr(Array.isArray(unref(newCustomer).subscriptionTier) ? ssrLooseContain(unref(newCustomer).subscriptionTier, "Basic") : ssrLooseEqual(unref(newCustomer).subscriptionTier, "Basic")) ? " selected" : ""}>Basic</option><option value="Pro"${ssrIncludeBooleanAttr(Array.isArray(unref(newCustomer).subscriptionTier) ? ssrLooseContain(unref(newCustomer).subscriptionTier, "Pro") : ssrLooseEqual(unref(newCustomer).subscriptionTier, "Pro")) ? " selected" : ""}>Pro</option><option value="Advanced"${ssrIncludeBooleanAttr(Array.isArray(unref(newCustomer).subscriptionTier) ? ssrLooseContain(unref(newCustomer).subscriptionTier, "Advanced") : ssrLooseEqual(unref(newCustomer).subscriptionTier, "Advanced")) ? " selected" : ""}>Advanced</option></select></div><div class="form-group"><label class="form-label">Seat Limit</label><input${ssrRenderAttr("value", unref(newCustomer).seatLimit)} type="number" class="form-input" min="1" required></div><div class="form-group"><label class="form-label">Company Name</label><input${ssrRenderAttr("value", unref(newCustomer).companyName)} type="text" class="form-input" required></div></form></div><div class="modal-footer"><button class="btn btn-outline"> Cancel </button><button class="btn btn-primary"${ssrIncludeBooleanAttr(unref(isCreating)) ? " disabled" : ""}>`);
        if (unref(isCreating)) {
          _push(`<span class="spinner mr-2"></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(` Create Customer </button></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(selectedTenant)) {
        _push(`<div class="modal-overlay"><div class="modal"><div class="modal-header"><h3 class="text-lg font-semibold">Tenant Details</h3><button class="text-gray-400 hover:text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><div class="grid grid-cols-2 gap-4"><div><label class="form-label">Email</label><p class="text-gray-900">${ssrInterpolate(unref(selectedTenant).email)}</p></div><div><label class="form-label">Subscription Tier</label><p class="text-gray-900">${ssrInterpolate(unref(selectedTenant).subscriptionTier)}</p></div><div><label class="form-label">Seat Usage</label><p class="text-gray-900">${ssrInterpolate(unref(selectedTenant).seatUsage)}/${ssrInterpolate(unref(selectedTenant).seatLimit)}</p></div><div><label class="form-label">Billing Status</label><p class="text-gray-900">${ssrInterpolate(unref(selectedTenant).billingStatus)}</p></div><div><label class="form-label">Last Payment</label><p class="text-gray-900">${ssrInterpolate(unref(selectedTenant).lastPaymentDate ? formatDate(unref(selectedTenant).lastPaymentDate) : "N/A")}</p></div><div><label class="form-label">Next Payment</label><p class="text-gray-900">${ssrInterpolate(unref(selectedTenant).nextPaymentDate ? formatDate(unref(selectedTenant).nextPaymentDate) : "N/A")}</p></div></div><div class="mt-6"><button class="btn btn-warning"> Send Billing Reminder </button></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/owner/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=index-8JcnzE_t.mjs.map
