import { defineComponent, ref, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrIncludeBooleanAttr, ssrLooseContain, ssrLooseEqual, ssrRenderList, ssrRenderClass, ssrRenderAttr } from 'vue/server-renderer';
import { _ as _export_sfc } from './server.mjs';
import '../nitro/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';
import 'vue-router';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "marketing",
  __ssrInlineRender: true,
  setup(__props) {
    const activeTab = ref("google-business");
    ref(false);
    const googleBusinessFilter = ref("");
    const instagramFilter = ref("");
    const facebookFilter = ref("");
    const tiktokFilter = ref("");
    const suggestionStatusFilter = ref("");
    const suggestionPriorityFilter = ref("");
    const tabs = [
      { id: "google-business", name: "Google My Business" },
      { id: "instagram", name: "Instagram" },
      { id: "facebook", name: "Facebook" },
      { id: "tiktok", name: "TikTok" }
    ];
    const socialMediaMetrics = ref({
      totalViews: "2.4M",
      totalEngagement: "45.2K",
      totalFollowers: "12.8K",
      engagementRate: 3.2
    });
    const marketingSuggestions = ref([
      {
        id: 1,
        title: "Increase Posting Frequency on Instagram",
        description: "Your Instagram engagement rate is 4.2%, but you only post 5 times per week. Increase to 7-10 posts per week to boost visibility and engagement.",
        priority: "high",
        impact: "High",
        effort: "Medium",
        completed: false,
        iconPath: "M12 6v6m0 0v6m0-6h6m-6 0H6"
      },
      {
        id: 2,
        title: "Optimize Google My Business Profile",
        description: "Your Google My Business profile views are good (1,245), but you can improve by adding more photos, updating business hours, and responding to all reviews within 24 hours.",
        priority: "medium",
        impact: "High",
        effort: "Low",
        completed: false,
        iconPath: "M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
      },
      {
        id: 3,
        title: "Create TikTok Content Strategy",
        description: "TikTok shows excellent growth (35% follower increase), but you need a consistent content calendar. Focus on trending hashtags and user-generated content.",
        priority: "high",
        impact: "High",
        effort: "High",
        completed: false,
        iconPath: "M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"
      },
      {
        id: 4,
        title: "Improve Facebook Video Content",
        description: "Facebook video views are strong (12.4K with 28% growth), but you can increase engagement by adding captions and creating shorter, more engaging videos.",
        priority: "medium",
        impact: "Medium",
        effort: "Medium",
        completed: false,
        iconPath: "M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"
      },
      {
        id: 5,
        title: "Respond to All Reviews Promptly",
        description: "You have 127 total reviews but only respond to 60% of them. Responding to all reviews within 24 hours can improve your local SEO and customer satisfaction.",
        priority: "high",
        impact: "High",
        effort: "Low",
        completed: false,
        iconPath: "M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"
      },
      {
        id: 6,
        title: "Create User-Generated Content Campaign",
        description: "Leverage your 12.8K followers by creating a hashtag campaign. This can increase engagement by 40% and provide authentic content for your social media.",
        priority: "medium",
        impact: "Medium",
        effort: "High",
        completed: false,
        iconPath: "M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"
      },
      {
        id: 7,
        title: "Optimize Posting Times",
        description: "Your peak activity times are 2-4 PM on weekdays. Test posting during 7-9 AM and 6-8 PM to reach different audience segments and increase engagement.",
        priority: "low",
        impact: "Medium",
        effort: "Low",
        completed: false,
        iconPath: "M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"
      },
      {
        id: 8,
        title: "Implement Instagram Stories Strategy",
        description: "Add daily Instagram Stories to your content mix. Stories have a 15-25% higher engagement rate than regular posts and can drive more traffic to your profile.",
        priority: "medium",
        impact: "Medium",
        effort: "Medium",
        completed: false,
        iconPath: "M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"
      }
    ]);
    const googleBusinessMetrics = ref({
      views: "1,245",
      searches: "2,890",
      directions: "156",
      websiteClicks: "89",
      phoneCalls: "34",
      reviews: "127",
      recentReviews: [
        {
          id: 1,
          customerName: "Sarah Johnson",
          rating: 5,
          comment: "Excellent service! The team was very professional and helpful.",
          date: /* @__PURE__ */ new Date("2024-01-20"),
          suggestion: "",
          editingSuggestion: false
        },
        {
          id: 2,
          customerName: "Mike Chen",
          rating: 4,
          comment: "Good experience overall. Would recommend to others.",
          date: /* @__PURE__ */ new Date("2024-01-18"),
          suggestion: "",
          editingSuggestion: false
        },
        {
          id: 3,
          customerName: "Emily Davis",
          rating: 5,
          comment: "Outstanding quality and customer service. Very satisfied!",
          date: /* @__PURE__ */ new Date("2024-01-15"),
          suggestion: "",
          editingSuggestion: false
        }
      ]
    });
    const instagramMetrics = ref({
      followers: "8,450",
      followerGrowth: 12,
      posts: 156,
      postGrowth: 8,
      engagement: 4.2,
      engagementGrowth: 15,
      reach: "12.3K",
      reachGrowth: 18,
      impressions: "18.7K",
      impressionsGrowth: 22,
      saves: "1,234",
      savesGrowth: 25,
      topPosts: [
        {
          id: 1,
          image: "https://via.placeholder.com/300x300/3b82f6/ffffff?text=Post+1",
          caption: "Behind the scenes of our latest project",
          likes: 234,
          comments: 45,
          saves: 67
        },
        {
          id: 2,
          image: "https://via.placeholder.com/300x300/10b981/ffffff?text=Post+2",
          caption: "Team collaboration in action",
          likes: 189,
          comments: 32,
          saves: 54
        },
        {
          id: 3,
          image: "https://via.placeholder.com/300x300/f59e0b/ffffff?text=Post+3",
          caption: "Celebrating our achievements",
          likes: 312,
          comments: 67,
          saves: 89
        }
      ]
    });
    const facebookMetrics = ref({
      pageLikes: "3,240",
      likesGrowth: 8,
      reach: "5.6K",
      reachGrowth: 14,
      engagement: "2.1K",
      engagementGrowth: 12,
      posts: 89,
      postsGrowth: 6,
      videoViews: "12.4K",
      videoViewsGrowth: 28,
      clicks: "456",
      clicksGrowth: 16,
      peakTimes: [
        { day: "Monday", time: "2:00 PM - 4:00 PM" },
        { day: "Wednesday", time: "1:00 PM - 3:00 PM" },
        { day: "Friday", time: "3:00 PM - 5:00 PM" }
      ],
      demographics: [
        { group: "25-34 years", percentage: 35 },
        { group: "35-44 years", percentage: 28 },
        { group: "18-24 years", percentage: 22 },
        { group: "45-54 years", percentage: 15 }
      ]
    });
    const tiktokMetrics = ref({
      followers: "15.6K",
      followerGrowth: 35,
      videos: 89,
      videoGrowth: 12,
      views: "2.1M",
      viewsGrowth: 45,
      likes: "156K",
      likesGrowth: 38,
      comments: "8.9K",
      commentsGrowth: 42,
      shares: "12.3K",
      sharesGrowth: 28,
      trendingVideos: [
        {
          id: 1,
          thumbnail: "https://via.placeholder.com/200x200/ef4444/ffffff?text=Video+1",
          caption: "Quick tutorial on our latest feature",
          views: "45.2K",
          likes: "3.2K",
          comments: "234",
          shares: "567",
          date: /* @__PURE__ */ new Date("2024-01-22")
        },
        {
          id: 2,
          thumbnail: "https://via.placeholder.com/200x200/8b5cf6/ffffff?text=Video+2",
          caption: "Behind the scenes content",
          views: "38.7K",
          likes: "2.8K",
          comments: "189",
          shares: "445",
          date: /* @__PURE__ */ new Date("2024-01-20")
        },
        {
          id: 3,
          thumbnail: "https://via.placeholder.com/200x200/06b6d4/ffffff?text=Video+3",
          caption: "Customer success story",
          views: "52.1K",
          likes: "4.1K",
          comments: "312",
          shares: "678",
          date: /* @__PURE__ */ new Date("2024-01-18")
        }
      ]
    });
    const formatDate = (date) => {
      return date.toLocaleDateString("en-US", {
        year: "numeric",
        month: "short",
        day: "numeric"
      });
    };
    const generateSuggestion = (review) => {
      const suggestions = {
        5: `Thank you so much for your wonderful review, ${review.customerName}! We're thrilled to hear about your positive experience. Your feedback means the world to us and motivates our team to continue delivering excellent service. We look forward to serving you again soon!`,
        4: `Thank you for your great review, ${review.customerName}! We're pleased to hear about your positive experience. We're always working to improve our services, and your feedback helps us do that. We hope to exceed your expectations on your next visit!`,
        3: `Thank you for taking the time to share your feedback, ${review.customerName}. We appreciate your honest review and take all feedback seriously. We'd love to discuss your experience further and see how we can improve. Please feel free to contact us directly.`,
        2: `Thank you for your feedback, ${review.customerName}. We're sorry to hear that your experience didn't meet your expectations. We take all reviews seriously and would appreciate the opportunity to make things right. Please contact us directly so we can address your concerns.`,
        1: `We sincerely apologize for your disappointing experience, ${review.customerName}. Your feedback is important to us, and we'd like to make this right. Please contact us directly so we can discuss your concerns and work towards a resolution.`
      };
      return suggestions[review.rating] || suggestions[3];
    };
    const filteredMarketingSuggestions = computed(() => {
      return marketingSuggestions.value.filter((suggestion) => {
        const statusMatch = !suggestionStatusFilter.value || suggestionStatusFilter.value === "pending" && !suggestion.completed || suggestionStatusFilter.value === "completed" && suggestion.completed;
        const priorityMatch = !suggestionPriorityFilter.value || suggestion.priority === suggestionPriorityFilter.value;
        return statusMatch && priorityMatch;
      });
    });
    const getSuggestionStatusBadgeClass = (completed) => {
      return completed ? "badge-success" : "badge-warning";
    };
    const getPriorityBadgeClass = (priority) => {
      switch (priority) {
        case "high":
          return "badge-danger";
        case "medium":
          return "badge-warning";
        case "low":
          return "badge-info";
        default:
          return "badge-secondary";
      }
    };
    const getImpactTextClass = (impact) => {
      switch (impact.toLowerCase()) {
        case "high":
          return "text-green-600";
        case "medium":
          return "text-yellow-600";
        case "low":
          return "text-gray-600";
        default:
          return "text-gray-600";
      }
    };
    const getEffortTextClass = (effort) => {
      switch (effort.toLowerCase()) {
        case "high":
          return "text-red-600";
        case "medium":
          return "text-orange-600";
        case "low":
          return "text-green-600";
        default:
          return "text-gray-600";
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "marketing-module" }, _attrs))} data-v-bf247d17><div class="content-body" data-v-bf247d17><div class="kpi-grid mb-8" data-v-bf247d17><div class="kpi-card modern-card" data-v-bf247d17><div class="kpi-icon-wrapper views-icon" data-v-bf247d17><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" data-v-bf247d17></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" data-v-bf247d17></path></svg></div><div class="kpi-content" data-v-bf247d17><div class="kpi-value" data-v-bf247d17>${ssrInterpolate(unref(socialMediaMetrics).totalViews.toLocaleString())}</div><div class="kpi-label" data-v-bf247d17>Total Views</div><div class="kpi-change positive" data-v-bf247d17><svg class="change-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 17l9.2-9.2M17 17V7H7" data-v-bf247d17></path></svg> +12% this month </div></div></div><div class="kpi-card modern-card" data-v-bf247d17><div class="kpi-icon-wrapper engagement-icon" data-v-bf247d17><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" data-v-bf247d17></path></svg></div><div class="kpi-content" data-v-bf247d17><div class="kpi-value" data-v-bf247d17>${ssrInterpolate(unref(socialMediaMetrics).totalEngagement.toLocaleString())}</div><div class="kpi-label" data-v-bf247d17>Total Engagement</div><div class="kpi-change positive" data-v-bf247d17><svg class="change-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 17l9.2-9.2M17 17V7H7" data-v-bf247d17></path></svg> +8% this week </div></div></div><div class="kpi-card modern-card" data-v-bf247d17><div class="kpi-icon-wrapper followers-icon" data-v-bf247d17><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" data-v-bf247d17></path></svg></div><div class="kpi-content" data-v-bf247d17><div class="kpi-value" data-v-bf247d17>${ssrInterpolate(unref(socialMediaMetrics).totalFollowers.toLocaleString())}</div><div class="kpi-label" data-v-bf247d17>Total Followers</div><div class="kpi-change positive" data-v-bf247d17><svg class="change-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 17l9.2-9.2M17 17V7H7" data-v-bf247d17></path></svg> +5% this month </div></div></div><div class="kpi-card modern-card" data-v-bf247d17><div class="kpi-icon-wrapper rate-icon" data-v-bf247d17><svg class="kpi-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" data-v-bf247d17></path></svg></div><div class="kpi-content" data-v-bf247d17><div class="kpi-value" data-v-bf247d17>${ssrInterpolate(unref(socialMediaMetrics).engagementRate)}% </div><div class="kpi-label" data-v-bf247d17>Engagement Rate</div><div class="kpi-change positive" data-v-bf247d17><svg class="change-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 17l9.2-9.2M17 17V7H7" data-v-bf247d17></path></svg> +3% this month </div></div></div></div><div class="suggestions-section mb-8" data-v-bf247d17><div class="flex flex-col gap-2 mb-2" data-v-bf247d17><div data-v-bf247d17><div class="ai-badge" data-v-bf247d17><span class="ai-icon" data-v-bf247d17>\u{1F916}</span><span class="ai-text" data-v-bf247d17>AI Insights</span></div></div><div class="flex items-center justify-between gap-4" data-v-bf247d17><h3 class="text-lg font-semibold" data-v-bf247d17>Marketing Suggestions</h3><div class="flex gap-2 items-center" data-v-bf247d17><select class="form-select" data-v-bf247d17><option value="" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(suggestionStatusFilter)) ? ssrLooseContain(unref(suggestionStatusFilter), "") : ssrLooseEqual(unref(suggestionStatusFilter), "")) ? " selected" : ""}>All Status</option><option value="pending" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(suggestionStatusFilter)) ? ssrLooseContain(unref(suggestionStatusFilter), "pending") : ssrLooseEqual(unref(suggestionStatusFilter), "pending")) ? " selected" : ""}>Pending</option><option value="completed" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(suggestionStatusFilter)) ? ssrLooseContain(unref(suggestionStatusFilter), "completed") : ssrLooseEqual(unref(suggestionStatusFilter), "completed")) ? " selected" : ""}>Completed</option></select><select class="form-select" data-v-bf247d17><option value="" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(suggestionPriorityFilter)) ? ssrLooseContain(unref(suggestionPriorityFilter), "") : ssrLooseEqual(unref(suggestionPriorityFilter), "")) ? " selected" : ""}>All Priority</option><option value="low" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(suggestionPriorityFilter)) ? ssrLooseContain(unref(suggestionPriorityFilter), "low") : ssrLooseEqual(unref(suggestionPriorityFilter), "low")) ? " selected" : ""}>Low</option><option value="medium" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(suggestionPriorityFilter)) ? ssrLooseContain(unref(suggestionPriorityFilter), "medium") : ssrLooseEqual(unref(suggestionPriorityFilter), "medium")) ? " selected" : ""}>Medium</option><option value="high" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(suggestionPriorityFilter)) ? ssrLooseContain(unref(suggestionPriorityFilter), "high") : ssrLooseEqual(unref(suggestionPriorityFilter), "high")) ? " selected" : ""}>High</option></select></div></div></div><div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 lg:gap-6" data-v-bf247d17><!--[-->`);
      ssrRenderList(unref(filteredMarketingSuggestions), (suggestion) => {
        _push(`<div class="card" data-v-bf247d17><div class="card-body" data-v-bf247d17><div class="flex flex-col sm:flex-row sm:items-start sm:justify-between gap-2 mb-4" data-v-bf247d17><div class="flex flex-wrap items-center gap-2" data-v-bf247d17><span class="badge badge-ai" data-v-bf247d17>AI Suggestion</span><span class="${ssrRenderClass([getSuggestionStatusBadgeClass(suggestion.completed), "badge"])}" data-v-bf247d17>${ssrInterpolate(suggestion.completed ? "Completed" : "Pending")}</span><span class="${ssrRenderClass([getPriorityBadgeClass(suggestion.priority), "badge"])}" data-v-bf247d17>${ssrInterpolate(suggestion.priority)}</span></div></div><h4 class="${ssrRenderClass([{ "line-through text-gray-500": suggestion.completed }, "font-semibold text-lg mb-2"])}" data-v-bf247d17>${ssrInterpolate(suggestion.title)}</h4><p class="${ssrRenderClass([{ "line-through text-gray-400": suggestion.completed }, "text-gray-600 text-sm mb-4"])}" data-v-bf247d17>${ssrInterpolate(suggestion.description)}</p><div class="mb-4" data-v-bf247d17><div class="flex items-center justify-between text-sm text-gray-600 mb-2" data-v-bf247d17><span data-v-bf247d17>Impact</span><span class="${ssrRenderClass([getImpactTextClass(suggestion.impact), "font-semibold"])}" data-v-bf247d17>${ssrInterpolate(suggestion.impact)}</span></div><div class="flex items-center justify-between text-sm text-gray-600 mb-2" data-v-bf247d17><span data-v-bf247d17>Effort</span><span class="${ssrRenderClass([getEffortTextClass(suggestion.effort), "font-semibold"])}" data-v-bf247d17>${ssrInterpolate(suggestion.effort)}</span></div></div><div class="flex items-center justify-between text-sm text-gray-500 mb-4" data-v-bf247d17><span data-v-bf247d17>${ssrInterpolate(suggestion.impact)} Impact</span><span data-v-bf247d17>${ssrInterpolate(suggestion.effort)} Effort</span></div><div class="flex flex-wrap items-center gap-1" data-v-bf247d17><button class="btn btn-primary" title="View Details" data-v-bf247d17><svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" data-v-bf247d17></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" data-v-bf247d17></path></svg> View </button><button class="btn btn-secondary" title="Edit Suggestion" data-v-bf247d17><svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" data-v-bf247d17></path></svg> Edit </button><button class="${ssrRenderClass([suggestion.completed ? "btn-warning" : "btn-success", "btn"])}"${ssrRenderAttr(
          "title",
          suggestion.completed ? "Mark as incomplete" : "Mark as complete"
        )} data-v-bf247d17>`);
        if (!suggestion.completed) {
          _push(`<svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" data-v-bf247d17></path></svg>`);
        } else {
          _push(`<svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10M3 14h10m-7-4v8m7-8v8" data-v-bf247d17></path></svg>`);
        }
        _push(` ${ssrInterpolate(suggestion.completed ? "Undo" : "Complete")}</button></div></div></div>`);
      });
      _push(`<!--]--></div></div><div class="tabs-container card mb-8" data-v-bf247d17><div class="tabs-header" data-v-bf247d17><!--[-->`);
      ssrRenderList(tabs, (tab) => {
        _push(`<button class="${ssrRenderClass([{ active: unref(activeTab) === tab.id }, "tab-button"])}" data-v-bf247d17>${ssrInterpolate(tab.name)}</button>`);
      });
      _push(`<!--]--></div><div class="tabs-content" data-v-bf247d17>`);
      if (unref(activeTab) === "google-business") {
        _push(`<div class="tab-pane" data-v-bf247d17><div class="flex items-center justify-between mb-4" data-v-bf247d17><h3 class="text-lg font-semibold" data-v-bf247d17> Google My Business Analytics </h3><div class="flex gap-2" data-v-bf247d17><select class="form-select" data-v-bf247d17><option value="" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(googleBusinessFilter)) ? ssrLooseContain(unref(googleBusinessFilter), "") : ssrLooseEqual(unref(googleBusinessFilter), "")) ? " selected" : ""}>All Time</option><option value="7d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(googleBusinessFilter)) ? ssrLooseContain(unref(googleBusinessFilter), "7d") : ssrLooseEqual(unref(googleBusinessFilter), "7d")) ? " selected" : ""}>Last 7 days</option><option value="30d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(googleBusinessFilter)) ? ssrLooseContain(unref(googleBusinessFilter), "30d") : ssrLooseEqual(unref(googleBusinessFilter), "30d")) ? " selected" : ""}>Last 30 days</option><option value="90d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(googleBusinessFilter)) ? ssrLooseContain(unref(googleBusinessFilter), "90d") : ssrLooseEqual(unref(googleBusinessFilter), "90d")) ? " selected" : ""}>Last 90 days</option></select><button class="btn btn-outline btn-sm" title="Refresh" data-v-bf247d17><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" data-v-bf247d17></path></svg></button></div></div><div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-6" data-v-bf247d17><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(googleBusinessMetrics).views)}</div><div class="metric-label" data-v-bf247d17>Profile Views</div><div class="metric-change positive" data-v-bf247d17>+15% this month</div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(googleBusinessMetrics).searches)}</div><div class="metric-label" data-v-bf247d17>Search Appearances</div><div class="metric-change positive" data-v-bf247d17>+22% this month</div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(googleBusinessMetrics).directions)}</div><div class="metric-label" data-v-bf247d17>Direction Requests</div><div class="metric-change positive" data-v-bf247d17>+8% this month</div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(googleBusinessMetrics).websiteClicks)}</div><div class="metric-label" data-v-bf247d17>Website Clicks</div><div class="metric-change positive" data-v-bf247d17>+12% this month</div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(googleBusinessMetrics).phoneCalls)}</div><div class="metric-label" data-v-bf247d17>Phone Calls</div><div class="metric-change positive" data-v-bf247d17>+5% this month</div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(googleBusinessMetrics).reviews)}</div><div class="metric-label" data-v-bf247d17>Total Reviews</div><div class="metric-change positive" data-v-bf247d17>+3 this month</div></div></div><div class="card" data-v-bf247d17><div class="card-header" data-v-bf247d17><h4 class="card-title" data-v-bf247d17>Recent Reviews</h4></div><div class="card-body" data-v-bf247d17><ul class="reviews-list" data-v-bf247d17><!--[-->`);
        ssrRenderList(unref(googleBusinessMetrics).recentReviews, (review) => {
          _push(`<li class="review-item mb-4 p-3 bg-white rounded-md border border-gray-100" data-v-bf247d17><div class="flex items-start gap-3" data-v-bf247d17><div class="flex-1" data-v-bf247d17><div class="flex items-start justify-between" data-v-bf247d17><div data-v-bf247d17><div class="customer-name font-semibold text-gray-900" data-v-bf247d17>${ssrInterpolate(review.customerName)}</div><div class="rating-cell text-sm text-gray-600" data-v-bf247d17><!--[-->`);
          ssrRenderList(5, (i) => {
            _push(`<span class="${ssrRenderClass([{ filled: i <= review.rating }, "star"])}" data-v-bf247d17>\u2605</span>`);
          });
          _push(`<!--]--><span class="rating-text text-xs ml-2" data-v-bf247d17>${ssrInterpolate(review.rating)}/5</span></div></div><div class="review-date text-xs text-gray-500" data-v-bf247d17>${ssrInterpolate(formatDate(review.date))}</div></div><p class="review-comment mt-2 text-gray-700" data-v-bf247d17>${ssrInterpolate(review.comment)}</p><div class="mt-3" data-v-bf247d17>`);
          if (!review.editingSuggestion) {
            _push(`<div class="suggestion-card small p-2 bg-blue-50 border border-blue-100 rounded" data-v-bf247d17><div class="suggestion-header flex items-center gap-2 mb-1" data-v-bf247d17><div class="ai-icon text-xs" data-v-bf247d17>\u2605</div><span class="ai-label text-xs font-semibold text-blue-700" data-v-bf247d17>AI Suggestion</span></div><div class="suggestion-content" data-v-bf247d17><p class="suggestion-text text-sm text-gray-700" data-v-bf247d17>${ssrInterpolate(review.suggestion || generateSuggestion(review))}</p></div></div>`);
          } else {
            _push(`<div class="suggestion-edit-card p-2 bg-amber-50 border border-amber-200 rounded" data-v-bf247d17><div class="edit-header mb-1" data-v-bf247d17><span class="edit-label text-xs font-semibold text-amber-700" data-v-bf247d17>Edit Suggestion</span></div><textarea class="suggestion-textarea w-full p-2 border rounded text-sm" rows="3" placeholder="Enter your response suggestion..." data-v-bf247d17>${ssrInterpolate(review.suggestion)}</textarea><div class="edit-actions flex gap-2 mt-2" data-v-bf247d17><button class="btn-save flex items-center gap-1 px-3 py-1.5 bg-green-600 text-white text-xs rounded" data-v-bf247d17> Save </button><button class="btn-cancel flex items-center gap-1 px-3 py-1.5 bg-gray-500 text-white text-xs rounded" data-v-bf247d17> Cancel </button></div></div>`);
          }
          _push(`</div><div class="actions mt-3" data-v-bf247d17><div class="flex gap-2" data-v-bf247d17><button class="review-action-btn" title="Edit Suggestion" data-v-bf247d17><svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" data-v-bf247d17></path></svg></button><button class="review-action-btn" title="Post Response" data-v-bf247d17><svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" data-v-bf247d17></path></svg></button></div></div></div></div></li>`);
        });
        _push(`<!--]--></ul></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "instagram") {
        _push(`<div class="tab-pane" data-v-bf247d17><div class="flex items-center justify-between mb-4" data-v-bf247d17><h3 class="text-lg font-semibold" data-v-bf247d17>Instagram Analytics</h3><div class="flex gap-2" data-v-bf247d17><select class="form-select" data-v-bf247d17><option value="" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(instagramFilter)) ? ssrLooseContain(unref(instagramFilter), "") : ssrLooseEqual(unref(instagramFilter), "")) ? " selected" : ""}>All Time</option><option value="7d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(instagramFilter)) ? ssrLooseContain(unref(instagramFilter), "7d") : ssrLooseEqual(unref(instagramFilter), "7d")) ? " selected" : ""}>Last 7 days</option><option value="30d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(instagramFilter)) ? ssrLooseContain(unref(instagramFilter), "30d") : ssrLooseEqual(unref(instagramFilter), "30d")) ? " selected" : ""}>Last 30 days</option><option value="90d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(instagramFilter)) ? ssrLooseContain(unref(instagramFilter), "90d") : ssrLooseEqual(unref(instagramFilter), "90d")) ? " selected" : ""}>Last 90 days</option></select><button class="btn btn-outline btn-sm" title="Refresh" data-v-bf247d17><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" data-v-bf247d17></path></svg></button></div></div><div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-6" data-v-bf247d17><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(instagramMetrics).followers)}</div><div class="metric-label" data-v-bf247d17>Followers</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(instagramMetrics).followerGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(instagramMetrics).posts)}</div><div class="metric-label" data-v-bf247d17>Total Posts</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(instagramMetrics).postGrowth)} this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(instagramMetrics).engagement)}</div><div class="metric-label" data-v-bf247d17>Engagement Rate</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(instagramMetrics).engagementGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(instagramMetrics).reach)}</div><div class="metric-label" data-v-bf247d17>Reach</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(instagramMetrics).reachGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(instagramMetrics).impressions)}</div><div class="metric-label" data-v-bf247d17>Impressions</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(instagramMetrics).impressionsGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(instagramMetrics).saves)}</div><div class="metric-label" data-v-bf247d17>Saves</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(instagramMetrics).savesGrowth)}% this month </div></div></div><div class="card" data-v-bf247d17><div class="card-header" data-v-bf247d17><h4 class="card-title" data-v-bf247d17>Top Performing Posts</h4></div><div class="card-body" data-v-bf247d17><div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4" data-v-bf247d17><!--[-->`);
        ssrRenderList(unref(instagramMetrics).topPosts, (post) => {
          _push(`<div class="post-card" data-v-bf247d17><div class="post-image" data-v-bf247d17><img${ssrRenderAttr("src", post.image)}${ssrRenderAttr("alt", post.caption)} class="w-full h-48 object-cover rounded-lg" data-v-bf247d17></div><div class="post-stats" data-v-bf247d17><div class="flex justify-between text-sm" data-v-bf247d17><span data-v-bf247d17>\u2764\uFE0F ${ssrInterpolate(post.likes)}</span><span data-v-bf247d17>\u{1F4AC} ${ssrInterpolate(post.comments)}</span><span data-v-bf247d17>\u{1F4BE} ${ssrInterpolate(post.saves)}</span></div></div></div>`);
        });
        _push(`<!--]--></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "facebook") {
        _push(`<div class="tab-pane" data-v-bf247d17><div class="flex items-center justify-between mb-4" data-v-bf247d17><h3 class="text-lg font-semibold" data-v-bf247d17>Facebook Analytics</h3><div class="flex gap-2" data-v-bf247d17><select class="form-select" data-v-bf247d17><option value="" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(facebookFilter)) ? ssrLooseContain(unref(facebookFilter), "") : ssrLooseEqual(unref(facebookFilter), "")) ? " selected" : ""}>All Time</option><option value="7d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(facebookFilter)) ? ssrLooseContain(unref(facebookFilter), "7d") : ssrLooseEqual(unref(facebookFilter), "7d")) ? " selected" : ""}>Last 7 days</option><option value="30d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(facebookFilter)) ? ssrLooseContain(unref(facebookFilter), "30d") : ssrLooseEqual(unref(facebookFilter), "30d")) ? " selected" : ""}>Last 30 days</option><option value="90d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(facebookFilter)) ? ssrLooseContain(unref(facebookFilter), "90d") : ssrLooseEqual(unref(facebookFilter), "90d")) ? " selected" : ""}>Last 90 days</option></select><button class="btn btn-outline btn-sm" title="Refresh" data-v-bf247d17><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" data-v-bf247d17></path></svg></button></div></div><div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-6" data-v-bf247d17><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(facebookMetrics).pageLikes)}</div><div class="metric-label" data-v-bf247d17>Page Likes</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(facebookMetrics).likesGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(facebookMetrics).reach)}</div><div class="metric-label" data-v-bf247d17>Reach</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(facebookMetrics).reachGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(facebookMetrics).engagement)}</div><div class="metric-label" data-v-bf247d17>Engagement</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(facebookMetrics).engagementGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(facebookMetrics).posts)}</div><div class="metric-label" data-v-bf247d17>Posts</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(facebookMetrics).postsGrowth)} this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(facebookMetrics).videoViews)}</div><div class="metric-label" data-v-bf247d17>Video Views</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(facebookMetrics).videoViewsGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(facebookMetrics).clicks)}</div><div class="metric-label" data-v-bf247d17>Link Clicks</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(facebookMetrics).clicksGrowth)}% this month </div></div></div><div class="card" data-v-bf247d17><div class="card-header" data-v-bf247d17><h4 class="card-title" data-v-bf247d17>Page Insights</h4></div><div class="card-body" data-v-bf247d17><div class="grid grid-cols-1 md:grid-cols-2 gap-6" data-v-bf247d17><div class="insight-item" data-v-bf247d17><h5 class="font-medium mb-2" data-v-bf247d17>Peak Activity Times</h5><div class="space-y-2" data-v-bf247d17><!--[-->`);
        ssrRenderList(unref(facebookMetrics).peakTimes, (time) => {
          _push(`<div class="flex justify-between" data-v-bf247d17><span data-v-bf247d17>${ssrInterpolate(time.day)}</span><span class="text-gray-600" data-v-bf247d17>${ssrInterpolate(time.time)}</span></div>`);
        });
        _push(`<!--]--></div></div><div class="insight-item" data-v-bf247d17><h5 class="font-medium mb-2" data-v-bf247d17>Top Demographics</h5><div class="space-y-2" data-v-bf247d17><!--[-->`);
        ssrRenderList(unref(facebookMetrics).demographics, (demo) => {
          _push(`<div class="flex justify-between" data-v-bf247d17><span data-v-bf247d17>${ssrInterpolate(demo.group)}</span><span class="text-gray-600" data-v-bf247d17>${ssrInterpolate(demo.percentage)}%</span></div>`);
        });
        _push(`<!--]--></div></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "tiktok") {
        _push(`<div class="tab-pane" data-v-bf247d17><div class="flex items-center justify-between mb-4" data-v-bf247d17><h3 class="text-lg font-semibold" data-v-bf247d17>TikTok Analytics</h3><div class="flex gap-2" data-v-bf247d17><select class="form-select" data-v-bf247d17><option value="" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(tiktokFilter)) ? ssrLooseContain(unref(tiktokFilter), "") : ssrLooseEqual(unref(tiktokFilter), "")) ? " selected" : ""}>All Time</option><option value="7d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(tiktokFilter)) ? ssrLooseContain(unref(tiktokFilter), "7d") : ssrLooseEqual(unref(tiktokFilter), "7d")) ? " selected" : ""}>Last 7 days</option><option value="30d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(tiktokFilter)) ? ssrLooseContain(unref(tiktokFilter), "30d") : ssrLooseEqual(unref(tiktokFilter), "30d")) ? " selected" : ""}>Last 30 days</option><option value="90d" data-v-bf247d17${ssrIncludeBooleanAttr(Array.isArray(unref(tiktokFilter)) ? ssrLooseContain(unref(tiktokFilter), "90d") : ssrLooseEqual(unref(tiktokFilter), "90d")) ? " selected" : ""}>Last 90 days</option></select><button class="btn btn-outline btn-sm" title="Refresh" data-v-bf247d17><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-bf247d17><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" data-v-bf247d17></path></svg></button></div></div><div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-6" data-v-bf247d17><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(tiktokMetrics).followers)}</div><div class="metric-label" data-v-bf247d17>Followers</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(tiktokMetrics).followerGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(tiktokMetrics).videos)}</div><div class="metric-label" data-v-bf247d17>Total Videos</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(tiktokMetrics).videoGrowth)} this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(tiktokMetrics).views)}</div><div class="metric-label" data-v-bf247d17>Total Views</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(tiktokMetrics).viewsGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(tiktokMetrics).likes)}</div><div class="metric-label" data-v-bf247d17>Total Likes</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(tiktokMetrics).likesGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(tiktokMetrics).comments)}</div><div class="metric-label" data-v-bf247d17>Total Comments</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(tiktokMetrics).commentsGrowth)}% this month </div></div><div class="metric-card" data-v-bf247d17><div class="metric-value" data-v-bf247d17>${ssrInterpolate(unref(tiktokMetrics).shares)}</div><div class="metric-label" data-v-bf247d17>Total Shares</div><div class="metric-change positive" data-v-bf247d17> +${ssrInterpolate(unref(tiktokMetrics).sharesGrowth)}% this month </div></div></div><div class="card" data-v-bf247d17><div class="card-header" data-v-bf247d17><h4 class="card-title" data-v-bf247d17>Trending Videos</h4></div><div class="card-body" data-v-bf247d17><div class="space-y-4" data-v-bf247d17><!--[-->`);
        ssrRenderList(unref(tiktokMetrics).trendingVideos, (video) => {
          _push(`<div class="video-item" data-v-bf247d17><div class="flex gap-4" data-v-bf247d17><div class="video-thumbnail" data-v-bf247d17><img${ssrRenderAttr("src", video.thumbnail)}${ssrRenderAttr("alt", video.caption)} class="w-20 h-20 object-cover rounded-lg" data-v-bf247d17></div><div class="flex-1" data-v-bf247d17><h5 class="font-medium mb-1" data-v-bf247d17>${ssrInterpolate(video.caption.substring(0, 50))}... </h5><div class="flex gap-4 text-sm text-gray-600" data-v-bf247d17><span data-v-bf247d17>\u{1F440} ${ssrInterpolate(video.views)}</span><span data-v-bf247d17>\u2764\uFE0F ${ssrInterpolate(video.likes)}</span><span data-v-bf247d17>\u{1F4AC} ${ssrInterpolate(video.comments)}</span><span data-v-bf247d17>\u{1F4E4} ${ssrInterpolate(video.shares)}</span></div><span class="text-xs text-gray-500" data-v-bf247d17>${ssrInterpolate(formatDate(video.date))}</span></div></div></div>`);
        });
        _push(`<!--]--></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/c/[slug]/marketing.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const marketing = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-bf247d17"]]);

export { marketing as default };
//# sourceMappingURL=marketing-Dwtjnm7V.mjs.map
