import { defineComponent, ref, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderClass, ssrRenderList, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain, ssrLooseEqual, ssrRenderStyle } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "onboarding",
  __ssrInlineRender: true,
  setup(__props) {
    const showCreateTutorialModal = ref(false);
    const showUploadModal = ref(false);
    const activeTab = ref("tutorials");
    const uploadingFiles = ref([]);
    const tutorials = ref([
      {
        id: "1",
        title: "Company Onboarding Process",
        description: "Complete guide for new employee onboarding",
        content: "Welcome to our company! This tutorial will guide you through the onboarding process...",
        author: "HR Team",
        createdAt: /* @__PURE__ */ new Date("2024-01-15"),
        assignedUsers: ["all"],
        completedCount: 12,
        dueDate: /* @__PURE__ */ new Date("2024-02-15")
      },
      {
        id: "2",
        title: "Software Training",
        description: "Learn how to use our internal software systems",
        content: "This tutorial covers all the essential software tools you'll need...",
        author: "IT Department",
        createdAt: /* @__PURE__ */ new Date("2024-01-20"),
        assignedUsers: ["user1", "user2"],
        completedCount: 8,
        dueDate: /* @__PURE__ */ new Date("2024-02-20")
      }
    ]);
    const uploadedFiles = ref([
      {
        id: "1",
        name: "Company Introduction Video.mp4",
        type: "video",
        size: 15728640,
        // 15MB
        uploadedAt: /* @__PURE__ */ new Date("2024-01-15"),
        url: "/uploads/company-intro.mp4"
      },
      {
        id: "2",
        name: "Employee Handbook.pdf",
        type: "pdf",
        size: 2097152,
        // 2MB
        uploadedAt: /* @__PURE__ */ new Date("2024-01-16"),
        url: "/uploads/handbook.pdf"
      }
    ]);
    const assignments = ref([
      {
        id: "1",
        tutorial: tutorials.value[0],
        assignedTo: "all",
        userName: "All Users",
        status: "pending",
        dueDate: /* @__PURE__ */ new Date("2024-02-15"),
        completedAt: null
      },
      {
        id: "2",
        tutorial: tutorials.value[1],
        assignedTo: "user1",
        userName: "John Doe",
        status: "completed",
        dueDate: /* @__PURE__ */ new Date("2024-02-20"),
        completedAt: /* @__PURE__ */ new Date("2024-01-25")
      }
    ]);
    const availableUsers = ref([
      { id: "user1", name: "John Doe", email: "john@example.com" },
      { id: "user2", name: "Jane Smith", email: "jane@example.com" },
      { id: "user3", name: "Mike Johnson", email: "mike@example.com" }
    ]);
    const newTutorial = ref({
      title: "",
      description: "",
      content: "",
      assignedTo: "all",
      dueDate: ""
    });
    const assignedUsers = computed(() => {
      const users = /* @__PURE__ */ new Set();
      assignments.value.forEach((assignment) => {
        if (assignment.assignedTo === "all") {
          availableUsers.value.forEach((user) => users.add(user.id));
        } else {
          users.add(assignment.assignedTo);
        }
      });
      return Array.from(users);
    });
    const completedTutorials = computed(() => {
      return assignments.value.filter((a) => a.status === "completed").length;
    });
    const formatDate = (date) => {
      return date.toLocaleDateString("en-US", {
        year: "numeric",
        month: "short",
        day: "numeric"
      });
    };
    const formatFileSize = (bytes) => {
      if (bytes === 0) return "0 Bytes";
      const k = 1024;
      const sizes = ["Bytes", "KB", "MB", "GB"];
      const i = Math.floor(Math.log(bytes) / Math.log(k));
      return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + " " + sizes[i];
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "onboarding-module" }, _attrs))}><div class="module-actions mb-6"><div class="flex items-center justify-between"><div class="flex items-center gap-2"><button class="btn btn-primary btn-sm"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg> Create Tutorial </button><button class="btn btn-outline btn-sm"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg> Upload Files </button></div></div></div><div class="content-body"><div class="stats-grid mb-8"><div class="stat-card"><div class="stat-icon"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg></div><div class="stat-content"><div class="stat-value">${ssrInterpolate(unref(tutorials).length)}</div><div class="stat-label">Total Tutorials</div></div></div><div class="stat-card"><div class="stat-icon"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg></div><div class="stat-content"><div class="stat-value">${ssrInterpolate(unref(assignedUsers).length)}</div><div class="stat-label">Assigned Users</div></div></div><div class="stat-card"><div class="stat-icon"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg></div><div class="stat-content"><div class="stat-value">${ssrInterpolate(unref(completedTutorials))}</div><div class="stat-label">Completed</div></div></div><div class="stat-card"><div class="stat-icon"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg></div><div class="stat-content"><div class="stat-value">${ssrInterpolate(unref(uploadedFiles).length)}</div><div class="stat-label">Uploaded Files</div></div></div></div><div class="tabs-section"><div class="tabs-header"><div class="tabs-nav"><button class="${ssrRenderClass(["tab-btn", { active: unref(activeTab) === "tutorials" }])}"> Tutorials </button><button class="${ssrRenderClass(["tab-btn", { active: unref(activeTab) === "files" }])}"> Training Files </button><button class="${ssrRenderClass(["tab-btn", { active: unref(activeTab) === "assignments" }])}"> Assignments </button></div></div>`);
      if (unref(activeTab) === "tutorials") {
        _push(`<div class="tab-content"><div class="tutorials-grid"><!--[-->`);
        ssrRenderList(unref(tutorials), (tutorial) => {
          _push(`<div class="tutorial-card"><div class="tutorial-header"><div class="tutorial-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg></div><div class="tutorial-actions"><button class="action-btn edit"><svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg></button><button class="action-btn delete"><svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg></button></div></div><div class="tutorial-content"><h3 class="tutorial-title">${ssrInterpolate(tutorial.title)}</h3><p class="tutorial-description">${ssrInterpolate(tutorial.description)}</p><div class="tutorial-meta"><span class="tutorial-author">By ${ssrInterpolate(tutorial.author)}</span><span class="tutorial-date">${ssrInterpolate(formatDate(tutorial.createdAt))}</span></div><div class="tutorial-stats"><span class="stat-item"><svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg> ${ssrInterpolate(tutorial.assignedUsers.length)} assigned </span><span class="stat-item"><svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg> ${ssrInterpolate(tutorial.completedCount)} completed </span></div></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "files") {
        _push(`<div class="tab-content"><div class="files-grid"><!--[-->`);
        ssrRenderList(unref(uploadedFiles), (file) => {
          _push(`<div class="file-card"><div class="file-icon">`);
          if (file.type === "video") {
            _push(`<svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"></path></svg>`);
          } else {
            _push(`<svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>`);
          }
          _push(`</div><div class="file-content"><h4 class="file-name">${ssrInterpolate(file.name)}</h4><p class="file-size">${ssrInterpolate(formatFileSize(file.size))}</p><p class="file-type">${ssrInterpolate(file.type.toUpperCase())}</p><div class="file-actions"><button class="btn btn-sm btn-outline">Download</button><button class="btn btn-sm btn-danger">Delete</button></div></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "assignments") {
        _push(`<div class="tab-content"><div class="assignments-table"><table class="table"><thead><tr><th>Tutorial</th><th>Assigned To</th><th>Status</th><th>Due Date</th><th>Actions</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(unref(assignments), (assignment) => {
          _push(`<tr><td><div class="assignment-tutorial"><h4 class="tutorial-name">${ssrInterpolate(assignment.tutorial.title)}</h4><p class="tutorial-desc">${ssrInterpolate(assignment.tutorial.description)}</p></div></td><td><div class="assigned-users">`);
          if (assignment.assignedTo === "all") {
            _push(`<span class="badge badge-primary">All Users</span>`);
          } else {
            _push(`<span class="user-name">${ssrInterpolate(assignment.userName)}</span>`);
          }
          _push(`</div></td><td><span class="${ssrRenderClass(["status-badge", assignment.status])}">${ssrInterpolate(assignment.status)}</span></td><td>${ssrInterpolate(formatDate(assignment.dueDate))}</td><td><div class="table-actions"><button class="btn btn-sm btn-outline">View</button><button class="btn btn-sm btn-primary">Edit</button></div></td></tr>`);
        });
        _push(`<!--]--></tbody></table></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (unref(showCreateTutorialModal)) {
        _push(`<div class="modal-overlay"><div class="modal-content"><div class="modal-header"><h3 class="modal-title">Create New Tutorial</h3><button class="modal-close"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><form><div class="form-group"><label class="form-label">Title</label><input${ssrRenderAttr("value", unref(newTutorial).title)} type="text" class="form-input" required></div><div class="form-group"><label class="form-label">Description</label><textarea class="form-textarea" rows="3">${ssrInterpolate(unref(newTutorial).description)}</textarea></div><div class="form-group"><label class="form-label">Content</label><div class="editor-container"><textarea class="tutorial-editor" rows="15" placeholder="Write your tutorial content here...">${ssrInterpolate(unref(newTutorial).content)}</textarea></div></div><div class="form-group"><label class="form-label">Assign To</label><select class="form-select"><option value="all"${ssrIncludeBooleanAttr(Array.isArray(unref(newTutorial).assignedTo) ? ssrLooseContain(unref(newTutorial).assignedTo, "all") : ssrLooseEqual(unref(newTutorial).assignedTo, "all")) ? " selected" : ""}>All Users</option><!--[-->`);
        ssrRenderList(unref(availableUsers), (user) => {
          _push(`<option${ssrRenderAttr("value", user.id)}${ssrIncludeBooleanAttr(Array.isArray(unref(newTutorial).assignedTo) ? ssrLooseContain(unref(newTutorial).assignedTo, user.id) : ssrLooseEqual(unref(newTutorial).assignedTo, user.id)) ? " selected" : ""}>${ssrInterpolate(user.name)}</option>`);
        });
        _push(`<!--]--></select></div><div class="form-group"><label class="form-label">Due Date</label><input${ssrRenderAttr("value", unref(newTutorial).dueDate)} type="date" class="form-input"></div><div class="modal-actions"><button type="button" class="btn btn-outline">Cancel</button><button type="submit" class="btn btn-primary">Save Tutorial</button></div></form></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(showUploadModal)) {
        _push(`<div class="modal-overlay"><div class="modal-content"><div class="modal-header"><h3 class="modal-title">Upload Training Files</h3><button class="modal-close"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><div class="upload-area"><input type="file" multiple accept="video/*,.pdf,.doc,.docx,.ppt,.pptx" class="hidden"><div class="upload-content"><svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg><p class="upload-text">Click to upload or drag and drop</p><p class="upload-subtext">Videos, PDFs, Documents, Presentations</p></div></div>`);
        if (unref(uploadingFiles).length > 0) {
          _push(`<div class="upload-progress"><!--[-->`);
          ssrRenderList(unref(uploadingFiles), (file) => {
            _push(`<div class="upload-item"><div class="upload-info"><span class="upload-name">${ssrInterpolate(file.name)}</span><span class="upload-size">${ssrInterpolate(formatFileSize(file.size))}</span></div><div class="upload-bar"><div class="upload-fill" style="${ssrRenderStyle({ width: file.progress + "%" })}"></div></div></div>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="modal-actions"><button class="btn btn-outline">Close</button></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/c/[slug]/onboarding.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=onboarding-CBBNMO0j.mjs.map
