import { defineComponent, ref, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrIncludeBooleanAttr, ssrRenderAttr, ssrInterpolate } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "profile",
  __ssrInlineRender: true,
  setup(__props) {
    const isSaving = ref(false);
    const isSyncing = ref(false);
    const profileData = ref({
      id: "1",
      name: "Demo Company",
      email: "demo@example.com",
      phone: "+1 555-0123",
      address: "123 Business Street, City, State 12345",
      ustIdNr: "DE123456789",
      instagram: "@democompany",
      tiktok: "@democompany",
      facebook: "facebook.com/democompany",
      salonname: "Demo Salon",
      mitarbeiteranzahl: 15,
      kundennummer: "CUST-001",
      betreuer: "John Manager",
      zahlart: "Bank Transfer",
      kundentyp: "Premium",
      avatar: "",
      isEditable: true
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "profile-module" }, _attrs))}><div class="module-actions mb-6"><div class="flex items-center justify-between"><div class="flex items-center gap-3"><button class="btn btn-outline btn-sm"${ssrIncludeBooleanAttr(unref(isSyncing)) ? " disabled" : ""} title="Sync with CRM"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg>`);
      if (unref(isSyncing)) {
        _push(`<span class="spinner"></span>`);
      } else {
        _push(`<span>Sync CRM</span>`);
      }
      _push(`</button><button class="btn btn-primary btn-sm"${ssrIncludeBooleanAttr(unref(isSaving)) ? " disabled" : ""} title="Save Changes">`);
      if (unref(isSaving)) {
        _push(`<span class="spinner"></span>`);
      } else {
        _push(`<svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>`);
      }
      if (!unref(isSaving)) {
        _push(`<span>Save Changes</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></div></div><div class="content-body"><div class="profile-layout"><div class="profile-photo-section"><div class="profile-card"><div class="profile-header"><div class="profile-avatar-section"><div class="profile-avatar">`);
      if (unref(profileData).avatar) {
        _push(`<img${ssrRenderAttr("src", unref(profileData).avatar)} alt="Profile" class="avatar-image">`);
      } else {
        _push(`<div class="avatar-placeholder"><svg class="avatar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg></div>`);
      }
      _push(`<button class="avatar-edit-btn" title="Change Photo"><svg class="edit-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 9a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 0110.07 4h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0018.07 7H19a2 2 0 012 2v9a2 2 0 01-2 2H5a2 2 0 01-2-2V9z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 13a3 3 0 11-6 0 3 3 0 016 0z"></path></svg></button></div></div><div class="profile-info"><h3 class="profile-name">${ssrInterpolate(unref(profileData).name)}</h3><p class="profile-email">${ssrInterpolate(unref(profileData).email)}</p><div class="profile-badge"><svg class="badge-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg><span>${ssrInterpolate(unref(profileData).kundentyp || "Standard")} Customer</span></div></div></div><div class="profile-stats"><div class="stat-item"><div class="stat-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path></svg></div><div class="stat-content"><span class="stat-label">Customer ID</span><span class="stat-value">${ssrInterpolate(unref(profileData).kundennummer || "N/A")}</span></div></div><div class="stat-item"><div class="stat-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path></svg></div><div class="stat-content"><span class="stat-label">Payment</span><span class="stat-value">${ssrInterpolate(unref(profileData).zahlart || "N/A")}</span></div></div><div class="stat-item"><div class="stat-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg></div><div class="stat-content"><span class="stat-label">Team Size</span><span class="stat-value">${ssrInterpolate(unref(profileData).mitarbeiteranzahl || 0)} members</span></div></div></div></div></div><div class="profile-form-section"><div class="profile-form-card"><div class="form-header"><div class="form-title-section"><h3 class="form-title">Profile Information</h3><p class="form-subtitle">Update your profile information. Fields marked with * are read-only from CRM.</p></div></div><div class="form-body"><form><div class="form-section"><div class="section-header"><div class="section-icon"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg></div><h4 class="section-title">Editable Information</h4></div><div class="form-grid"><div class="form-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg></div><span>Business Address</span></label><textarea class="form-textarea" rows="3" placeholder="Enter your business address">${ssrInterpolate(unref(profileData).address)}</textarea></div><div class="form-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg></div><span>Tax ID (Ust-IdNr)</span></label><input${ssrRenderAttr("value", unref(profileData).ustIdNr)} type="text" class="form-input" placeholder="DE123456789"></div><div class="form-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg></div><span>Phone Number</span></label><input${ssrRenderAttr("value", unref(profileData).phone)} type="tel" class="form-input" placeholder="+1 555-0123"></div><div class="form-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg></div><span>Business Name</span></label><input${ssrRenderAttr("value", unref(profileData).salonname)} type="text" class="form-input" placeholder="Your business name"></div><div class="form-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg></div><span>Team Size</span></label><input${ssrRenderAttr("value", unref(profileData).mitarbeiteranzahl)} type="number" class="form-input" min="0" placeholder="Number of employees"></div></div></div><div class="form-section"><div class="section-header"><div class="section-icon"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 4V2a1 1 0 011-1h8a1 1 0 011 1v2m-9 0h10m-10 0a2 2 0 00-2 2v14a2 2 0 002 2h10a2 2 0 002-2V6a2 2 0 00-2-2M9 8h6m-6 4h6m-6 4h4"></path></svg></div><h4 class="section-title">Social Media</h4></div><div class="form-grid"><div class="form-group"><label class="form-label"><div class="label-icon social-icon instagram"><svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.174-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.741.099.12.112.225.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.402.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.357-.629-2.746-1.378l-.748 2.853c-.271 1.043-1.002 2.35-1.492 3.146C9.57 23.812 10.763 24.009 12.017 24.009c6.624 0 11.99-5.367 11.99-11.988C24.007 5.367 18.641.001.012.001z"></path></svg></div><span>Instagram</span></label><input${ssrRenderAttr("value", unref(profileData).instagram)} type="text" class="form-input" placeholder="@username"></div><div class="form-group"><label class="form-label"><div class="label-icon social-icon tiktok"><svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12.525.02c1.31-.02 2.61-.01 3.91-.02.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.07-5.36.01-4.03-.01-8.05.02-12.07z"></path></svg></div><span>TikTok</span></label><input${ssrRenderAttr("value", unref(profileData).tiktok)} type="text" class="form-input" placeholder="@username"></div><div class="form-group"><label class="form-label"><div class="label-icon social-icon facebook"><svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"></path></svg></div><span>Facebook</span></label><input${ssrRenderAttr("value", unref(profileData).facebook)} type="text" class="form-input" placeholder="facebook.com/username"></div></div></div><div class="form-section readonly-section"><div class="section-header"><div class="section-icon readonly-icon"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg></div><h4 class="section-title">CRM Information (Read-only)</h4><div class="readonly-badge"><svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg><span>Managed by CRM</span></div></div><div class="form-grid"><div class="form-group readonly-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path></svg></div><span>Customer Number</span><span class="readonly-indicator">*</span></label><input${ssrRenderAttr("value", unref(profileData).kundennummer)} type="text" class="form-input readonly-input" readonly></div><div class="form-group readonly-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg></div><span>Full Name</span><span class="readonly-indicator">*</span></label><input${ssrRenderAttr("value", unref(profileData).name)} type="text" class="form-input readonly-input" readonly></div><div class="form-group readonly-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg></div><span>Email Address</span><span class="readonly-indicator">*</span></label><input${ssrRenderAttr("value", unref(profileData).email)} type="email" class="form-input readonly-input" readonly></div><div class="form-group readonly-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg></div><span>Account Manager</span><span class="readonly-indicator">*</span></label><input${ssrRenderAttr("value", unref(profileData).betreuer)} type="text" class="form-input readonly-input" readonly></div><div class="form-group readonly-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path></svg></div><span>Payment Method</span><span class="readonly-indicator">*</span></label><input${ssrRenderAttr("value", unref(profileData).zahlart)} type="text" class="form-input readonly-input" readonly></div><div class="form-group readonly-group"><label class="form-label"><div class="label-icon"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path></svg></div><span>Customer Type</span><span class="readonly-indicator">*</span></label><input${ssrRenderAttr("value", unref(profileData).kundentyp)} type="text" class="form-input readonly-input" readonly></div></div></div></form></div></div></div></div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/c/[slug]/profile.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=profile-De9b1BDR.mjs.map
