import { defineComponent, ref, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderClass, ssrRenderList, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain, ssrLooseEqual } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "settings",
  __ssrInlineRender: true,
  setup(__props) {
    const activeTab = ref("users");
    const showCreateUserModal = ref(false);
    const editingUser = ref(null);
    const userSearch = ref("");
    const userRoleFilter = ref("");
    const tabs = [
      { id: "users", name: "User Management" },
      { id: "permissions", name: "Permissions" },
      { id: "account", name: "Account Settings" }
    ];
    const modules = [
      { id: "financial", name: "Financial" },
      { id: "marketing", name: "Marketing" },
      { id: "elearning", name: "E-Learning" },
      { id: "projects", name: "Projects" },
      { id: "settings", name: "Settings" },
      { id: "profile", name: "Profile" }
    ];
    const settingsData = ref({
      users: [
        {
          id: "1",
          email: "admin@example.com",
          name: "Admin User",
          role: "admin",
          isActive: true,
          createdAt: /* @__PURE__ */ new Date("2024-01-01"),
          updatedAt: /* @__PURE__ */ new Date("2024-01-01"),
          lastLogin: /* @__PURE__ */ new Date("2024-01-25")
        },
        {
          id: "2",
          email: "john@example.com",
          name: "John Smith",
          role: "user",
          isActive: true,
          createdAt: /* @__PURE__ */ new Date("2024-01-05"),
          updatedAt: /* @__PURE__ */ new Date("2024-01-05"),
          lastLogin: /* @__PURE__ */ new Date("2024-01-24")
        },
        {
          id: "3",
          email: "sarah@example.com",
          name: "Sarah Johnson",
          role: "user",
          isActive: true,
          createdAt: /* @__PURE__ */ new Date("2024-01-10"),
          updatedAt: /* @__PURE__ */ new Date("2024-01-10"),
          lastLogin: /* @__PURE__ */ new Date("2024-01-23")
        },
        {
          id: "4",
          email: "mike@example.com",
          name: "Mike Wilson",
          role: "user",
          isActive: false,
          createdAt: /* @__PURE__ */ new Date("2024-01-15"),
          updatedAt: /* @__PURE__ */ new Date("2024-01-20"),
          lastLogin: /* @__PURE__ */ new Date("2024-01-20")
        }
      ],
      permissions: [
        {
          id: "1",
          userId: "1",
          moduleId: "financial",
          canRead: true,
          canWrite: true,
          canDelete: true
        },
        {
          id: "2",
          userId: "1",
          moduleId: "marketing",
          canRead: true,
          canWrite: true,
          canDelete: true
        },
        {
          id: "3",
          userId: "1",
          moduleId: "elearning",
          canRead: true,
          canWrite: true,
          canDelete: true
        },
        {
          id: "4",
          userId: "1",
          moduleId: "projects",
          canRead: true,
          canWrite: true,
          canDelete: true
        },
        {
          id: "5",
          userId: "1",
          moduleId: "settings",
          canRead: true,
          canWrite: true,
          canDelete: true
        },
        {
          id: "6",
          userId: "1",
          moduleId: "profile",
          canRead: true,
          canWrite: true,
          canDelete: true
        },
        {
          id: "7",
          userId: "2",
          moduleId: "financial",
          canRead: true,
          canWrite: false,
          canDelete: false
        },
        {
          id: "8",
          userId: "2",
          moduleId: "marketing",
          canRead: true,
          canWrite: true,
          canDelete: false
        },
        {
          id: "9",
          userId: "2",
          moduleId: "projects",
          canRead: true,
          canWrite: true,
          canDelete: false
        },
        {
          id: "10",
          userId: "3",
          moduleId: "elearning",
          canRead: true,
          canWrite: false,
          canDelete: false
        },
        {
          id: "11",
          userId: "3",
          moduleId: "projects",
          canRead: true,
          canWrite: true,
          canDelete: false
        }
      ],
      seatUsage: 4,
      seatLimit: 10
    });
    const newUser = ref({
      name: "",
      email: "",
      role: "",
      password: "",
      modules: []
    });
    const companyInfo = ref({
      name: "Demo Company",
      email: "contact@democompany.com",
      phone: "+1 555-0123",
      address: "123 Business St, City, State 12345"
    });
    const filteredUsers = computed(() => {
      let users = settingsData.value.users;
      if (userSearch.value) {
        users = users.filter(
          (u) => u.name.toLowerCase().includes(userSearch.value.toLowerCase()) || u.email.toLowerCase().includes(userSearch.value.toLowerCase())
        );
      }
      if (userRoleFilter.value) {
        users = users.filter((u) => u.role === userRoleFilter.value);
      }
      return users;
    });
    const formatDate = (date) => {
      return new Intl.DateTimeFormat("en-US", {
        year: "numeric",
        month: "short",
        day: "numeric"
      }).format(date);
    };
    const getRoleBadgeClass = (role) => {
      switch (role) {
        case "admin":
          return "badge-warning";
        case "user":
          return "badge-info";
        default:
          return "badge-info";
      }
    };
    const getSeatUsageClass = () => {
      const percentage = getSeatUsagePercentage();
      if (percentage >= 90) return "negative";
      if (percentage >= 75) return "warning";
      return "positive";
    };
    const getSeatUsagePercentage = () => {
      return Math.round(
        settingsData.value.seatUsage / settingsData.value.seatLimit * 100
      );
    };
    const getActiveUsers = () => {
      return settingsData.value.users.filter((u) => u.isActive).length;
    };
    const getAdminUsers = () => {
      return settingsData.value.users.filter((u) => u.role === "admin").length;
    };
    const getUserModules = (userId) => {
      const userPermissions = settingsData.value.permissions.filter(
        (p) => p.userId === userId
      );
      return userPermissions.map((p) => p.moduleId);
    };
    const hasPermission = (userId, moduleId) => {
      const permission = settingsData.value.permissions.find(
        (p) => p.userId === userId && p.moduleId === moduleId
      );
      return permission ? permission.canRead : false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "settings-module" }, _attrs))}><div class="module-actions mb-6"><div class="flex items-center justify-between"><div class="flex items-center gap-4"><button class="btn btn-primary" title="Add User"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg></button></div></div></div><div class="content-body"><div class="kpi-grid mb-8"><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(unref(settingsData).seatUsage)}/${ssrInterpolate(unref(settingsData).seatLimit)}</div><div class="kpi-label">Seat Usage</div><div class="${ssrRenderClass([getSeatUsageClass(), "kpi-change"])}">${ssrInterpolate(getSeatUsagePercentage())}% used </div></div><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(unref(settingsData).users.length)}</div><div class="kpi-label">Total Users</div><div class="kpi-change positive">+1 this month</div></div><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(getActiveUsers())}</div><div class="kpi-label">Active Users</div><div class="kpi-change positive">All active</div></div><div class="kpi-card"><div class="kpi-value">${ssrInterpolate(getAdminUsers())}</div><div class="kpi-label">Admin Users</div><div class="kpi-change">No change</div></div></div><div class="tabs-container card mb-8"><div class="tabs-header"><!--[-->`);
      ssrRenderList(tabs, (tab) => {
        _push(`<button class="${ssrRenderClass([{ active: unref(activeTab) === tab.id }, "tab-button"])}">${ssrInterpolate(tab.name)}</button>`);
      });
      _push(`<!--]--></div><div class="tabs-content">`);
      if (unref(activeTab) === "users") {
        _push(`<div class="tab-pane"><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Recent Users</h3><div class="flex gap-2"><input${ssrRenderAttr("value", unref(userSearch))} type="text" placeholder="Search users..." class="form-input"><select class="form-select"><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(userRoleFilter)) ? ssrLooseContain(unref(userRoleFilter), "") : ssrLooseEqual(unref(userRoleFilter), "")) ? " selected" : ""}>All Roles</option><option value="admin"${ssrIncludeBooleanAttr(Array.isArray(unref(userRoleFilter)) ? ssrLooseContain(unref(userRoleFilter), "admin") : ssrLooseEqual(unref(userRoleFilter), "admin")) ? " selected" : ""}>Admin</option><option value="user"${ssrIncludeBooleanAttr(Array.isArray(unref(userRoleFilter)) ? ssrLooseContain(unref(userRoleFilter), "user") : ssrLooseEqual(unref(userRoleFilter), "user")) ? " selected" : ""}>User</option></select></div></div><div class="users-list"><ul class="users-list-ul"><!--[-->`);
        ssrRenderList(unref(filteredUsers), (user) => {
          _push(`<li class="user-item card"><div class="card-body user-item-body"><div class="user-main flex items-start justify-between"><div class="user-info"><div class="user-name font-medium">${ssrInterpolate(user.name)}</div><div class="user-email text-sm text-gray-500">${ssrInterpolate(user.email)}</div><div class="user-meta mt-2 text-sm"><span class="${ssrRenderClass([getRoleBadgeClass(user.role), "badge"])}">${ssrInterpolate(user.role)}</span><span class="${ssrRenderClass([
            user.isActive ? "badge-success" : "badge-error",
            "badge"
          ])}">${ssrInterpolate(user.isActive ? "Active" : "Inactive")}</span><span class="text-gray-500 ml-2">${ssrInterpolate(formatDate(user.lastLogin || user.createdAt))}</span></div><div class="user-modules mt-2"><!--[-->`);
          ssrRenderList(getUserModules(user.id), (module) => {
            _push(`<span class="badge badge-info text-xs">${ssrInterpolate(module)}</span>`);
          });
          _push(`<!--]--></div></div><div class="user-actions flex flex-row items-center gap-2"><div class="action-row"><button class="btn btn-sm btn-outline"> Edit </button><button class="${ssrRenderClass([
            "btn btn-sm",
            user.isActive ? "btn-warning" : "btn-success"
          ])}">${ssrInterpolate(user.isActive ? "Deactivate" : "Activate")}</button></div><div class="action-row"><button class="btn btn-sm btn-error"> Delete </button></div></div></div></div></li>`);
        });
        _push(`<!--]--></ul></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "permissions") {
        _push(`<div class="tab-pane"><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Recent Permissions</h3><button class="btn btn-primary"> Save Changes </button></div><div class="table-responsive"><table class="data-table"><thead><tr><th>User</th><th>Financial</th><th>Marketing</th><th>E-Learning</th><th>Projects</th><th>Settings</th><th>Profile</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(unref(settingsData).users, (user) => {
          _push(`<tr><td class="font-medium">${ssrInterpolate(user.name)}</td><!--[-->`);
          ssrRenderList(modules, (module) => {
            _push(`<td><label class="flex items-center justify-center"><input type="checkbox"${ssrIncludeBooleanAttr(hasPermission(user.id, module.id)) ? " checked" : ""} class="form-checkbox"></label></td>`);
          });
          _push(`<!--]--></tr>`);
        });
        _push(`<!--]--></tbody></table></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "account") {
        _push(`<div class="tab-pane"><div class="grid grid-cols-1 lg:grid-cols-2 gap-6"><div class="card"><div class="card-header"><h3 class="text-lg font-semibold"> Subscription Information </h3></div><div class="card-body"><div class="space-y-4"><div><label class="form-label">Current Plan</label><p class="text-lg font-semibold text-blue-600"> Pro Plan </p></div><div><label class="form-label">Seat Limit</label><p class="text-lg">${ssrInterpolate(unref(settingsData).seatLimit)} users</p></div><div><label class="form-label">Billing Cycle</label><p class="text-lg">Monthly</p></div><div><label class="form-label">Next Billing Date</label><p class="text-lg">${ssrInterpolate(formatDate(/* @__PURE__ */ new Date("2024-02-01")))}</p></div><div class="pt-4 border-t"><button class="btn btn-outline">Upgrade Plan</button></div></div></div></div><div class="card"><div class="card-header"><h3 class="text-lg font-semibold">Company Information</h3></div><div class="card-body"><form><div class="form-group"><label class="form-label">Company Name</label><input${ssrRenderAttr("value", unref(companyInfo).name)} type="text" class="form-input"></div><div class="form-group"><label class="form-label">Company Email</label><input${ssrRenderAttr("value", unref(companyInfo).email)} type="email" class="form-input"></div><div class="form-group"><label class="form-label">Phone Number</label><input${ssrRenderAttr("value", unref(companyInfo).phone)} type="tel" class="form-input"></div><div class="form-group"><label class="form-label">Address</label><textarea class="form-textarea">${ssrInterpolate(unref(companyInfo).address)}</textarea></div><div class="form-group"><button type="submit" class="btn btn-primary"> Update Information </button></div></form></div></div><div class="card"><div class="card-header"><h3 class="text-lg font-semibold">Security Settings</h3></div><div class="card-body"><div class="space-y-4"><div class="flex items-center justify-between"><div><h4 class="font-medium">Two-Factor Authentication</h4><p class="text-sm text-gray-600"> Add an extra layer of security </p></div><button class="btn btn-outline">Enable</button></div><div class="flex items-center justify-between"><div><h4 class="font-medium">Password Policy</h4><p class="text-sm text-gray-600"> Require strong passwords </p></div><button class="btn btn-outline">Configure</button></div><div class="flex items-center justify-between"><div><h4 class="font-medium">Session Timeout</h4><p class="text-sm text-gray-600"> Auto-logout after inactivity </p></div><select class="form-select"><option value="30">30 minutes</option><option value="60">1 hour</option><option value="120">2 hours</option><option value="480">8 hours</option></select></div></div></div></div><div class="card"><div class="card-header"><h3 class="text-lg font-semibold">Integration Settings</h3></div><div class="card-body"><div class="space-y-4"><div class="flex items-center justify-between"><div><h4 class="font-medium">Zoho CRM</h4><p class="text-sm text-gray-600">Sync customer data</p></div><div class="flex items-center gap-2"><div class="w-3 h-3 rounded-full bg-green-500"></div><span class="text-sm">Connected</span></div></div><div class="flex items-center justify-between"><div><h4 class="font-medium">Zoho Books</h4><p class="text-sm text-gray-600">Financial data sync</p></div><div class="flex items-center gap-2"><div class="w-3 h-3 rounded-full bg-green-500"></div><span class="text-sm">Connected</span></div></div><div class="flex items-center justify-between"><div><h4 class="font-medium">Zoho Projects</h4><p class="text-sm text-gray-600">Project management</p></div><div class="flex items-center gap-2"><div class="w-3 h-3 rounded-full bg-red-500"></div><span class="text-sm">Disconnected</span></div></div><div class="pt-4 border-t"><button class="btn btn-outline"> Manage Integrations </button></div></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
      if (unref(showCreateUserModal)) {
        _push(`<div class="modal-overlay"><div class="modal"><div class="modal-header"><h3 class="text-lg font-semibold">Add New User</h3><button class="text-gray-400 hover:text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><form><div class="form-group"><label class="form-label">Full Name</label><input${ssrRenderAttr("value", unref(newUser).name)} type="text" class="form-input" required></div><div class="form-group"><label class="form-label">Email Address</label><input${ssrRenderAttr("value", unref(newUser).email)} type="email" class="form-input" required></div><div class="form-group"><label class="form-label">Role</label><select class="form-select" required><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(newUser).role) ? ssrLooseContain(unref(newUser).role, "") : ssrLooseEqual(unref(newUser).role, "")) ? " selected" : ""}>Select Role</option><option value="admin"${ssrIncludeBooleanAttr(Array.isArray(unref(newUser).role) ? ssrLooseContain(unref(newUser).role, "admin") : ssrLooseEqual(unref(newUser).role, "admin")) ? " selected" : ""}>Admin</option><option value="user"${ssrIncludeBooleanAttr(Array.isArray(unref(newUser).role) ? ssrLooseContain(unref(newUser).role, "user") : ssrLooseEqual(unref(newUser).role, "user")) ? " selected" : ""}>User</option></select></div><div class="form-group"><label class="form-label">Temporary Password</label><input${ssrRenderAttr("value", unref(newUser).password)} type="password" class="form-input" required></div><div class="form-group"><label class="form-label">Module Access</label><div class="space-y-2"><!--[-->`);
        ssrRenderList(modules, (module) => {
          _push(`<label class="flex items-center"><input${ssrIncludeBooleanAttr(Array.isArray(unref(newUser).modules) ? ssrLooseContain(unref(newUser).modules, module.id) : unref(newUser).modules) ? " checked" : ""}${ssrRenderAttr("value", module.id)} type="checkbox" class="form-checkbox mr-2"><span>${ssrInterpolate(module.name)}</span></label>`);
        });
        _push(`<!--]--></div></div></form></div><div class="modal-footer"><button class="btn btn-outline"> Cancel </button><button class="btn btn-primary"> Create User </button></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(editingUser)) {
        _push(`<div class="modal-overlay"><div class="modal"><div class="modal-header"><h3 class="text-lg font-semibold">Edit User</h3><button class="text-gray-400 hover:text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><form><div class="form-group"><label class="form-label">Full Name</label><input${ssrRenderAttr("value", unref(editingUser).name)} type="text" class="form-input" required></div><div class="form-group"><label class="form-label">Email Address</label><input${ssrRenderAttr("value", unref(editingUser).email)} type="email" class="form-input" required></div><div class="form-group"><label class="form-label">Role</label><select class="form-select" required><option value="admin"${ssrIncludeBooleanAttr(Array.isArray(unref(editingUser).role) ? ssrLooseContain(unref(editingUser).role, "admin") : ssrLooseEqual(unref(editingUser).role, "admin")) ? " selected" : ""}>Admin</option><option value="user"${ssrIncludeBooleanAttr(Array.isArray(unref(editingUser).role) ? ssrLooseContain(unref(editingUser).role, "user") : ssrLooseEqual(unref(editingUser).role, "user")) ? " selected" : ""}>User</option></select></div><div class="form-group"><label class="form-label">Status</label><select class="form-select"><option${ssrRenderAttr("value", true)}${ssrIncludeBooleanAttr(Array.isArray(unref(editingUser).isActive) ? ssrLooseContain(unref(editingUser).isActive, true) : ssrLooseEqual(unref(editingUser).isActive, true)) ? " selected" : ""}>Active</option><option${ssrRenderAttr("value", false)}${ssrIncludeBooleanAttr(Array.isArray(unref(editingUser).isActive) ? ssrLooseContain(unref(editingUser).isActive, false) : ssrLooseEqual(unref(editingUser).isActive, false)) ? " selected" : ""}>Inactive</option></select></div></form></div><div class="modal-footer"><button class="btn btn-outline"> Cancel </button><button class="btn btn-primary"> Update User </button></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/c/[slug]/settings.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=settings-B4KkXKFc.mjs.map
