import { defineComponent, ref, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrIncludeBooleanAttr, ssrInterpolate, ssrRenderClass, ssrRenderList, ssrRenderAttr } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "zoho-integration",
  __ssrInlineRender: true,
  setup(__props) {
    const activeTab = ref("search");
    const showConfigModal = ref(false);
    const searchQuery = ref("");
    const isSearching = ref(false);
    const isRefreshing = ref(false);
    const isTesting = ref(false);
    const searchResults = ref([]);
    const hasSearched = ref(false);
    const createdAccounts = ref(5);
    const tabs = [
      { id: "search", name: "Contact Search" },
      { id: "recent", name: "Recent Contacts" },
      { id: "accounts", name: "Account Creation" },
      { id: "config", name: "Configuration" }
    ];
    const zohoIntegration = ref({
      isConnected: true,
      contacts: [],
      recentContacts: [
        {
          id: "1",
          name: "John Smith",
          email: "john@example.com",
          phone: "+1 555-0123",
          company: "Tech Corp",
          leadSource: "Website",
          status: "Active"
        },
        {
          id: "2",
          name: "Sarah Johnson",
          email: "sarah@company.com",
          phone: "+1 555-0456",
          company: "Marketing Inc",
          leadSource: "Referral",
          status: "Active"
        },
        {
          id: "3",
          name: "Mike Wilson",
          email: "mike@business.com",
          phone: "+1 555-0789",
          company: "Startup Co",
          leadSource: "Social Media",
          status: "Qualified"
        }
      ],
      apiStatus: "connected"
    });
    const config = ref({
      clientId: "",
      clientSecret: "",
      refreshToken: "",
      organizationId: ""
    });
    const createdAccountsList = ref([
      {
        id: "1",
        contactName: "John Smith",
        email: "john@example.com",
        company: "Tech Corp",
        createdDate: /* @__PURE__ */ new Date("2024-01-20"),
        status: "active"
      },
      {
        id: "2",
        contactName: "Sarah Johnson",
        email: "sarah@company.com",
        company: "Marketing Inc",
        createdDate: /* @__PURE__ */ new Date("2024-01-18"),
        status: "active"
      },
      {
        id: "3",
        contactName: "Mike Wilson",
        email: "mike@business.com",
        company: "Startup Co",
        createdDate: /* @__PURE__ */ new Date("2024-01-15"),
        status: "pending"
      }
    ]);
    const formatDate = (date) => {
      return new Intl.DateTimeFormat("en-US", {
        year: "numeric",
        month: "short",
        day: "numeric"
      }).format(date);
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "zoho-integration-module" }, _attrs))}><div class="module-actions mb-6"><div class="flex items-center justify-between"><div class="flex items-center gap-4"><button class="btn btn-outline"${ssrIncludeBooleanAttr(unref(isTesting)) ? " disabled" : ""} title="Test All Connections"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>`);
      if (unref(isTesting)) {
        _push(`<span class="spinner mr-2"></span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button><button class="btn btn-primary" title="Configure"><svg class="btn-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg></button></div></div></div><div class="content-body"><div class="kpi-grid mb-8"><div class="kpi-card"><div class="flex items-center justify-between"><div><div class="kpi-value">${ssrInterpolate(unref(zohoIntegration).isConnected ? "Connected" : "Disconnected")}</div><div class="kpi-label">Zoho CRM</div></div><div class="${ssrRenderClass([unref(zohoIntegration).isConnected ? "bg-green-100" : "bg-red-100", "w-12 h-12 rounded-full flex items-center justify-center"])}"><svg class="${ssrRenderClass([unref(zohoIntegration).isConnected ? "text-green-600" : "text-red-600", "w-6 h-6"])}" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg></div></div></div><div class="kpi-card"><div class="flex items-center justify-between"><div><div class="kpi-value">${ssrInterpolate(unref(zohoIntegration).contacts.length)}</div><div class="kpi-label">Total Contacts</div></div><div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center"><svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg></div></div></div><div class="kpi-card"><div class="flex items-center justify-between"><div><div class="kpi-value">${ssrInterpolate(unref(zohoIntegration).recentContacts.length)}</div><div class="kpi-label">Recent Contacts</div></div><div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center"><svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg></div></div></div><div class="kpi-card"><div class="flex items-center justify-between"><div><div class="kpi-value">${ssrInterpolate(unref(createdAccounts))}</div><div class="kpi-label">Created Accounts</div></div><div class="w-12 h-12 rounded-full bg-green-100 flex items-center justify-center"><svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg></div></div></div></div><div class="card"><div class="card-header"><div class="flex items-center gap-6"><!--[-->`);
      ssrRenderList(tabs, (tab) => {
        _push(`<button class="${ssrRenderClass([unref(activeTab) === tab.id ? "border-blue-500 text-blue-600" : "border-transparent text-gray-500 hover:text-gray-700", "pb-2 border-b-2 transition-colors"])}">${ssrInterpolate(tab.name)}</button>`);
      });
      _push(`<!--]--></div></div><div class="card-body">`);
      if (unref(activeTab) === "search") {
        _push(`<div><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Contact Search</h3><div class="flex gap-2"><input${ssrRenderAttr("value", unref(searchQuery))} type="text" placeholder="Search by email..." class="form-input"><button class="btn btn-primary"${ssrIncludeBooleanAttr(unref(isSearching)) ? " disabled" : ""}>`);
        if (unref(isSearching)) {
          _push(`<span class="spinner mr-2"></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(` Search </button></div></div>`);
        if (unref(searchResults).length > 0) {
          _push(`<div class="mb-6"><h4 class="font-semibold mb-4">Search Results</h4><div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4"><!--[-->`);
          ssrRenderList(unref(searchResults), (contact) => {
            _push(`<div class="card"><div class="card-body"><h5 class="font-semibold mb-2">${ssrInterpolate(contact.name)}</h5><p class="text-sm text-gray-600 mb-2">${ssrInterpolate(contact.email)}</p>`);
            if (contact.phone) {
              _push(`<p class="text-sm text-gray-600 mb-2">${ssrInterpolate(contact.phone)}</p>`);
            } else {
              _push(`<!---->`);
            }
            if (contact.company) {
              _push(`<p class="text-sm text-gray-600 mb-2">${ssrInterpolate(contact.company)}</p>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="flex items-center gap-2"><span class="badge badge-info text-xs">${ssrInterpolate(contact.leadSource || "Unknown")}</span><span class="badge badge-warning text-xs">${ssrInterpolate(contact.status || "Active")}</span></div><div class="mt-4"><button class="btn btn-primary w-full"> Create Account </button></div></div></div>`);
          });
          _push(`<!--]--></div></div>`);
        } else if (unref(hasSearched)) {
          _push(`<div class="text-center py-8"><p class="text-gray-500">No contacts found matching your search criteria.</p></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "recent") {
        _push(`<div><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Recent Contacts</h3><button class="btn btn-outline"${ssrIncludeBooleanAttr(unref(isRefreshing)) ? " disabled" : ""}>`);
        if (unref(isRefreshing)) {
          _push(`<span class="spinner mr-2"></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(` Refresh </button></div><div class="table-responsive"><table class="data-table"><thead><tr><th>Name</th><th>Email</th><th>Company</th><th>Source</th><th>Status</th><th>Last Modified</th><th>Actions</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(unref(zohoIntegration).recentContacts, (contact) => {
          _push(`<tr><td class="font-medium">${ssrInterpolate(contact.name)}</td><td>${ssrInterpolate(contact.email)}</td><td>${ssrInterpolate(contact.company || "N/A")}</td><td>${ssrInterpolate(contact.leadSource || "N/A")}</td><td><span class="badge badge-info">${ssrInterpolate(contact.status || "Active")}</span></td><td>${ssrInterpolate(formatDate(/* @__PURE__ */ new Date()))}</td><td><div class="table-actions"><button class="btn btn-sm btn-outline">View</button><button class="btn btn-sm btn-primary">Create Account</button></div></td></tr>`);
        });
        _push(`<!--]--></tbody></table></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "accounts") {
        _push(`<div><div class="flex items-center justify-between mb-4"><h3 class="text-lg font-semibold">Account Creation History</h3><button class="btn btn-outline"><svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg> Export Data </button></div><div class="table-responsive"><table class="data-table"><thead><tr><th>Contact Name</th><th>Email</th><th>Company</th><th>Created Date</th><th>Status</th><th>Actions</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(unref(createdAccountsList), (account) => {
          _push(`<tr><td class="font-medium">${ssrInterpolate(account.contactName)}</td><td>${ssrInterpolate(account.email)}</td><td>${ssrInterpolate(account.company)}</td><td>${ssrInterpolate(formatDate(account.createdDate))}</td><td><span class="${ssrRenderClass([account.status === "active" ? "badge-success" : "badge-warning", "badge"])}">${ssrInterpolate(account.status)}</span></td><td><div class="table-actions"><button class="btn btn-sm btn-outline">View</button><button class="btn btn-sm btn-primary">Manage</button></div></td></tr>`);
        });
        _push(`<!--]--></tbody></table></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(activeTab) === "config") {
        _push(`<div><div class="grid grid-cols-1 lg:grid-cols-2 gap-6"><div class="card"><div class="card-header"><h3 class="text-lg font-semibold">API Configuration</h3></div><div class="card-body"><form><div class="form-group"><label class="form-label">Client ID</label><input${ssrRenderAttr("value", unref(config).clientId)} type="text" class="form-input"></div><div class="form-group"><label class="form-label">Client Secret</label><input${ssrRenderAttr("value", unref(config).clientSecret)} type="password" class="form-input"></div><div class="form-group"><label class="form-label">Refresh Token</label><input${ssrRenderAttr("value", unref(config).refreshToken)} type="password" class="form-input"></div><div class="form-group"><label class="form-label">Organization ID</label><input${ssrRenderAttr("value", unref(config).organizationId)} type="text" class="form-input"></div><div class="form-group"><button type="submit" class="btn btn-primary">Save Configuration</button></div></form></div></div><div class="card"><div class="card-header"><h3 class="text-lg font-semibold">Connection Status</h3></div><div class="card-body"><div class="space-y-4"><div class="flex items-center justify-between"><div><h4 class="font-medium">Zoho CRM</h4><p class="text-sm text-gray-600">Contact and lead management</p></div><div class="flex items-center gap-2"><div class="${ssrRenderClass([unref(zohoIntegration).isConnected ? "bg-green-500" : "bg-red-500", "w-3 h-3 rounded-full"])}"></div><span class="text-sm">${ssrInterpolate(unref(zohoIntegration).isConnected ? "Connected" : "Disconnected")}</span></div></div><div class="flex items-center justify-between"><div><h4 class="font-medium">Zoho Books</h4><p class="text-sm text-gray-600">Financial data integration</p></div><div class="flex items-center gap-2"><div class="w-3 h-3 rounded-full bg-green-500"></div><span class="text-sm">Connected</span></div></div><div class="flex items-center justify-between"><div><h4 class="font-medium">Zoho Projects</h4><p class="text-sm text-gray-600">Project management</p></div><div class="flex items-center gap-2"><div class="w-3 h-3 rounded-full bg-red-500"></div><span class="text-sm">Disconnected</span></div></div><div class="pt-4 border-t"><div class="text-sm text-gray-600"><p><strong>Last Sync:</strong> ${ssrInterpolate(formatDate(/* @__PURE__ */ new Date()))}</p><p><strong>Next Sync:</strong> ${ssrInterpolate(formatDate(new Date(Date.now() + 24 * 60 * 60 * 1e3)))}</p></div></div></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
      if (unref(showConfigModal)) {
        _push(`<div class="modal-overlay"><div class="modal"><div class="modal-header"><h3 class="text-lg font-semibold">Zoho Integration Configuration</h3><button class="text-gray-400 hover:text-gray-600"><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div class="modal-body"><form><div class="form-group"><label class="form-label">Client ID</label><input${ssrRenderAttr("value", unref(config).clientId)} type="text" class="form-input" required></div><div class="form-group"><label class="form-label">Client Secret</label><input${ssrRenderAttr("value", unref(config).clientSecret)} type="password" class="form-input" required></div><div class="form-group"><label class="form-label">Refresh Token</label><input${ssrRenderAttr("value", unref(config).refreshToken)} type="password" class="form-input" required></div><div class="form-group"><label class="form-label">Organization ID</label><input${ssrRenderAttr("value", unref(config).organizationId)} type="text" class="form-input" required></div><div class="form-group"><button class="btn btn-outline mr-2">Test Connection</button><button type="submit" class="btn btn-primary">Save &amp; Connect</button></div></form></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/c/[slug]/zoho-integration.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=zoho-integration-BFs8vPAO.mjs.map
