import { d as defineEventHandler, r as readBody, c as createError, u as useRuntimeConfig, s as setCookie } from '../../../nitro/nitro.mjs';
import jwt from 'jsonwebtoken';
import bcrypt from 'bcryptjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';

const login_post = defineEventHandler(async (event) => {
  try {
    const body = await readBody(event);
    const { email, password } = body;
    if (!email || !password) {
      throw createError({
        statusCode: 400,
        statusMessage: "Email and password are required"
      });
    }
    const mockUser = {
      id: "1",
      email: "owner@sidashboard.com",
      password: "$2a$10$cWGjQWVM5XWTjTUMdL0tMOvAqDyVQVq0.xcIMOFm1wSiSAe20qezO",
      // admin123
      name: "Owner User",
      role: "owner",
      isActive: true
    };
    const isValidPassword = await bcrypt.compare(password, mockUser.password);
    if (!isValidPassword) {
      throw createError({
        statusCode: 401,
        statusMessage: "Invalid credentials"
      });
    }
    const config = useRuntimeConfig();
    const token = jwt.sign(
      {
        userId: mockUser.id,
        email: mockUser.email,
        role: mockUser.role
      },
      config.jwtSecret,
      { expiresIn: "24h" }
    );
    setCookie(event, "auth-token", token, {
      httpOnly: true,
      secure: true,
      sameSite: "strict",
      maxAge: 24 * 60 * 60
      // 24 hours
    });
    setCookie(event, "user", JSON.stringify({
      id: mockUser.id,
      email: mockUser.email,
      name: mockUser.name,
      role: mockUser.role
    }), {
      httpOnly: false,
      secure: true,
      sameSite: "strict",
      maxAge: 24 * 60 * 60
    });
    return {
      success: true,
      data: {
        user: {
          id: mockUser.id,
          email: mockUser.email,
          name: mockUser.name,
          role: mockUser.role
        }
      }
    };
  } catch (error) {
    throw createError({
      statusCode: error.statusCode || 500,
      statusMessage: error.statusMessage || "Login failed"
    });
  }
});

export { login_post as default };
//# sourceMappingURL=login.post.mjs.map
