import { d as defineEventHandler, s as setCookie, c as createError } from '../../../nitro/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';

const logout_post = defineEventHandler(async (event) => {
  try {
    setCookie(event, "auth-token", "", {
      httpOnly: true,
      secure: true,
      sameSite: "strict",
      maxAge: 0
    });
    setCookie(event, "user", "", {
      httpOnly: false,
      secure: true,
      sameSite: "strict",
      maxAge: 0
    });
    return {
      success: true,
      message: "Logged out successfully"
    };
  } catch (error) {
    throw createError({
      statusCode: 500,
      statusMessage: "Logout failed"
    });
  }
});

export { logout_post as default };
//# sourceMappingURL=logout.post.mjs.map
