import { d as defineEventHandler, g as getCookie, c as createError, u as useRuntimeConfig } from '../../../nitro/nitro.mjs';
import jwt from 'jsonwebtoken';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';

const verify_get = defineEventHandler(async (event) => {
  try {
    const token = getCookie(event, "auth-token");
    if (!token) {
      throw createError({
        statusCode: 401,
        statusMessage: "No token provided"
      });
    }
    const config = useRuntimeConfig();
    const decoded = jwt.verify(token, config.jwtSecret);
    return {
      success: true,
      data: {
        userId: decoded.userId,
        email: decoded.email,
        role: decoded.role
      }
    };
  } catch (error) {
    throw createError({
      statusCode: 401,
      statusMessage: "Invalid token"
    });
  }
});

export { verify_get as default };
//# sourceMappingURL=verify.get.mjs.map
