# SI Dashboard - Business Management Platform

A comprehensive business management dashboard built with Nuxt.js, featuring modular architecture and Zoho integrations.

## 🚀 Features

### 👑 Owner Dashboard (`/owner`)
- **Customer Management**: Create, view, and manage customer accounts
- **Subscription Management**: Monitor subscription tiers and seat usage
- **Tenant Control**: Lock/unlock customer access, billing management
- **Admin Settings**: Manage super admins and system settings

### 🏢 Customer Dashboard (`/c/:slug`)
- **Modern Interface**: Collapsible sidebar with module navigation
- **KPI Overview**: Real-time business metrics and performance indicators
- **Module Access**: Quick access to all subscribed business modules
- **User Profile**: Account management and settings

### 💰 Financial Module (`/financial`)
- **Zoho Books Integration**: Real-time financial data sync
- **Invoice Management**: Create, view, and download invoices
- **Estimates & Sales Orders**: Complete financial document management
- **Revenue Analytics**: Track income, expenses, and profit metrics

### 📈 Marketing Module (`/marketing`)
- **Campaign Management**: Create and track marketing campaigns
- **Lead Management**: Comprehensive lead tracking and scoring
- **Analytics Dashboard**: Marketing performance metrics and ROI
- **Content Tools**: Marketing content creation and management

### 🎓 E-Learning Module (`/elearning`)
- **Course Library**: Create and manage training courses
- **Progress Tracking**: Monitor user learning progress
- **Certificate System**: Issue and manage completion certificates
- **Video Content**: Educational videos and interactive content

### 📋 Projects Module (`/projects`)
- **Project Management**: Complete project lifecycle management
- **Task Assignment**: Delegate and track tasks across team members
- **Team Collaboration**: Team member management and communication
- **Timeline View**: Visual project schedules and deadlines

### ⚙️ Settings Module (`/settings`)
- **User Management**: Add, edit, and manage team members
- **Permission Control**: Granular module access permissions
- **Seat Management**: Monitor subscription usage and limits
- **Account Settings**: Company information and security settings

### 👤 Profile Module (`/profile`)
- **CRM Integration**: Sync with Zoho CRM for customer data
- **Editable Fields**: Update business information and contact details
- **Read-only CRM Data**: View customer number, account manager, etc.
- **Social Media Links**: Manage Instagram, TikTok, and Facebook profiles

### 🔗 Zoho Integration (`/zoho-integration`)
- **Contact Search**: Search and manage Zoho CRM contacts
- **Account Creation**: Create dashboard accounts from CRM contacts
- **API Configuration**: Manage Zoho API credentials and connections
- **Data Synchronization**: Real-time sync with Zoho services

## 🛠️ Technology Stack

- **Frontend**: Nuxt.js 3 with Vue 3 Composition API
- **Styling**: Pure CSS with custom design system
- **Authentication**: JWT-based authentication with middleware
- **API**: Server-side API routes with TypeScript
- **Integration**: Zoho CRM, Books, and Projects APIs
- **Messaging**: MQTT for real-time communication

## 📁 Project Structure

```
si-dashboard/
├── assets/css/           # Global styles and design system
├── components/           # Reusable Vue components
│   ├── common/          # Shared components
│   ├── owner/           # Owner dashboard components
│   ├── customer/        # Customer dashboard components
│   └── modules/         # Module-specific components
├── layouts/             # Page layouts
├── middleware/          # Authentication and route guards
├── pages/               # Application pages
│   ├── owner/           # Owner dashboard pages
│   ├── c/[slug]/        # Customer dashboard pages
│   └── modules/         # Module pages
├── server/              # Server-side logic
│   ├── api/             # API endpoints
│   ├── middleware/      # Server middleware
│   └── utils/           # Server utilities
├── stores/              # State management
├── types/               # TypeScript type definitions
└── utils/               # Client-side utilities
```

## 🚀 Getting Started

### Prerequisites

- Node.js 18+ 
- npm or yarn
- Zoho API credentials (optional)

### Installation

1. **Clone the repository**
   ```bash
   git clone <repository-url>
   cd si-dashboard
   ```

2. **Install dependencies**
   ```bash
   npm install
   ```

3. **Environment Setup**
   ```bash
   cp env.example .env
   ```
   
   Update the `.env` file with your configuration:
   ```env
   JWT_SECRET=your-super-secret-jwt-key-here
   ZOHO_CLIENT_ID=your-zoho-client-id
   ZOHO_CLIENT_SECRET=your-zoho-client-secret
   ZOHO_REFRESH_TOKEN=your-zoho-refresh-token
   MQTT_BROKER_URL=mqtt://localhost:1883
   ```

4. **Start Development Server**
   ```bash
   npm run dev
   ```

5. **Access the Application**
   - Open [http://localhost:3000](http://localhost:3000)
   - Use demo credentials:
     - **Email**: owner@sidashboard.com
     - **Password**: password

## 🔐 Authentication

The application uses JWT-based authentication with role-based access control:

- **Owner/Admin**: Full access to owner dashboard and customer management
- **Customer**: Access to customer dashboard and subscribed modules

### Demo Credentials

- **Owner Account**: owner@sidashboard.com / password
- **Customer Account**: Access through owner dashboard

## 🎨 Design System

The application uses a custom CSS design system with:

- **Color Palette**: Blue primary, semantic colors for status
- **Typography**: System fonts with consistent sizing
- **Components**: Reusable UI components (buttons, cards, forms)
- **Layout**: Responsive grid system and flexible layouts
- **Icons**: Heroicons for consistent iconography

## 🔌 Zoho Integration

### Supported Services

- **Zoho CRM**: Contact and lead management
- **Zoho Books**: Financial data and invoicing
- **Zoho Projects**: Project management (optional)

### Setup

1. Create Zoho API credentials in your Zoho Developer Console
2. Configure OAuth 2.0 for secure API access
3. Update environment variables with your credentials
4. Test connections in the Zoho Integration module

## 📱 Responsive Design

The application is fully responsive with:

- **Mobile-first approach**: Optimized for mobile devices
- **Breakpoints**: sm (640px), md (768px), lg (1024px), xl (1280px)
- **Flexible layouts**: Adaptive components and navigation
- **Touch-friendly**: Optimized for touch interactions

## 🚀 Deployment

### Production Build

```bash
npm run build
npm run preview
```

### Environment Variables

Ensure all production environment variables are set:

- `JWT_SECRET`: Strong secret key for JWT tokens
- `ZOHO_*`: Zoho API credentials
- `MQTT_BROKER_URL`: MQTT broker URL for real-time features

## 📊 Features Overview

| Module | Features | Integration |
|--------|----------|-------------|
| Owner Dashboard | Customer management, billing, admin settings | - |
| Financial | Invoices, estimates, sales orders | Zoho Books |
| Marketing | Campaigns, leads, analytics | - |
| E-Learning | Courses, progress, certificates | - |
| Projects | Tasks, team, timeline | Zoho Projects |
| Settings | Users, permissions, seats | - |
| Profile | CRM data, business info | Zoho CRM |
| Zoho Integration | Contact search, account creation | Zoho APIs |

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## 📄 License

This project is licensed under the MIT License.

## 🆘 Support

For support and questions:

- Create an issue in the repository
- Check the documentation
- Review the demo credentials for testing

---

**SI Dashboard** - Streamline your business operations with our comprehensive management platform.
