// @ts-nocheck
export default defineNuxtRouteMiddleware((to, from) => {
  // Only run on client side to avoid SSR issues
  if (process.server) {
    return
  }
  
  // TEMPORARILY DISABLED AUTHENTICATION LOGIC
  // Allow navigation to dashboard without checks
  console.log('🔍 Auth middleware temporarily disabled for:', to.path)
  return
  
  // Simple check - just look for the presence of cookies
  const token = useCookie('auth-token')
  const user = useCookie('user')
  
  console.log('🔍 Simple auth middleware running for:', to.path)
  console.log('🍪 Token exists:', !!token.value)
  console.log('👤 User exists:', !!user.value)
  
  // Simple check - if either cookie is missing, redirect to login
  if (!token.value || !user.value) {
    console.log('❌ Missing cookies, redirecting to login')
    return navigateTo('/login')
  }
  
  console.log('✅ Simple auth middleware passed')
})
