// @ts-nocheck
export default defineNuxtRouteMiddleware((to, from) => {
  // Only run on client side to avoid SSR issues
  if (process.server) {
    return
  }
  
  const user = useCookie('user')
  
  console.log('🔍 Owner middleware running for:', to.path)
  console.log('👤 User cookie exists:', !!user.value)
  
  // Simple check - if user cookie exists, assume it's valid
  // In a real app, you'd verify the JWT token
  if (!user.value) {
    console.log('❌ No user cookie, redirecting to login')
    return navigateTo('/login')
  }
  
  console.log('✅ Owner middleware passed')
})
