export default defineNuxtConfig({
  devtools: { enabled: true },
  css: [
    '~/assets/css/fonts.css',
    '~/assets/css/base.css',
    '~/assets/css/utilities.css',
    '~/assets/css/sidebar.css',
    '~/assets/css/layout.css',
    '~/assets/css/main.css'
  ],
  runtimeConfig: {
    jwtSecret: process.env.JWT_SECRET || 'your-secret-key',
    zohoClientId: process.env.ZOHO_CLIENT_ID,
    zohoClientSecret: process.env.ZOHO_CLIENT_SECRET,
    zohoRefreshToken: process.env.ZOHO_REFRESH_TOKEN,
    mqttBrokerUrl: process.env.MQTT_BROKER_URL || 'mqtt://localhost:1883',
    public: {
      apiBase: '/api'
    }
  },
  nitro: {
    experimental: {
      wasm: true
    },
    devServer: {
      host: '0.0.0.0',
      port: 2020,
    }
  },
  app: {
    head: {
      title: 'SI Dashboard',
      meta: [
        { charset: 'utf-8' },
        { name: 'viewport', content: 'width=device-width, initial-scale=1' },
        { name: 'description', content: 'Business Management Dashboard' }
      ],
      link: [
        { rel: 'icon', type: 'image/x-icon', href: '/favicon.ico' }
      ]
    }
  }
})
