export default defineEventHandler(async (event) => {
  try {
    // Clear cookies
    setCookie(event, 'auth-token', '', {
      httpOnly: true,
      secure: process.env.NODE_ENV === 'production',
      sameSite: 'strict',
      maxAge: 0
    })

    setCookie(event, 'user', '', {
      httpOnly: false,
      secure: process.env.NODE_ENV === 'production',
      sameSite: 'strict',
      maxAge: 0
    })

    return {
      success: true,
      message: 'Logged out successfully'
    }
  } catch (error) {
    throw createError({
      statusCode: 500,
      statusMessage: 'Logout failed'
    })
  }
})
