// Type definitions for SI Dashboard

export interface User {
  id: string
  email: string
  name: string
  role: 'owner' | 'admin' | 'user'
  isActive: boolean
  createdAt: Date
  updatedAt: Date
}

export interface Customer {
  id: string
  email: string
  password: string
  subscriptionTier: 'Basic' | 'Pro' | 'Advanced'
  seatLimit: number
  seatUsage: number
  isActive: boolean
  isLocked: boolean
  slug: string
  companyName: string
  logo?: string
  kundentyp?: string
  createdAt: Date
  updatedAt: Date
  modules: string[]
}

export interface Tenant {
  id: string
  customerId: string
  email: string
  subscriptionTier: string
  seatUsage: number
  seatLimit: number
  isActive: boolean
  isLocked: boolean
  createdAt: Date
  billingStatus: 'paid' | 'pending' | 'overdue'
  lastPaymentDate?: Date
  nextPaymentDate?: Date
}

export interface Subscription {
  id: string
  customerId: string
  tier: 'Basic' | 'Pro' | 'Advanced'
  seatLimit: number
  price: number
  billingCycle: 'monthly' | 'yearly'
  status: 'active' | 'cancelled' | 'suspended'
  startDate: Date
  endDate?: Date
}

export interface Module {
  id: string
  name: string
  slug: string
  description: string
  icon: string
  isEnabled: boolean
  subscriptionTiers: string[]
}

export interface FinancialData {
  revenue: number
  expenses: number
  profit: number
  invoices: Invoice[]
  estimates: Estimate[]
  salesOrders: SalesOrder[]
}

export interface Invoice {
  id: string
  number: string
  date: Date
  amount: number
  status: 'paid' | 'pending' | 'overdue'
  customer: string
  pdfUrl?: string
}

export interface Estimate {
  id: string
  number: string
  date: Date
  amount: number
  status: 'draft' | 'sent' | 'accepted' | 'rejected'
  customer: string
  pdfUrl?: string
}

export interface SalesOrder {
  id: string
  number: string
  date: Date
  amount: number
  status: 'pending' | 'in_progress' | 'completed'
  customer: string
}

export interface MarketingData {
  campaigns: Campaign[]
  leads: Lead[]
  analytics: MarketingAnalytics
}

export interface Campaign {
  id: string
  name: string
  type: string
  status: 'active' | 'paused' | 'completed'
  budget: number
  spent: number
  impressions: number
  clicks: number
  conversions: number
  startDate: Date
  endDate?: Date
}

export interface Lead {
  id: string
  name: string
  email: string
  phone?: string
  company?: string
  status: 'new' | 'contacted' | 'qualified' | 'converted' | 'lost'
  source: string
  score: number
  createdAt: Date
}

export interface MarketingAnalytics {
  totalLeads: number
  conversionRate: number
  costPerLead: number
  revenue: number
  roi: number
}

export interface ELearningData {
  courses: Course[]
  progress: LearningProgress[]
  certificates: Certificate[]
}

export interface Course {
  id: string
  title: string
  description: string
  duration: number
  difficulty: 'beginner' | 'intermediate' | 'advanced'
  category: string
  isPublished: boolean
  thumbnail?: string
  modules: CourseModule[]
}

export interface CourseModule {
  id: string
  title: string
  type: 'video' | 'text' | 'quiz'
  duration: number
  content: string
  order: number
}

export interface LearningProgress {
  id: string
  userId: string
  courseId: string
  moduleId: string
  progress: number
  completedAt?: Date
}

export interface Certificate {
  id: string
  userId: string
  courseId: string
  issuedAt: Date
  pdfUrl: string
}

export interface ProjectData {
  projects: Project[]
  tasks: Task[]
  teamMembers: TeamMember[]
}

export interface Project {
  id: string
  name: string
  description: string
  status: 'planning' | 'active' | 'on_hold' | 'completed' | 'cancelled'
  priority: 'low' | 'medium' | 'high' | 'urgent'
  startDate: Date
  endDate?: Date
  budget?: number
  progress: number
  teamMembers: string[]
  clientId?: string
}

export interface Task {
  id: string
  projectId: string
  title: string
  description: string
  status: 'todo' | 'in_progress' | 'review' | 'completed'
  priority: 'low' | 'medium' | 'high' | 'urgent'
  assigneeId: string
  dueDate?: Date
  createdAt: Date
  updatedAt: Date
}

export interface TeamMember {
  id: string
  name: string
  email: string
  role: string
  avatar?: string
  isActive: boolean
}

export interface SettingsData {
  users: User[]
  permissions: Permission[]
  seatUsage: number
  seatLimit: number
}

export interface Permission {
  id: string
  userId: string
  moduleId: string
  canRead: boolean
  canWrite: boolean
  canDelete: boolean
}

export interface ProfileData {
  id: string
  name: string
  email: string
  phone?: string
  address?: string
  ustIdNr?: string
  instagram?: string
  tiktok?: string
  facebook?: string
  salonname?: string
  mitarbeiteranzahl?: number
  kundennummer?: string
  betreuer?: string
  zahlart?: string
  kundentyp?: string
  avatar?: string
  isEditable: boolean
}

export interface ZohoContact {
  id: string
  name: string
  email: string
  phone?: string
  company?: string
  leadSource?: string
  status?: string
}

export interface ZohoIntegrationData {
  isConnected: boolean
  contacts: ZohoContact[]
  recentContacts: ZohoContact[]
  apiStatus: 'connected' | 'disconnected' | 'error'
}

export interface ApiResponse<T> {
  success: boolean
  data?: T
  error?: string
  message?: string
}

export interface PaginatedResponse<T> {
  data: T[]
  total: number
  page: number
  limit: number
  totalPages: number
}

export interface SearchParams {
  query?: string
  page?: number
  limit?: number
  sortBy?: string
  sortOrder?: 'asc' | 'desc'
  filters?: Record<string, any>
}

// Onboarding Module Types
export interface Tutorial {
  id: string
  title: string
  description: string
  content: string
  author: string
  createdAt: Date
  assignedUsers: string[]
  completedCount: number
  dueDate?: Date
}

export interface UploadedFile {
  id: string
  name: string
  type: 'video' | 'document' | 'pdf'
  size: number
  uploadedAt: Date
  url: string
}

export interface Assignment {
  id: string
  tutorial: Tutorial
  assignedTo: string
  userName: string
  status: 'pending' | 'completed' | 'overdue'
  dueDate?: Date
  completedAt?: Date
}
